/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.JavaDeploymentSourceUtil;
import com.intellij.remoteServer.impl.configuration.deployment.ArtifactDeploymentSourceImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaDeploymentSourceUtilImpl
extends JavaDeploymentSourceUtil {
    @NotNull
    public ArtifactDeploymentSource createArtifactDeploymentSource(@NotNull ArtifactPointer artifactPointer) {
        if (artifactPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactPointer", "com/intellij/remoteServer/impl/configuration/deployment/JavaDeploymentSourceUtilImpl", "createArtifactDeploymentSource"));
        }
        ArtifactDeploymentSourceImpl artifactDeploymentSourceImpl = new ArtifactDeploymentSourceImpl(artifactPointer);
        if (artifactDeploymentSourceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/JavaDeploymentSourceUtilImpl", "createArtifactDeploymentSource"));
        }
        return artifactDeploymentSourceImpl;
    }

    @NotNull
    public List<DeploymentSource> createArtifactDeploymentSources(@NotNull Project project2, @NotNull Collection<? extends Artifact> artifacts) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/configuration/deployment/JavaDeploymentSourceUtilImpl", "createArtifactDeploymentSources"));
        }
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/remoteServer/impl/configuration/deployment/JavaDeploymentSourceUtilImpl", "createArtifactDeploymentSources"));
        }
        ArrayList<DeploymentSource> sources = new ArrayList<DeploymentSource>();
        ArtifactPointerManager pointerManager = ArtifactPointerManager.getInstance((Project)project2);
        for (Artifact artifact : artifacts) {
            sources.add((DeploymentSource)this.createArtifactDeploymentSource(pointerManager.createPointer(artifact)));
        }
        ArrayList<DeploymentSource> arrayList = sources;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/JavaDeploymentSourceUtilImpl", "createArtifactDeploymentSources"));
        }
        return arrayList;
    }

    @NotNull
    public List<DeploymentSource> createArtifactDeploymentSources(Project project2, ArtifactType ... artifactTypes) {
        if (project2.isDefault()) {
            List<DeploymentSource> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/JavaDeploymentSourceUtilImpl", "createArtifactDeploymentSources"));
            }
            return list;
        }
        Artifact[] artifacts = ArtifactManager.getInstance((Project)project2).getArtifacts();
        ArrayList<Artifact> supportedArtifacts = new ArrayList<Artifact>();
        Set typeSet = ContainerUtil.set((Object[])artifactTypes);
        for (Artifact artifact : artifacts) {
            if (!typeSet.contains(artifact.getArtifactType())) continue;
            supportedArtifacts.add(artifact);
        }
        List<DeploymentSource> list = this.createArtifactDeploymentSources(project2, supportedArtifacts);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/JavaDeploymentSourceUtilImpl", "createArtifactDeploymentSources"));
        }
        return list;
    }
}

