/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reporting;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.reporting.FreezeLogger;
import com.intellij.reporting.ReporterKt;
import com.intellij.reporting.StatsSender;
import com.intellij.reporting.ThreadDumpInfo;
import com.intellij.util.Alarm;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FreezeLoggerImpl
extends FreezeLogger {
    private static final Logger LOG = Logger.getInstance(FreezeLoggerImpl.class);
    private static final Alarm ALARM = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
    private static final int MAX_ALLOWED_TIME = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUnderPerformanceMonitor(@Nullable Project project2, @NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/reporting/FreezeLoggerImpl", "runUnderPerformanceMonitor"));
        }
        if (!FreezeLoggerImpl.shouldReport() || FreezeLoggerImpl.isUnderDebug() || ApplicationManager.getApplication().isUnitTestMode()) {
            action.run();
            return;
        }
        ModalityState initial = ModalityState.current();
        ALARM.cancelAllRequests();
        ALARM.addRequest(() -> FreezeLoggerImpl.dumpThreads(project2, initial), 500);
        try {
            action.run();
        }
        finally {
            ALARM.cancelAllRequests();
        }
    }

    private static boolean shouldReport() {
        return Registry.is((String)"typing.freeze.report.dumps");
    }

    private static void dumpThreads(@Nullable Project project2, @NotNull ModalityState initialState) {
        if (initialState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialState", "com/intellij/reporting/FreezeLoggerImpl", "dumpThreads"));
        }
        ThreadInfo[] infos = ThreadDumper.getThreadInfos();
        String edtTrace = ThreadDumper.dumpEdtStackTrace((ThreadInfo[])infos);
        if (edtTrace.contains("java.lang.ClassLoader.loadClass")) {
            return;
        }
        boolean isInDumbMode = project2 != null && !project2.isDisposed() && DumbService.isDumb((Project)project2);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (initialState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialState", "com/intellij/reporting/FreezeLoggerImpl", "lambda$dumpThreads$1"));
            }
            if (!initialState.equals(ModalityState.current())) {
                return;
            }
            FreezeLoggerImpl.sendDumpsInBackground(infos, isInDumbMode);
        }, ModalityState.any());
    }

    private static void sendDumpsInBackground(ThreadInfo[] infos, boolean isInDumbMode) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ThreadDumpInfo info = new ThreadDumpInfo(infos, isInDumbMode);
            String report = ReporterKt.createReportLine("typing-freeze-dumps", info);
            if (!StatsSender.INSTANCE.send(report, true)) {
                LOG.debug("Error while reporting thread dump");
            }
        });
    }

    private static boolean isUnderDebug() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
    }
}

