/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SSBasedInspectionCompiledPatternsCache {
    private static final Key<Map<Configuration, MatchContext>> COMPILED_OPTIONS_KEY = Key.create((String)"SSR_INSPECTION_COMPILED_OPTIONS_KEY");

    @NotNull
    static Map<Configuration, MatchContext> getCompiledOptions(@NotNull List<Configuration> configurations, @NotNull Project project2) {
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspectionCompiledPatternsCache", "getCompiledOptions"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspectionCompiledPatternsCache", "getCompiledOptions"));
        }
        Map cache = (Map)ObjectUtils.notNull((Object)project2.getUserData(COMPILED_OPTIONS_KEY), new HashMap());
        if (!SSBasedInspectionCompiledPatternsCache.areConfigurationsInCache(configurations, cache)) {
            Matcher matcher = new Matcher(project2);
            matcher.precompileOptions(configurations, cache);
            project2.putUserData(COMPILED_OPTIONS_KEY, (Object)cache);
        }
        Map<Configuration, MatchContext> map = configurations.stream().collect(Collectors.toMap(Function.identity(), cache::get, (c1, c2) -> c2));
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspectionCompiledPatternsCache", "getCompiledOptions"));
        }
        return map;
    }

    private static boolean areConfigurationsInCache(@NotNull List<Configuration> configurations, @NotNull Map<Configuration, MatchContext> cache) {
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspectionCompiledPatternsCache", "areConfigurationsInCache"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspectionCompiledPatternsCache", "areConfigurationsInCache"));
        }
        for (Configuration configuration : configurations) {
            if (cache.containsKey(configuration)) continue;
            return false;
        }
        return true;
    }

    public static void removeFromCache(Configuration configuration, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspectionCompiledPatternsCache", "removeFromCache"));
        }
        Map cache = (Map)project2.getUserData(COMPILED_OPTIONS_KEY);
        if (cache != null) {
            cache.remove(configuration);
        }
    }
}

