/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Replacer {
    private final Project project;
    private ReplacementBuilder replacementBuilder;
    private ReplaceOptions options;
    private ReplacementContext context;
    private StructuralReplaceHandler replaceHandler;

    public Replacer(Project project2, ReplaceOptions options) {
        this.project = project2;
        this.options = options;
    }

    public static String stripTypedVariableDecoration(String type) {
        return type.substring(1, type.length() - 1);
    }

    public static int insertSubstitution(StringBuilder result2, int offset, ParameterInfo info, String image) {
        if (image.length() > 0) {
            result2.insert(offset + info.getStartIndex(), image);
        }
        return offset += image.length();
    }

    public String testReplace(String in, String what, String by, ReplaceOptions options) throws IncorrectOperationException {
        return this.testReplace(in, what, by, options, false);
    }

    public String testReplace(String in, String what, String by, ReplaceOptions options, boolean filePattern) {
        FileType type = options.getMatchOptions().getFileType();
        return this.testReplace(in, what, by, options, filePattern, false, type, null);
    }

    public String testReplace(String in, String what, String by, ReplaceOptions options, boolean filePattern, boolean createPhysicalFile, FileType sourceFileType, Language sourceDialect) {
        this.options = options;
        MatchOptions matchOptions = this.options.getMatchOptions();
        matchOptions.setSearchPattern(what);
        this.options.setReplacement(by);
        this.replacementBuilder = null;
        this.context = null;
        this.replaceHandler = null;
        matchOptions.clearVariableConstraints();
        MatcherImplUtil.transform(matchOptions);
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(matchOptions.getFileType());
        assert (profile2 != null);
        profile2.checkSearchPattern(this.project, matchOptions);
        Replacer.checkSupportedReplacementPattern(this.project, options);
        Matcher matcher = new Matcher(this.project);
        try {
            PsiElement nextSibling;
            PsiElement parent;
            PsiElement lastElement;
            PsiElement firstElement;
            if (options.getMatchOptions().getScope() == null) {
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(in, filePattern ? PatternTreeContext.File : PatternTreeContext.Block, sourceFileType, sourceDialect, null, this.project, createPhysicalFile);
                firstElement = elements[0];
                lastElement = elements[elements.length - 1];
                parent = firstElement.getParent();
                matchOptions.setScope((SearchScope)new LocalSearchScope(parent));
            } else {
                parent = ((LocalSearchScope)options.getMatchOptions().getScope()).getScope()[0];
                firstElement = parent.getFirstChild();
                lastElement = parent.getLastChild();
            }
            matchOptions.setResultIsContextMatch(true);
            CollectingMatchResultSink sink = new CollectingMatchResultSink();
            matcher.testFindMatches(sink, matchOptions);
            ArrayList<ReplacementInfo> resultPtrList = new ArrayList<ReplacementInfo>();
            for (MatchResult result2 : sink.getMatches()) {
                resultPtrList.add(this.buildReplacement(result2));
            }
            sink.getMatches().clear();
            int startOffset = firstElement.getTextRange().getStartOffset();
            int endOffset = filePattern ? 0 : parent.getTextLength() - lastElement.getTextRange().getEndOffset();
            PsiElement prevSibling = firstElement.getPrevSibling();
            if (prevSibling instanceof PsiWhiteSpace) {
                startOffset -= prevSibling.getTextLength() - 1;
            }
            if ((nextSibling = lastElement.getNextSibling()) instanceof PsiWhiteSpace) {
                endOffset -= nextSibling.getTextLength() - 1;
            }
            this.replaceAll(resultPtrList);
            String result3 = parent.getText();
            result3 = result3.substring(startOffset);
            String string = result3 = result3.substring(0, result3.length() - endOffset);
            return string;
        }
        catch (Exception e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        finally {
            options.getMatchOptions().setScope(null);
        }
    }

    public void replaceAll(List<ReplacementInfo> resultPtrList) {
        PsiElement lastAffectedElement = null;
        for (ReplacementInfo info : resultPtrList) {
            PsiElement element = info.getMatch(0);
            this.initContextAndHandler(element);
            if (this.replaceHandler == null) continue;
            this.replaceHandler.prepare(info);
        }
        for (ReplacementInfo aResultPtrList : resultPtrList) {
            PsiElement currentAffectedElement = this.doReplace(aResultPtrList);
            if (currentAffectedElement == lastAffectedElement) continue;
            if (lastAffectedElement != null) {
                this.reformatAndPostProcess(lastAffectedElement);
            }
            lastAffectedElement = currentAffectedElement;
        }
        this.reformatAndPostProcess(lastAffectedElement);
    }

    public void replace(ReplacementInfo info) {
        PsiElement element = info.getMatch(0);
        this.initContextAndHandler(element);
        if (this.replaceHandler != null) {
            this.replaceHandler.prepare(info);
        }
        this.reformatAndPostProcess(this.doReplace(info));
    }

    @Nullable
    private PsiElement doReplace(ReplacementInfo info) {
        ReplacementInfoImpl replacementInfo = (ReplacementInfoImpl)info;
        PsiElement element = replacementInfo.matchesPtrList.get(0).getElement();
        if (element == null || !element.isWritable() || !element.isValid()) {
            return null;
        }
        PsiElement elementParent = element.getParent();
        CommandProcessor.getInstance().executeCommand(this.project, () -> {
            ApplicationManager.getApplication().runWriteAction(() -> this.doReplace(element, replacementInfo));
            PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
        }, "ssreplace", (Object)"test");
        if (!elementParent.isValid() || !elementParent.isWritable()) {
            return null;
        }
        return elementParent;
    }

    private void reformatAndPostProcess(PsiElement elementParent) {
        if (elementParent == null) {
            return;
        }
        Runnable action = () -> {
            PsiFile containingFile = elementParent.getContainingFile();
            if (containingFile != null && this.options.isToReformatAccordingToStyle()) {
                if (containingFile.getVirtualFile() != null) {
                    PsiDocumentManager.getInstance((Project)this.project).commitDocument(FileDocumentManager.getInstance().getDocument(containingFile.getVirtualFile()));
                }
                int parentOffset = elementParent.getTextRange().getStartOffset();
                CodeStyleManager.getInstance((Project)this.project).reformatRange((PsiElement)containingFile, parentOffset, parentOffset + elementParent.getTextLength(), true);
            }
            if (this.replaceHandler != null) {
                this.replaceHandler.postProcess(elementParent, this.options);
            }
        };
        CommandProcessor.getInstance().executeCommand(this.project, () -> ApplicationManager.getApplication().runWriteAction(action), "reformat and shorten refs after ssr", (Object)"test");
    }

    private void doReplace(final PsiElement elementToReplace, final ReplacementInfoImpl info) {
        CodeStyleManager.getInstance((Project)this.project).performActionWithFormatterDisabled(new Runnable(){

            @Override
            public void run() {
                Replacer.this.initContextAndHandler(elementToReplace);
                ((Replacer)Replacer.this).context.replacementInfo = info;
                if (Replacer.this.replaceHandler != null) {
                    Replacer.this.replaceHandler.replace(info, Replacer.this.options);
                }
            }
        });
    }

    private void initContextAndHandler(PsiElement psiContext) {
        StructuralSearchProfile profile2;
        if (this.context == null) {
            this.context = new ReplacementContext(this.options, this.project);
        }
        if (this.replaceHandler == null && (profile2 = StructuralSearchUtil.getProfileByPsiElement(psiContext)) != null) {
            this.replaceHandler = profile2.getReplaceHandler(this.context);
        }
    }

    public static void handleComments(PsiElement el, PsiElement replacement, ReplacementContext context) throws IncorrectOperationException {
        PsiElement firstChild;
        PsiElement lastChild;
        ReplacementInfoImpl replacementInfo = context.replacementInfo;
        if (replacementInfo.elementToVariableNameMap == null) {
            replacementInfo.elementToVariableNameMap = new HashMap<PsiElement, String>(1);
            Map<String, MatchResult> variableMap = replacementInfo.variableMap;
            if (variableMap != null) {
                for (String name : variableMap.keySet()) {
                    Replacer.fill(name, replacementInfo.variableMap.get(name), replacementInfo.elementToVariableNameMap);
                }
            }
        }
        if ((lastChild = el.getLastChild()) instanceof PsiComment && replacementInfo.elementToVariableNameMap.get(lastChild) == null && !(replacement.getLastChild() instanceof PsiComment)) {
            PsiElement firstElementAfterStatementEnd = lastChild;
            for (PsiElement curElement = firstElementAfterStatementEnd.getPrevSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getPrevSibling()) {
                firstElementAfterStatementEnd = curElement;
            }
            replacement.addRangeAfter(firstElementAfterStatementEnd, lastChild, replacement.getLastChild());
        }
        if ((firstChild = el.getFirstChild()) instanceof PsiComment && !(firstChild instanceof PsiDocCommentBase) && replacementInfo.elementToVariableNameMap.get(firstChild) == null) {
            PsiElement lastElementBeforeStatementStart = firstChild;
            for (PsiElement curElement = lastElementBeforeStatementStart.getNextSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getNextSibling()) {
                lastElementBeforeStatementStart = curElement;
            }
            replacement.addRangeBefore(firstChild, lastElementBeforeStatementStart, replacement.getFirstChild());
        }
    }

    private static void fill(String name, MatchResult matchResult, Map<PsiElement, String> elementToVariableNameMap) {
        boolean b;
        boolean bl = b = matchResult.isMultipleMatch() || matchResult.isScopeMatch();
        if (matchResult.hasSons() && b) {
            for (MatchResult r : matchResult.getAllSons()) {
                Replacer.fill(name, r, elementToVariableNameMap);
            }
        } else if (!b && matchResult.getMatchRef() != null) {
            elementToVariableNameMap.put(matchResult.getMatch(), name);
        }
    }

    public static void checkSupportedReplacementPattern(Project project2, ReplaceOptions options) throws UnsupportedPatternException {
        try {
            String search = options.getMatchOptions().getSearchPattern();
            String replacement = options.getReplacement();
            FileType fileType = options.getMatchOptions().getFileType();
            Template template = TemplateManager.getInstance(project2).createTemplate("", "", search);
            Template template2 = TemplateManager.getInstance(project2).createTemplate("", "", replacement);
            int segmentCount = template2.getSegmentsCount();
            for (int i2 = 0; i2 < segmentCount; ++i2) {
                String searchSegmentName;
                int j;
                String replacementSegmentName = template2.getSegmentName(i2);
                int segmentCount2 = template.getSegmentsCount();
                for (j = 0; j < segmentCount2 && !replacementSegmentName.equals(searchSegmentName = template.getSegmentName(j)); ++j) {
                    if (!replacementSegmentName.startsWith(searchSegmentName) || replacementSegmentName.charAt(searchSegmentName.length()) != '_') continue;
                    try {
                        Integer.parseInt(replacementSegmentName.substring(searchSegmentName.length() + 1));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (j != segmentCount2) continue;
                ReplacementVariableDefinition definition = options.getVariableDefinition(replacementSegmentName);
                if (definition == null || definition.getScriptCodeConstraint().length() <= 2) {
                    throw new UnsupportedPatternException(SSRBundle.message("replacement.variable.is.not.defined.message", replacementSegmentName));
                }
                String message = ScriptSupport.checkValidScript(StringUtil.stripQuotesAroundValue((String)definition.getScriptCodeConstraint()));
                if (message == null) continue;
                throw new UnsupportedPatternException(SSRBundle.message("replacement.variable.is.not.valid", replacementSegmentName, message));
            }
            StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(fileType);
            assert (profile2 != null);
            profile2.checkReplacementPattern(project2, options);
        }
        catch (IncorrectOperationException ex) {
            throw new UnsupportedPatternException(SSRBundle.message("incorrect.pattern.message", new Object[0]));
        }
    }

    public ReplacementInfo buildReplacement(MatchResult result2) {
        ArrayList<SmartPsiElementPointer> l = new ArrayList<SmartPsiElementPointer>();
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.project);
        if ("__multi_line__".equals(result2.getName())) {
            Iterator<MatchResult> i2 = result2.getAllSons().iterator();
            while (i2.hasNext()) {
                MatchResult r = i2.next();
                if (!"__line__".equals(r.getName())) continue;
                PsiElement element = r.getMatch();
                if (element instanceof PsiDocCommentBase && i2.hasNext()) {
                    MatchResult matchResult = i2.next();
                    if ("__line__".equals(matchResult.getName()) && StructuralSearchUtil.isDocCommentOwner(matchResult.getMatch())) {
                        element = matchResult.getMatch();
                    } else {
                        l.add(manager.createSmartPsiElementPointer(element));
                        element = matchResult.getMatch();
                    }
                }
                l.add(manager.createSmartPsiElementPointer(element));
            }
        } else {
            l.add(manager.createSmartPsiElementPointer(result2.getMatch()));
        }
        ReplacementInfoImpl replacementInfo = new ReplacementInfoImpl();
        replacementInfo.matchesPtrList = l;
        if (this.replacementBuilder == null) {
            this.replacementBuilder = new ReplacementBuilder(this.project, this.options);
        }
        replacementInfo.result = this.replacementBuilder.process(result2, replacementInfo, this.options.getMatchOptions().getFileType());
        replacementInfo.matchResult = result2;
        return replacementInfo;
    }
}

