/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.openapi.module.Module;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.impl.AbstractBuildTask;
import org.jetbrains.annotations.NotNull;

public class ModuleBuildTaskImpl
extends AbstractBuildTask
implements ModuleBuildTask {
    @NotNull
    private final Module myModule;
    private final boolean myIncludeDependentModules;
    private final boolean myIncludeRuntimeDependencies;

    public ModuleBuildTaskImpl(@NotNull Module module2, boolean isIncrementalBuild) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/task/impl/ModuleBuildTaskImpl", "<init>"));
        }
        this(module2, isIncrementalBuild, false, false);
    }

    public ModuleBuildTaskImpl(@NotNull Module module2, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/task/impl/ModuleBuildTaskImpl", "<init>"));
        }
        super(isIncrementalBuild);
        this.myModule = module2;
        this.myIncludeDependentModules = includeDependentModules;
        this.myIncludeRuntimeDependencies = includeRuntimeDependencies;
    }

    @NotNull
    public Module getModule() {
        Module module2 = this.myModule;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/task/impl/ModuleBuildTaskImpl", "getModule"));
        }
        return module2;
    }

    public boolean isIncludeDependentModules() {
        return this.myIncludeDependentModules;
    }

    public boolean isIncludeRuntimeDependencies() {
        return this.myIncludeRuntimeDependencies;
    }

    @NotNull
    public String getPresentableName() {
        String string = "Module '" + this.myModule.getName() + "' build task";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/task/impl/ModuleBuildTaskImpl", "getPresentableName"));
        }
        return string;
    }
}

