/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.AbstractProjectTask;
import com.intellij.task.impl.ArtifactBuildTaskImpl;
import com.intellij.task.impl.InternalProjectTaskRunner;
import com.intellij.task.impl.ModuleBuildTaskImpl;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTaskManagerImpl
extends ProjectTaskManager {
    private final ProjectTaskRunner myDefaultProjectTaskRunner;

    public ProjectTaskManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/task/impl/ProjectTaskManagerImpl", "<init>"));
        }
        super(project2);
        this.myDefaultProjectTaskRunner = new InternalProjectTaskRunner();
    }

    public void build(@NotNull Module[] modules, @Nullable ProjectTaskNotification callback) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/task/impl/ProjectTaskManagerImpl", "build"));
        }
        this.run(this.createModulesBuildTask(modules, true, true, false), callback);
    }

    public void rebuild(@NotNull Module[] modules, @Nullable ProjectTaskNotification callback) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/task/impl/ProjectTaskManagerImpl", "rebuild"));
        }
        this.run(this.createModulesBuildTask(modules, false, false, false), callback);
    }

    public void compile(@NotNull VirtualFile[] files, @Nullable ProjectTaskNotification callback) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/task/impl/ProjectTaskManagerImpl", "compile"));
        }
        List buildTasks = Arrays.stream(files).collect(Collectors.groupingBy(file2 -> ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getModuleForFile(file2, false))).entrySet().stream().map(entry -> new ModuleFilesBuildTaskImpl((Module)entry.getKey(), false, (Collection)entry.getValue())).collect(Collectors.toList());
        this.run(new ProjectTaskList(buildTasks), callback);
    }

    public void build(@NotNull Artifact[] artifacts, @Nullable ProjectTaskNotification callback) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/task/impl/ProjectTaskManagerImpl", "build"));
        }
        this.doBuild(artifacts, callback, true);
    }

    public void rebuild(@NotNull Artifact[] artifacts, @Nullable ProjectTaskNotification callback) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/task/impl/ProjectTaskManagerImpl", "rebuild"));
        }
        this.doBuild(artifacts, callback, false);
    }

    public void buildAllModules(@Nullable ProjectTaskNotification callback) {
        this.run(this.createAllModulesBuildTask(true, this.myProject), callback);
    }

    public void rebuildAllModules(@Nullable ProjectTaskNotification callback) {
        this.run(this.createAllModulesBuildTask(false, this.myProject), callback);
    }

    public ProjectTask createAllModulesBuildTask(boolean isIncrementalBuild, Project project2) {
        return this.createModulesBuildTask(ModuleManager.getInstance((Project)project2).getModules(), isIncrementalBuild, false, false);
    }

    public ProjectTask createModulesBuildTask(Module module2, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return this.createModulesBuildTask((Module[])ContainerUtil.ar((Object[])new Module[]{module2}), isIncrementalBuild, includeDependentModules, includeRuntimeDependencies);
    }

    public ProjectTask createModulesBuildTask(Module[] modules, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return modules.length == 1 ? new ModuleBuildTaskImpl(modules[0], isIncrementalBuild, includeDependentModules, includeRuntimeDependencies) : new ProjectTaskList(ContainerUtil.map((Collection)ContainerUtil.list((Object[])modules), module2 -> new ModuleBuildTaskImpl((Module)module2, isIncrementalBuild, includeDependentModules, includeRuntimeDependencies)));
    }

    public ProjectTask createArtifactsBuildTask(boolean isIncrementalBuild, Artifact ... artifacts) {
        return artifacts.length == 1 ? new ArtifactBuildTaskImpl(artifacts[0], isIncrementalBuild) : new ProjectTaskList(ContainerUtil.map((Collection)ContainerUtil.list((Object[])artifacts), artifact -> new ArtifactBuildTaskImpl((Artifact)artifact, isIncrementalBuild)));
    }

    public void run(@NotNull ProjectTask projectTask, @Nullable ProjectTaskNotification callback) {
        if (projectTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectTask", "com/intellij/task/impl/ProjectTaskManagerImpl", "run"));
        }
        this.run(new ProjectTaskContext(), projectTask, callback);
    }

    public void run(@NotNull ProjectTaskContext context, @NotNull ProjectTask projectTask, final @Nullable ProjectTaskNotification callback) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/task/impl/ProjectTaskManagerImpl", "run"));
        }
        if (projectTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectTask", "com/intellij/task/impl/ProjectTaskManagerImpl", "run"));
        }
        SmartList toRun = new SmartList();
        Consumer taskClassifier = arg_0 -> this.lambda$run$5((List)toRun, arg_0);
        ProjectTaskManagerImpl.visitTasks((Collection<? extends ProjectTask>)(projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask)), (Consumer<Collection<? extends ProjectTask>>)taskClassifier);
        if (toRun.isEmpty()) {
            ProjectTaskManagerImpl.sendSuccessNotify(callback);
            return;
        }
        final AtomicInteger inProgressCounter = new AtomicInteger(toRun.size());
        final AtomicInteger errorsCounter = new AtomicInteger();
        final AtomicInteger warningsCounter = new AtomicInteger();
        final AtomicBoolean abortedFlag = new AtomicBoolean(false);
        ProjectTaskNotification chunkStatusNotification = callback == null ? null : new ProjectTaskNotification(){

            public void finished(@NotNull ProjectTaskResult executionResult) {
                if (executionResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/intellij/task/impl/ProjectTaskManagerImpl$1", "finished"));
                }
                int inProgress = inProgressCounter.decrementAndGet();
                int allErrors = errorsCounter.addAndGet(executionResult.getErrors());
                int allWarnings = warningsCounter.addAndGet(executionResult.getWarnings());
                if (executionResult.isAborted()) {
                    abortedFlag.set(true);
                }
                if (inProgress == 0) {
                    callback.finished(new ProjectTaskResult(abortedFlag.get(), allErrors, allWarnings));
                }
            }
        };
        toRun.forEach(pair -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/task/impl/ProjectTaskManagerImpl", "lambda$run$6"));
            }
            if (((Collection)pair.second).isEmpty()) {
                ProjectTaskManagerImpl.sendSuccessNotify(chunkStatusNotification);
            } else {
                ((ProjectTaskRunner)pair.first).run(this.myProject, context, chunkStatusNotification, (Collection)pair.second);
            }
        });
    }

    private static void sendSuccessNotify(@Nullable ProjectTaskNotification notification) {
        if (notification != null) {
            notification.finished(new ProjectTaskResult(false, 0, 0));
        }
    }

    private static void visitTasks(@NotNull Collection<? extends ProjectTask> tasks, @NotNull Consumer<Collection<? extends ProjectTask>> consumer) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/task/impl/ProjectTaskManagerImpl", "visitTasks"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/task/impl/ProjectTaskManagerImpl", "visitTasks"));
        }
        for (ProjectTask projectTask : tasks) {
            Collection<ProjectTask> taskDependencies = projectTask instanceof AbstractProjectTask ? ((AbstractProjectTask)projectTask).getDependsOn() : (projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask));
            ProjectTaskManagerImpl.visitTasks(taskDependencies, consumer);
        }
        consumer.consume(tasks);
    }

    @NotNull
    private static ProjectTaskRunner[] getTaskRunners() {
        ProjectTaskRunner[] projectTaskRunnerArray = (ProjectTaskRunner[])ProjectTaskRunner.EP_NAME.getExtensions();
        if (projectTaskRunnerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/task/impl/ProjectTaskManagerImpl", "getTaskRunners"));
        }
        return projectTaskRunnerArray;
    }

    private void doBuild(@NotNull Artifact[] artifacts, @Nullable ProjectTaskNotification callback, boolean isIncrementalBuild) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/task/impl/ProjectTaskManagerImpl", "doBuild"));
        }
        this.run(this.createArtifactsBuildTask(isIncrementalBuild, artifacts), callback);
    }

    private /* synthetic */ void lambda$run$5(List toRun, Collection tasks) {
        Map<ProjectTaskRunner, List<ProjectTask>> toBuild = tasks.stream().collect(Collectors.groupingBy(aTask -> {
            for (ProjectTaskRunner runner : ProjectTaskManagerImpl.getTaskRunners()) {
                if (!runner.canRun(aTask)) continue;
                return runner;
            }
            return this.myDefaultProjectTaskRunner;
        }));
        for (Map.Entry<ProjectTaskRunner, List<ProjectTask>> entry : toBuild.entrySet()) {
            toRun.add(Pair.create((Object)entry.getKey(), entry.getValue()));
        }
    }
}

