/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ThrowableRunnable;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TObjectLongHashMap;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class CpuUsageData {
    private static final ThreadMXBean ourThreadMXBean = ManagementFactory.getThreadMXBean();
    private static final List<GarbageCollectorMXBean> ourGcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    final long durationMs;
    private final TObjectLongHashMap<GarbageCollectorMXBean> myGcTimes;
    private final TLongLongHashMap myThreadTimes;

    private CpuUsageData(long durationMs, TObjectLongHashMap<GarbageCollectorMXBean> gcTimes, TLongLongHashMap threadTimes) {
        this.durationMs = durationMs;
        this.myGcTimes = gcTimes;
        this.myThreadTimes = threadTimes;
    }

    String getGcStats() {
        ArrayList<Pair<Long, String>> times = new ArrayList<Pair<Long, String>>();
        this.myGcTimes.forEachEntry((bean, time) -> {
            times.add(Pair.create((Object)time, (Object)bean.getName()));
            return true;
        });
        return CpuUsageData.printLongestNames(times);
    }

    String getThreadStats() {
        ArrayList<Pair<Long, String>> times = new ArrayList<Pair<Long, String>>();
        this.myThreadTimes.forEachEntry((id, time) -> {
            ThreadInfo info = ourThreadMXBean.getThreadInfo(id);
            times.add(Pair.create((Object)CpuUsageData.toMillis(time), (Object)(info == null ? "<unknown>" : info.getThreadName())));
            return true;
        });
        return CpuUsageData.printLongestNames(times);
    }

    @NotNull
    private static String printLongestNames(List<Pair<Long, String>> times) {
        String stats = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(times).sortedBy(p -> -((Long)p.first).longValue())).filter(p -> (Long)p.first > 10L)).limit(10L)).map(p -> "\"" + (String)p.second + "\" took " + p.first + "ms").joining((CharSequence)", ");
        String string = stats.isEmpty() ? "insignificant" : stats;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/CpuUsageData", "printLongestNames"));
        }
        return string;
    }

    private static long toMillis(long timeNs) {
        return timeNs / 1000000L;
    }

    static <E extends Throwable> CpuUsageData measureCpuUsage(ThrowableRunnable<E> runnable2) throws E {
        TObjectLongHashMap gcTimes = new TObjectLongHashMap();
        for (GarbageCollectorMXBean garbageCollectorMXBean : ourGcBeans) {
            gcTimes.put((Object)garbageCollectorMXBean, garbageCollectorMXBean.getCollectionTime());
        }
        TLongLongHashMap threadTimes = new TLongLongHashMap();
        for (long id : ourThreadMXBean.getAllThreadIds()) {
            threadTimes.put(id, ourThreadMXBean.getThreadUserTime(id));
        }
        long l = System.currentTimeMillis();
        runnable2.run();
        long duration = System.currentTimeMillis() - l;
        for (long id : ourThreadMXBean.getAllThreadIds()) {
            threadTimes.put(id, ourThreadMXBean.getThreadUserTime(id) - threadTimes.get(id));
        }
        Object object = ourGcBeans.iterator();
        while (object.hasNext()) {
            GarbageCollectorMXBean bean = (GarbageCollectorMXBean)object.next();
            gcTimes.put((Object)bean, bean.getCollectionTime() - gcTimes.get((Object)bean));
        }
        return new CpuUsageData(duration, (TObjectLongHashMap<GarbageCollectorMXBean>)gcTimes, threadTimes);
    }
}

