/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MapDataContext
implements DataContext {
    private final Map<String, Object> myMap;

    public MapDataContext() {
        this.myMap = new HashMap<String, Object>();
    }

    public MapDataContext(@NotNull Map<DataKey<?>, Object> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/testFramework/MapDataContext", "<init>"));
        }
        this.myMap = new HashMap<String, Object>();
        context.forEach((k, v) -> this.myMap.put(k.getName(), v));
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/testFramework/MapDataContext", "getData"));
        }
        return this.myMap.get(dataId);
    }

    public void put(@NotNull String dataId, Object data) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/testFramework/MapDataContext", "put"));
        }
        this.myMap.put(dataId, data);
    }

    public <T> void put(@NotNull DataKey<T> dataKey, T data) {
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/testFramework/MapDataContext", "put"));
        }
        this.put(dataKey.getName(), data);
    }
}

