/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplicationEx;
import com.intellij.mock.MockProjectEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public abstract class PlatformLiteFixture
extends UsefulTestCase {
    protected MockProjectEx myProject;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Extensions.cleanRootArea((Disposable)this.getTestRootDisposable());
    }

    public static MockApplicationEx getApplication() {
        return (MockApplicationEx)ApplicationManager.getApplication();
    }

    public void initApplication() {
        MockApplicationEx instance = new MockApplicationEx(this.getTestRootDisposable());
        ApplicationManager.setApplication((Application)instance, () -> FileTypeManager.getInstance(), (Disposable)this.getTestRootDisposable());
        PlatformLiteFixture.getApplication().registerService(EncodingManager.class, EncodingManagerImpl.class);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            PlatformLiteFixture.clearFields((Object)this);
            this.myProject = null;
        }
    }

    protected <T> void registerExtension(ExtensionPointName<T> extensionPointName, @NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/testFramework/PlatformLiteFixture", "registerExtension"));
        }
        this.registerExtension(Extensions.getRootArea(), extensionPointName, t);
    }

    public <T> void registerExtension(ExtensionsArea area, ExtensionPointName<T> name, T t) {
        this.registerExtensionPoint(area, name, t.getClass());
        PlatformTestUtil.registerExtension(area, name, t, this.getTestRootDisposable());
    }

    protected <T> void registerExtensionPoint(ExtensionPointName<T> extensionPointName, Class<T> aClass) {
        this.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass);
    }

    protected <T> void registerExtensionPoint(ExtensionsArea area, ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        String name = extensionPointName.getName();
        if (!area.hasExtensionPoint(name)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name, aClass.getName(), kind);
        }
    }

    protected void registerComponentImplementation(MutablePicoContainer container, Class<?> key2, Class<?> implementation) {
        container.unregisterComponent(key2);
        container.registerComponentImplementation(key2, implementation);
    }

    public static <T> T registerComponentInstance(MutablePicoContainer container, Class<T> key2, T implementation) {
        Object old = container.getComponentInstance(key2);
        container.unregisterComponent(key2);
        container.registerComponentInstance(key2, implementation);
        return (T)old;
    }

    public static <T> T registerComponentInstance(ComponentManager container, Class<T> key2, T implementation) {
        return PlatformLiteFixture.registerComponentInstance((MutablePicoContainer)container.getPicoContainer(), key2, implementation);
    }
}

