/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.testFramework.UtilKt;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class VfsTestUtil {
    public static final Key<String> TEST_DATA_FILE_PATH = Key.create((String)"TEST_DATA_FILE_PATH");

    private VfsTestUtil() {
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/testFramework/VfsTestUtil", "createFile"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/testFramework/VfsTestUtil", "createFile"));
        }
        VirtualFile virtualFile = VfsTestUtil.createFile(root, relativePath, "");
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/VfsTestUtil", "createFile"));
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, @NotNull String text) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/testFramework/VfsTestUtil", "createFile"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/testFramework/VfsTestUtil", "createFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/VfsTestUtil", "createFile"));
        }
        VirtualFile virtualFile = VfsTestUtil.createFileOrDir(root, relativePath, text, false);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/VfsTestUtil", "createFile"));
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile createDir(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/testFramework/VfsTestUtil", "createDir"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/testFramework/VfsTestUtil", "createDir"));
        }
        VirtualFile virtualFile = VfsTestUtil.createFileOrDir(root, relativePath, "", true);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/VfsTestUtil", "createDir"));
        }
        return virtualFile;
    }

    @NotNull
    private static VirtualFile createFileOrDir(VirtualFile root, String relativePath, String text, boolean dir) {
        VirtualFile virtualFile;
        try {
            virtualFile = (VirtualFile)WriteAction.compute(() -> {
                VirtualFile file2;
                VirtualFile parent = root;
                for (String name : StringUtil.tokenize((String)PathUtil.getParentPath((String)relativePath), (String)"/")) {
                    VirtualFile child = parent.findChild(name);
                    if (child == null || !child.isValid()) {
                        child = parent.createChildDirectory(VfsTestUtil.class, name);
                    }
                    parent = child;
                }
                parent.getChildren();
                String name = PathUtil.getFileName((String)relativePath);
                if (dir) {
                    file2 = parent.createChildDirectory(VfsTestUtil.class, name);
                } else {
                    file2 = parent.findChild(name);
                    if (file2 == null) {
                        file2 = parent.createChildData(VfsTestUtil.class, name);
                    }
                    VfsUtil.saveText((VirtualFile)file2, (String)text);
                }
                return file2;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/VfsTestUtil", "createFileOrDir"));
        }
        return virtualFile;
    }

    public static void deleteFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/VfsTestUtil", "deleteFile"));
        }
        UtilKt.deleteFile(file2);
    }

    public static void clearContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/VfsTestUtil", "clearContent"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/VfsTestUtil", "lambda$clearContent$1"));
            }
            try {
                VfsUtil.saveText((VirtualFile)file2, (String)"");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void overwriteTestData(@NotNull String filePath, @NotNull String actual) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/VfsTestUtil", "overwriteTestData"));
        }
        if (actual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actual", "com/intellij/testFramework/VfsTestUtil", "overwriteTestData"));
        }
        try {
            FileUtil.writeToFile((File)new File(filePath), (String)actual);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static VirtualFile findFileByCaseSensitivePath(@NotNull String absolutePath) {
        if (absolutePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "absolutePath", "com/intellij/testFramework/VfsTestUtil", "findFileByCaseSensitivePath"));
        }
        String vfsPath = FileUtil.toSystemIndependentName((String)absolutePath);
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(vfsPath);
        Assert.assertNotNull((String)("file " + absolutePath + " not found"), (Object)vFile);
        String realVfsPath = vFile.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !vfsPath.equals(realVfsPath) && vfsPath.equalsIgnoreCase(realVfsPath)) {
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + vfsPath + "\nreal path " + realVfsPath));
        }
        VirtualFile virtualFile = vFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/VfsTestUtil", "findFileByCaseSensitivePath"));
        }
        return virtualFile;
    }

    public static void assertFilePathEndsWithCaseSensitivePath(@NotNull VirtualFile file2, @NotNull String suffixPath) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/VfsTestUtil", "assertFilePathEndsWithCaseSensitivePath"));
        }
        if (suffixPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixPath", "com/intellij/testFramework/VfsTestUtil", "assertFilePathEndsWithCaseSensitivePath"));
        }
        String vfsSuffixPath = FileUtil.toSystemIndependentName((String)suffixPath);
        String vfsPath = file2.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !vfsPath.endsWith(vfsSuffixPath) && StringUtil.endsWithIgnoreCase((String)vfsPath, (String)vfsSuffixPath)) {
            String realSuffixPath = vfsPath.substring(vfsPath.length() - vfsSuffixPath.length());
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + suffixPath + "\nreal path " + realSuffixPath));
        }
    }

    @NotNull
    public static List<VFileEvent> getEvents(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/testFramework/VfsTestUtil", "getEvents"));
        }
        final ArrayList<VFileEvent> allEvents = new ArrayList<VFileEvent>();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/testFramework/VfsTestUtil$1", "after"));
                }
                allEvents.addAll(events);
            }
        });
        try {
            action.run();
        }
        finally {
            connection.disconnect();
        }
        ArrayList<VFileEvent> arrayList = allEvents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/VfsTestUtil", "getEvents"));
        }
        return arrayList;
    }

    @NotNull
    public static List<String> print(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/testFramework/VfsTestUtil", "print"));
        }
        List<String> list = events.stream().map(VfsTestUtil::print).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/VfsTestUtil", "print"));
        }
        return list;
    }

    private static String print(VFileEvent e) {
        int type = 63;
        if (e instanceof VFileCreateEvent) {
            type = 67;
        } else if (e instanceof VFileDeleteEvent) {
            type = 68;
        } else if (e instanceof VFileContentChangeEvent) {
            type = 85;
        } else if (e instanceof VFilePropertyChangeEvent) {
            type = 80;
        }
        return (char)type + " : " + e.getPath();
    }
}

