/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.testIntegration.ConfigurationByRecordProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;

class RunConfigurationByRecordProvider
implements ConfigurationByRecordProvider {
    private final Project myProject;
    private final Map<Integer, RunnerAndConfigurationSettings> myConfigurationsMap = ContainerUtil.newHashMap();

    public RunConfigurationByRecordProvider(Project project2) {
        this.myProject = project2;
        this.initRunConfigurationsMap();
    }

    @Override
    public RunnerAndConfigurationSettings getConfiguration(TestStateStorage.Record record) {
        Integer runConfigurationHash = new Integer((int)record.configurationHash);
        return this.myConfigurationsMap.get(runConfigurationHash);
    }

    private void initRunConfigurationsMap() {
        ConfigurationType[] types;
        RunManagerEx manager = RunManagerEx.getInstanceEx(this.myProject);
        for (ConfigurationType type : types = manager.getConfigurationFactories()) {
            Map<String, List<RunnerAndConfigurationSettings>> structure = manager.getStructure(type);
            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> e : structure.entrySet()) {
                for (RunnerAndConfigurationSettings settings : e.getValue()) {
                    this.myConfigurationsMap.put(settings.getName().hashCode(), settings);
                }
            }
        }
    }
}

