/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.CompoundScheme;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.tools.BaseToolManager;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolEditorDialog;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolsPanel<T extends Tool>
extends JPanel {
    private final CheckboxTree myTree;
    private final AnActionButton myAddButton;
    private final AnActionButton myCopyButton;
    private final AnActionButton myEditButton;
    private final AnActionButton myMoveUpButton;
    private final AnActionButton myMoveDownButton;
    private final AnActionButton myRemoveButton;
    private boolean myIsModified = false;
    private final CompoundScheme.MutatorHelper<ToolsGroup<T>, T> mutatorHelper = new CompoundScheme.MutatorHelper();

    protected BaseToolsPanel() {
        this.myTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof CheckedTreeNode)) {
                    return;
                }
                Object object = ((CheckedTreeNode)value).getUserObject();
                if (object instanceof ToolsGroup) {
                    String groupName = ((ToolsGroup)object).getName();
                    if (groupName != null) {
                        this.getTextRenderer().append(groupName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else {
                        this.getTextRenderer().append("[unnamed group]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                } else if (object instanceof Tool) {
                    this.getTextRenderer().append(((Tool)object).getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        }, new CheckedTreeNode(null)){

            protected void onDoubleClick(CheckedTreeNode node) {
                BaseToolsPanel.this.editSelected();
            }

            protected void onNodeStateChanged(CheckedTreeNode node) {
                BaseToolsPanel.this.myIsModified = true;
            }
        };
        this.myTree.setRootVisible(false);
        this.myTree.getEmptyText().setText(ToolsBundle.message("tools.not.configured", new Object[0]));
        this.myTree.setSelectionModel(new DefaultTreeSelectionModel());
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.setLayout(new BorderLayout());
        this.myCopyButton = new AnActionButton(ToolsBundle.message("tools.copy.button", new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(AnActionEvent e) {
                Tool originalTool = BaseToolsPanel.this.getSelectedTool();
                if (originalTool != null) {
                    ToolEditorDialog dlg = BaseToolsPanel.this.createToolEditorDialog(ToolsBundle.message("tools.copy.title", new Object[0]));
                    Tool toolCopy = new Tool();
                    toolCopy.copyFrom(originalTool);
                    dlg.setData(toolCopy, BaseToolsPanel.this.getGroups());
                    if (dlg.showAndGet()) {
                        BaseToolsPanel.this.insertNewTool(dlg.getData(), true);
                    }
                    BaseToolsPanel.this.myTree.requestFocus();
                }
            }
        };
        this.add((Component)ToolbarDecorator.createDecorator((JTree)((Object)this.myTree)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ToolEditorDialog dlg = BaseToolsPanel.this.createToolEditorDialog(ToolsBundle.message("tools.add.title", new Object[0]));
                Tool tool = new Tool();
                tool.setUseConsole(true);
                tool.setFilesSynchronizedAfterRun(true);
                tool.setShownInMainMenu(true);
                tool.setShownInEditor(true);
                tool.setShownInProjectViews(true);
                tool.setShownInSearchResultsPopup(true);
                tool.setEnabled(true);
                dlg.setData(tool, BaseToolsPanel.this.getGroups());
                if (dlg.showAndGet()) {
                    BaseToolsPanel.this.insertNewTool(dlg.getData(), true);
                }
                BaseToolsPanel.this.myTree.requestFocus();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BaseToolsPanel.this.removeSelected();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BaseToolsPanel.this.editSelected();
                BaseToolsPanel.this.myTree.requestFocus();
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BaseToolsPanel.this.moveNode(Direction.UP);
                BaseToolsPanel.this.myIsModified = true;
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BaseToolsPanel.this.moveNode(Direction.DOWN);
                BaseToolsPanel.this.myIsModified = true;
            }
        }).addExtraAction(this.myCopyButton).createPanel(), "Center");
        this.myAddButton = ToolbarDecorator.findAddButton((JComponent)this);
        this.myEditButton = ToolbarDecorator.findEditButton((JComponent)this);
        this.myRemoveButton = ToolbarDecorator.findRemoveButton((JComponent)this);
        this.myMoveUpButton = ToolbarDecorator.findUpButton((JComponent)this);
        this.myMoveDownButton = ToolbarDecorator.findDownButton((JComponent)this);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BaseToolsPanel.this.update();
            }
        });
        this.setMinimumSize(this.myTree.getEmptyText().getPreferredSize());
    }

    public void reset() {
        this.mutatorHelper.clear();
        for (ToolsGroup<T> group : this.getToolManager().getGroups()) {
            this.insertNewGroup(this.mutatorHelper.copy(group));
        }
        if (this.getTreeRoot().getChildCount() > 0) {
            this.myTree.setSelectionInterval(0, 0);
        } else {
            this.myTree.getSelectionModel().clearSelection();
        }
        this.getModel().nodeStructureChanged(null);
        TreeUtil.expand((JTree)((Object)this.myTree), (int)5);
        this.myIsModified = false;
        this.update();
    }

    protected abstract BaseToolManager<T> getToolManager();

    @NotNull
    private CheckedTreeNode insertNewGroup(@NotNull ToolsGroup<T> groupCopy) {
        if (groupCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupCopy", "com/intellij/tools/BaseToolsPanel", "insertNewGroup"));
        }
        CheckedTreeNode groupNode = new CheckedTreeNode(groupCopy);
        this.getTreeRoot().add((MutableTreeNode)groupNode);
        for (Tool tool : groupCopy.getElements()) {
            this.insertNewTool(groupNode, tool);
        }
        CheckedTreeNode checkedTreeNode = groupNode;
        if (checkedTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolsPanel", "insertNewGroup"));
        }
        return checkedTreeNode;
    }

    private CheckedTreeNode insertNewTool(@NotNull CheckedTreeNode groupNode, @NotNull Tool toolCopy) {
        if (groupNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupNode", "com/intellij/tools/BaseToolsPanel", "insertNewTool"));
        }
        if (toolCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolCopy", "com/intellij/tools/BaseToolsPanel", "insertNewTool"));
        }
        CheckedTreeNode toolNode = new CheckedTreeNode((Object)toolCopy);
        toolNode.setChecked(toolCopy.isEnabled());
        ((ToolsGroup)groupNode.getUserObject()).addElement(toolCopy);
        groupNode.add((MutableTreeNode)toolNode);
        this.nodeWasInserted(toolNode);
        return toolNode;
    }

    private CheckedTreeNode getTreeRoot() {
        return (CheckedTreeNode)this.myTree.getModel().getRoot();
    }

    public void apply() {
        this.getToolManager().setTools(this.mutatorHelper.apply(this.getGroupList()));
        this.myIsModified = false;
    }

    @NotNull
    private List<ToolsGroup<T>> getGroupList() {
        MutableTreeNode root = (MutableTreeNode)this.myTree.getModel().getRoot();
        ArrayList<ToolsGroup<T>> result2 = new ArrayList<ToolsGroup<T>>(root.getChildCount());
        for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
            CheckedTreeNode node = (CheckedTreeNode)root.getChildAt(i2);
            for (int j = 0; j < node.getChildCount(); ++j) {
                CheckedTreeNode toolNode = (CheckedTreeNode)node.getChildAt(j);
                ((Tool)toolNode.getUserObject()).setEnabled(toolNode.isChecked());
            }
            result2.add((ToolsGroup)node.getUserObject());
        }
        ArrayList<ToolsGroup<T>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolsPanel", "getGroupList"));
        }
        return arrayList;
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    private void moveNode(Direction direction) {
        CheckedTreeNode node = this.getSelectedNode();
        if (node != null && BaseToolsPanel.isMovingAvailable(node, direction)) {
            this.moveNode(node, direction);
            if (node.getUserObject() instanceof Tool) {
                ToolsGroup group = (ToolsGroup)((CheckedTreeNode)node.getParent()).getUserObject();
                Tool tool = (Tool)node.getUserObject();
                BaseToolsPanel.moveElementInsideGroup(tool, group, direction);
            }
            TreePath path = new TreePath(node.getPath());
            this.myTree.getSelectionModel().setSelectionPath(path);
            this.myTree.expandPath(path);
            this.myTree.requestFocus();
        }
    }

    private static void moveElementInsideGroup(Tool tool, ToolsGroup group, Direction dir) {
        if (dir == Direction.UP) {
            group.moveElementUp(tool);
        } else {
            group.moveElementDown(tool);
        }
    }

    private void moveNode(CheckedTreeNode toolNode, Direction dir) {
        CheckedTreeNode parentNode = (CheckedTreeNode)toolNode.getParent();
        int index = parentNode.getIndex((TreeNode)toolNode);
        this.removeNodeFromParent((DefaultMutableTreeNode)toolNode);
        int newIndex = dir.newIndex(index);
        parentNode.insert((MutableTreeNode)toolNode, newIndex);
        this.getModel().nodesWereInserted((TreeNode)parentNode, new int[]{newIndex});
    }

    private static boolean isMovingAvailable(CheckedTreeNode toolNode, Direction dir) {
        TreeNode parent = toolNode.getParent();
        int index = parent.getIndex((TreeNode)toolNode);
        return dir.isAvailable(index, parent.getChildCount());
    }

    private void insertNewTool(@NotNull Tool newTool, boolean setSelection) {
        if (newTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTool", "com/intellij/tools/BaseToolsPanel", "insertNewTool"));
        }
        CheckedTreeNode groupNode = this.findGroupNode(newTool.getGroup());
        if (groupNode == null) {
            groupNode = this.insertNewGroup(new ToolsGroup(newTool.getGroup()));
            this.nodeWasInserted(groupNode);
        }
        CheckedTreeNode tool = this.insertNewTool(groupNode, newTool);
        if (setSelection) {
            TreePath treePath = new TreePath(tool.getPath());
            this.myTree.expandPath(treePath);
            this.myTree.getSelectionModel().setSelectionPath(treePath);
        }
        this.myIsModified = true;
    }

    private void nodeWasInserted(CheckedTreeNode groupNode) {
        this.getModel().nodesWereInserted(groupNode.getParent(), new int[]{groupNode.getParent().getChildCount() - 1});
    }

    private DefaultTreeModel getModel() {
        return (DefaultTreeModel)this.myTree.getModel();
    }

    private CheckedTreeNode findGroupNode(String group) {
        for (int i2 = 0; i2 < this.getTreeRoot().getChildCount(); ++i2) {
            CheckedTreeNode node = (CheckedTreeNode)this.getTreeRoot().getChildAt(i2);
            ToolsGroup g = (ToolsGroup)node.getUserObject();
            if (!Comparing.equal((String)group, (String)g.getName())) continue;
            return node;
        }
        return null;
    }

    @Nullable
    private Tool getSelectedTool() {
        CheckedTreeNode node = this.getSelectedToolNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject() instanceof Tool ? (Tool)node.getUserObject() : null;
    }

    @Nullable
    private ToolsGroup getSelectedToolGroup() {
        CheckedTreeNode node = this.getSelectedToolNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject() instanceof ToolsGroup ? (ToolsGroup)node.getUserObject() : null;
    }

    private void update() {
        CheckedTreeNode node = this.getSelectedToolNode();
        Tool selectedTool = this.getSelectedTool();
        ToolsGroup selectedGroup = this.getSelectedToolGroup();
        if (selectedTool != null) {
            this.myAddButton.setEnabled(true);
            this.myCopyButton.setEnabled(true);
            this.myEditButton.setEnabled(true);
            this.myMoveDownButton.setEnabled(BaseToolsPanel.isMovingAvailable(node, Direction.DOWN));
            this.myMoveUpButton.setEnabled(BaseToolsPanel.isMovingAvailable(node, Direction.UP));
            this.myRemoveButton.setEnabled(true);
        } else if (selectedGroup != null) {
            this.myAddButton.setEnabled(true);
            this.myCopyButton.setEnabled(false);
            this.myEditButton.setEnabled(false);
            this.myMoveDownButton.setEnabled(BaseToolsPanel.isMovingAvailable(node, Direction.DOWN));
            this.myMoveUpButton.setEnabled(BaseToolsPanel.isMovingAvailable(node, Direction.UP));
            this.myRemoveButton.setEnabled(true);
        } else {
            this.myAddButton.setEnabled(true);
            this.myCopyButton.setEnabled(false);
            this.myEditButton.setEnabled(false);
            this.myMoveDownButton.setEnabled(false);
            this.myMoveUpButton.setEnabled(false);
            this.myRemoveButton.setEnabled(false);
        }
        this.getModel().nodeStructureChanged(null);
        this.myTree.repaint();
    }

    private void removeSelected() {
        CheckedTreeNode node = this.getSelectedToolNode();
        if (node != null) {
            int result2 = Messages.showYesNoDialog((Component)this, (String)ToolsBundle.message("tools.delete.confirmation", new Object[0]), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
            if (result2 != 0) {
                return;
            }
            this.myIsModified = true;
            if (node.getUserObject() instanceof Tool) {
                Tool tool = (Tool)node.getUserObject();
                CheckedTreeNode parentNode = (CheckedTreeNode)node.getParent();
                ((ToolsGroup)parentNode.getUserObject()).removeElement(tool);
                this.removeNodeFromParent((DefaultMutableTreeNode)node);
                if (parentNode.getChildCount() == 0) {
                    this.removeNodeFromParent((DefaultMutableTreeNode)parentNode);
                }
            } else if (node.getUserObject() instanceof ToolsGroup) {
                this.removeNodeFromParent((DefaultMutableTreeNode)node);
            }
            this.update();
            this.myTree.requestFocus();
        }
    }

    private void removeNodeFromParent(DefaultMutableTreeNode node) {
        TreeNode parent = node.getParent();
        int idx = parent.getIndex(node);
        node.removeFromParent();
        this.getModel().nodesWereRemoved(parent, new int[]{idx}, new TreeNode[]{node});
    }

    private void editSelected() {
        Tool selected;
        CheckedTreeNode node = this.getSelectedToolNode();
        if (node != null && node.getUserObject() instanceof Tool && (selected = (Tool)node.getUserObject()) != null) {
            String oldGroupName = selected.getGroup();
            ToolEditorDialog dlg = this.createToolEditorDialog(ToolsBundle.message("tools.edit.title", new Object[0]));
            dlg.setData(selected, this.getGroups());
            if (dlg.showAndGet()) {
                selected.copyFrom(dlg.getData());
                String newGroupName = selected.getGroup();
                if (!Comparing.equal((String)oldGroupName, (String)newGroupName)) {
                    CheckedTreeNode oldGroupNode = (CheckedTreeNode)node.getParent();
                    this.removeNodeFromParent((DefaultMutableTreeNode)node);
                    ((ToolsGroup)oldGroupNode.getUserObject()).removeElement(selected);
                    if (oldGroupNode.getChildCount() == 0) {
                        this.removeNodeFromParent((DefaultMutableTreeNode)oldGroupNode);
                    }
                    this.insertNewTool(selected, true);
                } else {
                    this.getModel().nodeChanged((TreeNode)node);
                }
                this.myIsModified = true;
                this.update();
            }
        }
    }

    protected ToolEditorDialog createToolEditorDialog(String title) {
        return new ToolEditorDialog(this, title);
    }

    private CheckedTreeNode getSelectedToolNode() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            return (CheckedTreeNode)selectionPath.getLastPathComponent();
        }
        return null;
    }

    private CheckedTreeNode getSelectedNode() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            return (CheckedTreeNode)selectionPath.getLastPathComponent();
        }
        return null;
    }

    private String[] getGroups() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (ToolsGroup<T> group : this.getGroupList()) {
            result2.add(group.getName());
        }
        return ArrayUtil.toStringArray(result2);
    }

    void addSelectionListener(TreeSelectionListener listener2) {
        this.myTree.getSelectionModel().addTreeSelectionListener(listener2);
    }

    @Nullable
    Tool getSingleSelectedTool() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return null;
        }
        Object toolOrToolGroup = ((CheckedTreeNode)selectionPaths[0].getLastPathComponent()).getUserObject();
        if (toolOrToolGroup instanceof Tool) {
            return (Tool)toolOrToolGroup;
        }
        return null;
    }

    public void selectTool(final String actionId) {
        Object root = this.myTree.getModel().getRoot();
        if (root == null || !(root instanceof CheckedTreeNode)) {
            return;
        }
        final ArrayList nodes = new ArrayList();
        new Object(){

            public void collect(CheckedTreeNode node) {
                if (node.isLeaf()) {
                    Object userObject = node.getUserObject();
                    if (userObject instanceof Tool && actionId.equals(((Tool)userObject).getActionId())) {
                        nodes.add(node);
                    }
                } else {
                    for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                        TreeNode child = node.getChildAt(i2);
                        if (!(child instanceof CheckedTreeNode)) continue;
                        this.collect((CheckedTreeNode)child);
                    }
                }
            }
        }.collect((CheckedTreeNode)root);
        if (nodes.isEmpty()) {
            return;
        }
        this.myTree.getSelectionModel().setSelectionPath(new TreePath(((CheckedTreeNode)nodes.get(0)).getPath()));
    }

    static enum Direction {
        UP{

            @Override
            public boolean isAvailable(int index, int childCount) {
                return index != 0;
            }

            @Override
            public int newIndex(int index) {
                return index - 1;
            }
        }
        ,
        DOWN{

            @Override
            public boolean isAvailable(int index, int childCount) {
                return index < childCount - 1;
            }

            @Override
            public int newIndex(int index) {
                return index + 1;
            }
        };


        public abstract boolean isAvailable(int var1, int var2);

        public abstract int newIndex(int var1);
    }
}

