/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.ToolProcessAdapter;
import com.intellij.tools.ToolRunProfile;
import com.intellij.tools.ToolsBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tool
implements SchemeElement {
    private static final Logger LOG = Logger.getInstance((String)("#" + Tool.class.getPackage().getName()));
    @NonNls
    public static final String ACTION_ID_PREFIX = "Tool_";
    public static final String DEFAULT_GROUP_NAME = "External Tools";
    private String myName;
    private String myDescription;
    @NotNull
    private String myGroup = "External Tools";
    private boolean myShownInMainMenu;
    private boolean myShownInEditor;
    private boolean myShownInProjectViews;
    private boolean myShownInSearchResultsPopup;
    private boolean myEnabled;
    private boolean myUseConsole;
    private boolean myShowConsoleOnStdOut;
    private boolean myShowConsoleOnStdErr;
    private boolean mySynchronizeAfterExecution;
    private String myWorkingDirectory;
    private String myProgram;
    private String myParameters;
    private ArrayList<FilterInfo> myOutputFilters = new ArrayList();

    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public String getGroup() {
        String string = this.myGroup;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/Tool", "getGroup"));
        }
        return string;
    }

    public boolean isShownInMainMenu() {
        return this.myShownInMainMenu;
    }

    public boolean isShownInEditor() {
        return this.myShownInEditor;
    }

    public boolean isShownInProjectViews() {
        return this.myShownInProjectViews;
    }

    public boolean isShownInSearchResultsPopup() {
        return this.myShownInSearchResultsPopup;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isUseConsole() {
        return this.myUseConsole;
    }

    public boolean isShowConsoleOnStdOut() {
        return this.myShowConsoleOnStdOut;
    }

    public boolean isShowConsoleOnStdErr() {
        return this.myShowConsoleOnStdErr;
    }

    public boolean synchronizeAfterExecution() {
        return this.mySynchronizeAfterExecution;
    }

    void setName(String name) {
        this.myName = name;
    }

    void setDescription(String description) {
        this.myDescription = description;
    }

    void setGroup(@NotNull String group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/tools/Tool", "setGroup"));
        }
        this.myGroup = StringUtil.isEmpty((String)group) ? DEFAULT_GROUP_NAME : group;
    }

    void setShownInMainMenu(boolean shownInMainMenu) {
        this.myShownInMainMenu = shownInMainMenu;
    }

    void setShownInEditor(boolean shownInEditor) {
        this.myShownInEditor = shownInEditor;
    }

    void setShownInProjectViews(boolean shownInProjectViews) {
        this.myShownInProjectViews = shownInProjectViews;
    }

    public void setShownInSearchResultsPopup(boolean shownInSearchResultsPopup) {
        this.myShownInSearchResultsPopup = shownInSearchResultsPopup;
    }

    void setUseConsole(boolean useConsole) {
        this.myUseConsole = useConsole;
    }

    void setShowConsoleOnStdOut(boolean showConsole) {
        this.myShowConsoleOnStdOut = showConsole;
    }

    void setShowConsoleOnStdErr(boolean showConsole) {
        this.myShowConsoleOnStdErr = showConsole;
    }

    public void setFilesSynchronizedAfterRun(boolean synchronizeAfterRun) {
        this.mySynchronizeAfterExecution = synchronizeAfterRun;
    }

    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public String getProgram() {
        return this.myProgram;
    }

    public void setProgram(String program) {
        this.myProgram = program;
    }

    public String getParameters() {
        return this.myParameters;
    }

    public void setParameters(String parameters) {
        this.myParameters = parameters;
    }

    public void addOutputFilter(FilterInfo filter) {
        this.myOutputFilters.add(filter);
    }

    public void setOutputFilters(FilterInfo[] filters) {
        this.myOutputFilters = new ArrayList();
        if (filters != null) {
            Collections.addAll(this.myOutputFilters, filters);
        }
    }

    public FilterInfo[] getOutputFilters() {
        return this.myOutputFilters.toArray(new FilterInfo[this.myOutputFilters.size()]);
    }

    public void copyFrom(Tool source) {
        this.myName = source.getName();
        this.myDescription = source.getDescription();
        this.myGroup = source.getGroup();
        this.myShownInMainMenu = source.isShownInMainMenu();
        this.myShownInEditor = source.isShownInEditor();
        this.myShownInProjectViews = source.isShownInProjectViews();
        this.myShownInSearchResultsPopup = source.isShownInSearchResultsPopup();
        this.myEnabled = source.isEnabled();
        this.myUseConsole = source.isUseConsole();
        this.myShowConsoleOnStdOut = source.isShowConsoleOnStdOut();
        this.myShowConsoleOnStdErr = source.isShowConsoleOnStdErr();
        this.mySynchronizeAfterExecution = source.synchronizeAfterExecution();
        this.myWorkingDirectory = source.getWorkingDirectory();
        this.myProgram = source.getProgram();
        this.myParameters = source.getParameters();
        this.myOutputFilters = new ArrayList<FilterInfo>(Arrays.asList(source.getOutputFilters()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tool)) {
            return false;
        }
        Tool source = (Tool)obj;
        return Comparing.equal((String)this.myName, (String)source.myName) && Comparing.equal((String)this.myDescription, (String)source.myDescription) && Comparing.equal((String)this.myGroup, (String)source.myGroup) && this.myShownInMainMenu == source.myShownInMainMenu && this.myShownInEditor == source.myShownInEditor && this.myShownInProjectViews == source.myShownInProjectViews && this.myShownInSearchResultsPopup == source.myShownInSearchResultsPopup && this.myEnabled == source.myEnabled && this.myUseConsole == source.myUseConsole && this.myShowConsoleOnStdOut == source.myShowConsoleOnStdOut && this.myShowConsoleOnStdErr == source.myShowConsoleOnStdErr && this.mySynchronizeAfterExecution == source.mySynchronizeAfterExecution && Comparing.equal((String)this.myWorkingDirectory, (String)source.myWorkingDirectory) && Comparing.equal((String)this.myProgram, (String)source.myProgram) && Comparing.equal((String)this.myParameters, (String)source.myParameters) && Comparing.equal(this.myOutputFilters, source.myOutputFilters);
    }

    @NotNull
    public String getActionId() {
        StringBuilder name = new StringBuilder(this.getActionIdPrefix());
        name.append(this.myGroup);
        name.append('_');
        if (this.myName != null) {
            name.append(this.myName);
        }
        String string = name.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/Tool", "getActionId"));
        }
        return string;
    }

    public void execute(AnActionEvent event, DataContext dataContext, long executionId, final @Nullable ProcessListener processListener) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            if (this.isUseConsole()) {
                ExecutionEnvironment environment = ExecutionEnvironmentBuilder.create((Project)project2, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)new ToolRunProfile(this, dataContext)).build();
                environment.setExecutionId(executionId);
                environment.getRunner().execute(environment, new ProgramRunner.Callback(){

                    public void processStarted(RunContentDescriptor descriptor) {
                        ProcessHandler processHandler2 = descriptor.getProcessHandler();
                        if (processHandler2 != null && processListener != null) {
                            LOG.assertTrue(!processHandler2.isStartNotified(), (Object)"ProcessHandler is already startNotified, the listener won't be correctly notified");
                            processHandler2.addProcessListener(processListener);
                        }
                    }
                });
            } else {
                GeneralCommandLine commandLine = this.createCommandLine(dataContext);
                if (commandLine == null) {
                    return;
                }
                OSProcessHandler handler2 = new OSProcessHandler(commandLine);
                handler2.addProcessListener((ProcessListener)new ToolProcessAdapter(project2, this.synchronizeAfterExecution(), this.getName()));
                if (processListener != null) {
                    handler2.addProcessListener(processListener);
                }
                handler2.startNotify();
            }
        }
        catch (ExecutionException ex) {
            ExecutionErrorDialog.show((ExecutionException)ex, (String)ToolsBundle.message("tools.process.start.error", new Object[0]), (Project)project2);
        }
    }

    @Nullable
    public GeneralCommandLine createCommandLine(DataContext dataContext) {
        if (StringUtil.isEmpty((String)this.getWorkingDirectory())) {
            this.setWorkingDirectory("$ProjectFileDir$");
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        try {
            String paramString = MacroManager.getInstance().expandMacrosInString(this.getParameters(), true, dataContext);
            String workingDir = MacroManager.getInstance().expandMacrosInString(this.getWorkingDirectory(), true, dataContext);
            String exePath = MacroManager.getInstance().expandMacrosInString(this.getProgram(), true, dataContext);
            commandLine.getParametersList().addParametersString(MacroManager.getInstance().expandMacrosInString(paramString, false, dataContext));
            String workDirExpanded = MacroManager.getInstance().expandMacrosInString(workingDir, false, dataContext);
            if (!StringUtil.isEmpty((String)workDirExpanded)) {
                commandLine.setWorkDirectory(workDirExpanded);
            }
            if ((exePath = MacroManager.getInstance().expandMacrosInString(exePath, false, dataContext)) == null) {
                return null;
            }
            File exeFile = new File(exePath);
            if (exeFile.isDirectory() && exeFile.getName().endsWith(".app")) {
                commandLine.setExePath("open");
                commandLine.getParametersList().prependAll(new String[]{"-a", exePath});
            } else {
                exePath = PathEnvironmentVariableUtil.toLocatableExePath((String)exePath);
                commandLine.setExePath(exePath);
            }
        }
        catch (Macro.ExecutionCancelledException ignored) {
            return null;
        }
        return commandLine;
    }

    public void setGroupName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tools/Tool", "setGroupName"));
        }
        this.setGroup(name);
    }

    public String getKey() {
        return this.getName();
    }

    @NotNull
    public SchemeElement copy() {
        Tool copy = new Tool();
        copy.copyFrom(this);
        Tool tool = copy;
        if (tool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/Tool", "copy"));
        }
        return tool;
    }

    public String toString() {
        return this.myGroup + ": " + this.myName;
    }

    public String getActionIdPrefix() {
        return ACTION_ID_PREFIX;
    }
}

