/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.OutputFiltersDialog;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ToolEditorDialog
extends DialogWrapper {
    private final JTextField myNameField = new JTextField();
    private final JTextField myDescriptionField = new JTextField();
    private final ComboBox myGroupCombo = new ComboBox(-1);
    private final JCheckBox myShowInMainMenuCheckbox = new JCheckBox(ToolsBundle.message("tools.menu.main.checkbox", new Object[0]));
    private final JCheckBox myShowInEditorCheckbox = new JCheckBox(ToolsBundle.message("tools.menu.editor.checkbox", new Object[0]));
    private final JCheckBox myShowInProjectTreeCheckbox = new JCheckBox(ToolsBundle.message("tools.menu.project.checkbox", new Object[0]));
    private final JCheckBox myShowInSearchResultsPopupCheckbox = new JCheckBox(ToolsBundle.message("tools.menu.search.checkbox", new Object[0]));
    private final JCheckBox myUseConsoleCheckbox = new JCheckBox(ToolsBundle.message("tools.open.console.checkbox", new Object[0]));
    private final JCheckBox myShowConsoleOnStdOutCheckbox = new JCheckBox(ExecutionBundle.message((String)"logs.show.console.on.stdout", (Object[])new Object[0]));
    private final JCheckBox myShowConsoleOnStdErrCheckbox = new JCheckBox(ExecutionBundle.message((String)"logs.show.console.on.stderr", (Object[])new Object[0]));
    private final JCheckBox mySynchronizedAfterRunCheckbox = new JCheckBox(ToolsBundle.message("tools.synchronize.files.checkbox", new Object[0]));
    private boolean myEnabled;
    private final JTextField myTfCommandWorkingDirectory = new JTextField();
    private final JTextField myTfCommand = new JTextField();
    private final JTextField myParametersField = new JTextField();
    private JButton myInsertWorkingDirectoryMacroButton;
    private JButton myInsertCommandMacroButton;
    private JButton myInsertParametersMacroButton;
    private final JButton myOutputFiltersButton;
    private final JPanel mySimpleProgramPanel = this.createCommandPane();
    private FilterInfo[] myOutputFilters;
    private final Project myProject;

    @NotNull
    protected JPanel createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.anchor = 17;
        constr.insets = new Insets(5, 0, 0, 0);
        panel2.add((Component)new JLabel(ToolsBundle.message("tools.name.label", new Object[0])), constr);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 0;
        constr.weightx = 1.0;
        constr.insets = new Insets(5, 10, 0, 10);
        constr.fill = 2;
        constr.anchor = 17;
        panel2.add((Component)this.myNameField, constr);
        constr = new GridBagConstraints();
        constr.gridx = 2;
        constr.gridy = 0;
        constr.anchor = 17;
        constr.insets = new Insets(5, 10, 0, 0);
        panel2.add((Component)new JLabel(ToolsBundle.message("tools.group.label", new Object[0])), constr);
        constr = new GridBagConstraints();
        constr.gridx = 3;
        constr.gridy = 0;
        constr.weightx = 0.7;
        constr.insets = new Insets(5, 10, 0, 0);
        constr.fill = 2;
        constr.anchor = 17;
        panel2.add((Component)this.myGroupCombo, constr);
        this.myGroupCombo.setEditable(true);
        this.myGroupCombo.setFont(this.myNameField.getFont());
        Dimension comboSize = this.myNameField.getPreferredSize();
        this.myGroupCombo.setMinimumSize(comboSize);
        this.myGroupCombo.setPreferredSize(comboSize);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 1;
        constr.anchor = 17;
        constr.insets = new Insets(5, 0, 0, 0);
        panel2.add((Component)new JLabel(ToolsBundle.message("tools.description.label", new Object[0])), constr);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 1;
        constr.weightx = 1.0;
        constr.gridwidth = 3;
        constr.insets = new Insets(5, 10, 0, 0);
        constr.fill = 2;
        constr.anchor = 17;
        panel2.add((Component)this.myDescriptionField, constr);
        JPanel panel0 = new JPanel(new BorderLayout());
        panel0.add((Component)this.getOptionsPanel(), "North");
        panel0.add((Component)this.getShowInPanel(), "South");
        constr = new GridBagConstraints();
        constr.gridy = 4;
        constr.gridwidth = 4;
        constr.fill = 2;
        constr.weightx = 1.0;
        constr.insets = new Insets(5, 0, 0, 0);
        panel2.add((Component)panel0, constr);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 7;
        constr.gridwidth = 4;
        constr.fill = 1;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.anchor = 11;
        panel2.add((Component)this.mySimpleProgramPanel, constr);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/ToolEditorDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/ToolEditorDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getIdForHelpAction());
    }

    protected String getIdForHelpAction() {
        return "preferences.externalToolsEdit";
    }

    protected ToolEditorDialog(JComponent parent, String title) {
        super((Component)parent, true);
        this.myOutputFiltersButton = new JButton(ToolsBundle.message("tools.filters.button", new Object[0]));
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)parent);
        this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        MacroManager.getInstance().cacheMacrosPreview(dataContext);
        this.setTitle(title);
        this.init();
        this.addListeners();
        this.myShowConsoleOnStdOutCheckbox.setVisible(false);
        this.myShowConsoleOnStdErrCheckbox.setVisible(false);
    }

    private JPanel createCommandPane() {
        JPanel pane = new JPanel(new GridBagLayout());
        pane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ToolsBundle.message("tools.tool.group", new Object[0]), (boolean)true));
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.insets = new Insets(0, 0, 0, 10);
        constr.anchor = 512;
        pane.add((Component)new JLabel(ToolsBundle.message("tools.program.label", new Object[0])), constr);
        FixedSizeButton browseCommandButton = new FixedSizeButton((JComponent)this.myTfCommand);
        this.addCommandBrowseAction(pane, browseCommandButton, this.myTfCommand);
        JPanel _pane0 = new JPanel(new BorderLayout());
        _pane0.add((Component)this.myTfCommand, "Center");
        _pane0.add((Component)browseCommandButton, "East");
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)browseCommandButton, (JComponent)this.myTfCommand);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 0;
        constr.insets = new Insets(0, 0, 0, 10);
        constr.fill = 2;
        constr.anchor = 512;
        constr.weightx = 1.0;
        pane.add((Component)_pane0, constr);
        constr = new GridBagConstraints();
        constr.gridx = 2;
        constr.gridy = 0;
        constr.insets = new Insets(0, 0, 0, 0);
        constr.fill = 2;
        constr.anchor = 512;
        this.myInsertCommandMacroButton = new JButton(ToolsBundle.message("tools.insert.macro.button", new Object[0]));
        pane.add((Component)this.myInsertCommandMacroButton, constr);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 1;
        constr.insets = new Insets(5, 0, 0, 10);
        constr.anchor = 512;
        pane.add((Component)new JLabel(ToolsBundle.message("tools.parameters.label", new Object[0])), constr);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 1;
        constr.insets = new Insets(5, 0, 0, 10);
        constr.fill = 2;
        constr.anchor = 512;
        constr.weightx = 1.0;
        pane.add((Component)this.myParametersField, constr);
        constr = new GridBagConstraints();
        constr.gridx = 2;
        constr.gridy = 1;
        constr.insets = new Insets(5, 0, 0, 0);
        constr.fill = 2;
        constr.anchor = 512;
        this.myInsertParametersMacroButton = new JButton(ToolsBundle.message("tools.insert.macro.button.a", new Object[0]));
        pane.add((Component)this.myInsertParametersMacroButton, constr);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 2;
        constr.insets = new Insets(5, 0, 0, 10);
        constr.anchor = 512;
        pane.add((Component)new JLabel(ToolsBundle.message("tools.working.directory.label", new Object[0])), constr);
        FixedSizeButton browseDirectoryButton = new FixedSizeButton((JComponent)this.myTfCommandWorkingDirectory);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)browseDirectoryButton, (JComponent)this.myTfCommandWorkingDirectory);
        this.addWorkingDirectoryBrowseAction(pane, browseDirectoryButton, this.myTfCommandWorkingDirectory);
        JPanel _pane1 = new JPanel(new BorderLayout());
        _pane1.add((Component)this.myTfCommandWorkingDirectory, "Center");
        _pane1.add((Component)browseDirectoryButton, "East");
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 2;
        constr.gridwidth = 1;
        constr.insets = new Insets(5, 0, 0, 10);
        constr.fill = 2;
        constr.anchor = 17;
        constr.weightx = 1.0;
        pane.add((Component)_pane1, constr);
        constr = new GridBagConstraints();
        constr.gridx = 2;
        constr.gridy = 2;
        constr.insets = new Insets(5, 0, 0, 0);
        constr.fill = 2;
        constr.anchor = 512;
        this.myInsertWorkingDirectoryMacroButton = new JButton(ToolsBundle.message("tools.insert.macro.button.c", new Object[0]));
        pane.add((Component)this.myInsertWorkingDirectoryMacroButton, constr);
        constr = new GridBagConstraints();
        constr.gridy = 3;
        constr.fill = 512;
        constr.weighty = 1.0;
        pane.add((Component)new JLabel(), constr);
        return pane;
    }

    protected void addWorkingDirectoryBrowseAction(final JPanel pane, FixedSizeButton browseDirectoryButton, JTextField tfCommandWorkingDirectory) {
        browseDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                PathChooserDialog chooser = FileChooserFactory.getInstance().createPathChooser(descriptor, ToolEditorDialog.this.myProject, (Component)pane);
                chooser.choose(null, files -> {
                    VirtualFile file2;
                    VirtualFile virtualFile = file2 = !files.isEmpty() ? (VirtualFile)files.get(0) : null;
                    if (file2 != null) {
                        ToolEditorDialog.this.myTfCommandWorkingDirectory.setText(file2.getPresentableUrl());
                    }
                });
            }
        });
    }

    protected void addCommandBrowseAction(final JPanel pane, FixedSizeButton browseCommandButton, JTextField tfCommand) {
        browseCommandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
                PathChooserDialog chooser = FileChooserFactory.getInstance().createPathChooser(descriptor, ToolEditorDialog.this.myProject, (Component)pane);
                chooser.choose(null, files -> {
                    VirtualFile file2;
                    VirtualFile virtualFile = file2 = !files.isEmpty() ? (VirtualFile)files.get(0) : null;
                    if (file2 != null) {
                        VirtualFile parent;
                        ToolEditorDialog.this.myTfCommand.setText(file2.getPresentableUrl());
                        String workingDirectory = ToolEditorDialog.this.myTfCommandWorkingDirectory.getText();
                        if ((workingDirectory == null || workingDirectory.isEmpty()) && (parent = file2.getParent()) != null && parent.isDirectory()) {
                            ToolEditorDialog.this.myTfCommandWorkingDirectory.setText(parent.getPresentableUrl());
                        }
                    }
                });
            }
        });
    }

    private void addListeners() {
        this.myOutputFiltersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputFiltersDialog dialog2 = new OutputFiltersDialog(ToolEditorDialog.this.myOutputFiltersButton, ToolEditorDialog.this.getData().getOutputFilters());
                if (dialog2.showAndGet()) {
                    ToolEditorDialog.access$402(ToolEditorDialog.this, dialog2.getData());
                }
            }
        });
        this.myInsertCommandMacroButton.addActionListener(new InsertMacroActionListener(this.myTfCommand));
        this.myInsertParametersMacroButton.addActionListener(new InsertMacroActionListener(this.myParametersField));
        this.myInsertWorkingDirectoryMacroButton.addActionListener(new InsertMacroActionListener(this.myTfCommandWorkingDirectory));
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                ToolEditorDialog.this.handleOKButton();
            }
        });
        this.myUseConsoleCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ToolEditorDialog.this.myShowConsoleOnStdOutCheckbox.setVisible(ToolEditorDialog.this.myUseConsoleCheckbox.isSelected());
                ToolEditorDialog.this.myShowConsoleOnStdErrCheckbox.setVisible(ToolEditorDialog.this.myUseConsoleCheckbox.isSelected());
            }
        });
    }

    private void handleOKButton() {
        this.setOKActionEnabled(!this.myNameField.getText().trim().isEmpty());
    }

    public Tool getData() {
        Tool tool = this.createTool();
        tool.setName(this.convertString(this.myNameField.getText()));
        tool.setDescription(this.convertString(this.myDescriptionField.getText()));
        Object selectedItem = this.myGroupCombo.getSelectedItem();
        tool.setGroup(StringUtil.notNullize((String)(selectedItem != null ? this.convertString(selectedItem.toString()) : "")));
        tool.setShownInMainMenu(this.myShowInMainMenuCheckbox.isSelected());
        tool.setShownInEditor(this.myShowInEditorCheckbox.isSelected());
        tool.setShownInProjectViews(this.myShowInProjectTreeCheckbox.isSelected());
        tool.setShownInSearchResultsPopup(this.myShowInSearchResultsPopupCheckbox.isSelected());
        tool.setUseConsole(this.myUseConsoleCheckbox.isSelected());
        tool.setShowConsoleOnStdOut(this.myShowConsoleOnStdOutCheckbox.isSelected());
        tool.setShowConsoleOnStdErr(this.myShowConsoleOnStdErrCheckbox.isSelected());
        tool.setFilesSynchronizedAfterRun(this.mySynchronizedAfterRunCheckbox.isSelected());
        tool.setEnabled(this.myEnabled);
        tool.setWorkingDirectory(this.toSystemIndependentFormat(this.myTfCommandWorkingDirectory.getText()));
        tool.setProgram(this.convertString(this.myTfCommand.getText()));
        tool.setParameters(this.convertString(this.myParametersField.getText()));
        tool.setOutputFilters(this.myOutputFilters);
        return tool;
    }

    protected Tool createTool() {
        return new Tool();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.tools.ToolEditorDialog";
    }

    protected void setData(Tool tool, String[] existingGroups) {
        this.myNameField.setText(tool.getName());
        this.myDescriptionField.setText(tool.getDescription());
        if (this.myGroupCombo.getItemCount() > 0) {
            this.myGroupCombo.removeAllItems();
        }
        for (int i2 = 0; i2 < existingGroups.length; ++i2) {
            if (existingGroups[i2] == null) continue;
            this.myGroupCombo.addItem((Object)existingGroups[i2]);
        }
        this.myGroupCombo.setSelectedItem((Object)tool.getGroup());
        this.myShowInMainMenuCheckbox.setSelected(tool.isShownInMainMenu());
        this.myShowInEditorCheckbox.setSelected(tool.isShownInEditor());
        this.myShowInProjectTreeCheckbox.setSelected(tool.isShownInProjectViews());
        this.myShowInSearchResultsPopupCheckbox.setSelected(tool.isShownInSearchResultsPopup());
        this.myUseConsoleCheckbox.setSelected(tool.isUseConsole());
        this.myShowConsoleOnStdOutCheckbox.setSelected(tool.isShowConsoleOnStdOut());
        this.myShowConsoleOnStdErrCheckbox.setSelected(tool.isShowConsoleOnStdErr());
        this.mySynchronizedAfterRunCheckbox.setSelected(tool.synchronizeAfterExecution());
        this.myEnabled = tool.isEnabled();
        this.myTfCommandWorkingDirectory.setText(this.toCurrentSystemFormat(tool.getWorkingDirectory()));
        this.myTfCommand.setText(tool.getProgram());
        this.myParametersField.setText(tool.getParameters());
        this.myOutputFilters = tool.getOutputFilters();
        this.mySimpleProgramPanel.setVisible(true);
        this.handleOKButton();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private JPanel getShowInPanel() {
        JPanel panel2 = new JPanel(new FlowLayout(0, 10, 0));
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ToolsBundle.message("tools.menu.group", new Object[0]), (boolean)true));
        panel2.add(this.myShowInMainMenuCheckbox);
        panel2.add(this.myShowInEditorCheckbox);
        panel2.add(this.myShowInProjectTreeCheckbox);
        panel2.add(this.myShowInSearchResultsPopupCheckbox);
        return panel2;
    }

    private JPanel getOptionsPanel() {
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("fill, gap 10"));
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ToolsBundle.message("tools.options.group", new Object[0]), (boolean)true));
        panel2.add(this.mySynchronizedAfterRunCheckbox);
        panel2.add(this.myUseConsoleCheckbox);
        panel2.add((Component)this.myOutputFiltersButton, "ax right, wrap");
        panel2.add(this.myShowConsoleOnStdOutCheckbox);
        panel2.add((Component)this.myShowConsoleOnStdErrCheckbox, "spanx 2");
        return panel2;
    }

    private String convertString(String s) {
        if (s != null && s.trim().isEmpty()) {
            return null;
        }
        return s;
    }

    private String toSystemIndependentFormat(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        return s.replace(File.separatorChar, '/');
    }

    private String toCurrentSystemFormat(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        return s.replace('/', File.separatorChar);
    }

    public Project getProject() {
        return this.myProject;
    }

    static /* synthetic */ FilterInfo[] access$402(ToolEditorDialog x0, FilterInfo[] x1) {
        x0.myOutputFilters = x1;
        return x1;
    }

    private class InsertMacroActionListener
    implements ActionListener {
        private final JTextField myTextField;

        public InsertMacroActionListener(JTextField textField) {
            this.myTextField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MacrosDialog dialog2 = new MacrosDialog(ToolEditorDialog.this.myProject);
            if (dialog2.showAndGet() && dialog2.getSelectedMacro() != null) {
                String macro = dialog2.getSelectedMacro().getName();
                int position = this.myTextField.getCaretPosition();
                try {
                    this.myTextField.getDocument().insertString(position, "$" + macro + "$", null);
                    this.myTextField.setCaretPosition(position + macro.length() + 2);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            IdeFocusManager.findInstance().requestFocus((Component)this.myTextField, true);
        }
    }
}

