/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.FontInfo;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class FontInfoRenderer
extends ColoredListCellRenderer<Object> {
    protected void customizeCellRenderer(@NotNull JList<?> list, Object value, int index, boolean selected, boolean focused) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/FontInfoRenderer", "customizeCellRenderer"));
        }
        Font font = list.getFont();
        String text = value == null ? "" : value.toString();
        this.append(text);
        if (value instanceof FontInfo) {
            FontInfo info = (FontInfo)value;
            Integer size = this.getFontSize();
            Font f = info.getFont(size != null ? size.intValue() : font.getSize());
            if (f.canDisplayUpTo(text) == -1) {
                this.setFont(f);
            } else {
                this.append("  Non-latin", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    }

    protected void applyAdditionalHints(@NotNull Graphics2D g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/FontInfoRenderer", "applyAdditionalHints"));
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)this.isEditorFont()));
    }

    protected Integer getFontSize() {
        return null;
    }

    protected boolean isEditorFont() {
        return false;
    }
}

