/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListSpeedSearch
extends SpeedSearchBase<JList> {
    private final Convertor<Object, String> myToStringConvertor;

    public ListSpeedSearch(JList list) {
        this(list, (Convertor<Object, String>)((Convertor)null));
    }

    public ListSpeedSearch(JList list, @NotNull Function<Object, String> convertor) {
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/ui/ListSpeedSearch", "<init>"));
        }
        this(list, (Convertor<Object, String>)((Convertor)arg_0 -> convertor.fun(arg_0)));
    }

    public ListSpeedSearch(JList list, @Nullable Convertor<Object, String> convertor) {
        super(list);
        this.myToStringConvertor = convertor;
        new MySelectAllAction(list, this).registerCustomShortcutSet(list, null);
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)element);
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this.myComponent).getSelectedIndex();
    }

    @Override
    protected Object[] getAllElements() {
        return ListSpeedSearch.getAllListElements((JList)this.myComponent);
    }

    public static Object[] getAllListElements(JList list) {
        ListModel model = list.getModel();
        if (model instanceof DefaultListModel) {
            return ((DefaultListModel)model).toArray();
        }
        Object[] elements = new Object[model.getSize()];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2] = model.getElementAt(i2);
        }
        return elements;
    }

    @Override
    protected String getElementText(Object element) {
        if (this.myToStringConvertor != null) {
            return (String)this.myToStringConvertor.convert(element);
        }
        return element == null ? null : element.toString();
    }

    @NotNull
    private TIntArrayList findAllFilteredElements(String s) {
        TIntArrayList indices = new TIntArrayList();
        String _s = s.trim();
        Object[] elements = ListSpeedSearch.getAllListElements((JList)this.myComponent);
        for (int i2 = 0; i2 < elements.length; ++i2) {
            Object element = elements[i2];
            if (!this.isMatchingElement(element, _s)) continue;
            indices.add(i2);
        }
        TIntArrayList tIntArrayList = indices;
        if (tIntArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/ListSpeedSearch", "findAllFilteredElements"));
        }
        return tIntArrayList;
    }

    private static class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JList myList;
        @NotNull
        private final ListSpeedSearch mySearch;

        public MySelectAllAction(@NotNull JList list, @NotNull ListSpeedSearch search) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/ListSpeedSearch$MySelectAllAction", "<init>"));
            }
            if (search == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "search", "com/intellij/ui/ListSpeedSearch$MySelectAllAction", "<init>"));
            }
            this.myList = list;
            this.mySearch = search;
            this.copyShortcutFrom(ActionManager.getInstance().getAction("$SelectAll"));
            this.setEnabledInModalContext(true);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myList.getSelectionModel().getSelectionMode() == 2);
        }

        public void actionPerformed(AnActionEvent e) {
            ListSelectionModel sm = this.myList.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            TIntArrayList filtered = this.mySearch.findAllFilteredElements(query);
            if (filtered.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered.toNativeArray(), this.myList.getSelectedIndices());
            if (alreadySelected) {
                int anchor = this.myList.getAnchorSelectionIndex();
                this.myList.setSelectedIndex(anchor);
                sm.setAnchorSelectionIndex(anchor);
                this.mySearch.findAndSelectElement(query);
            } else {
                int anchor = -1;
                Object currentElement = this.mySearch.findElement(query);
                if (currentElement != null) {
                    List<Object> elements = Arrays.asList(ListSpeedSearch.getAllListElements(this.myList));
                    anchor = ContainerUtil.indexOfIdentity(elements, (Object)currentElement);
                }
                if (anchor == -1) {
                    anchor = filtered.get(0);
                }
                this.myList.setSelectedIndices(filtered.toNativeArray());
                sm.setAnchorSelectionIndex(anchor);
            }
        }
    }
}

