/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class MapBasedTree<K, N> {
    private static final Logger LOG = Logger.getInstance(MapBasedTree.class);
    private final Map<K, Entry<N>> map;
    private final Function<N, K> keyFunction;
    private final TreePath path;
    private volatile Entry<N> root;

    public MapBasedTree(boolean identity, @NotNull Function<N, K> keyFunction) {
        if (keyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyFunction", "com/intellij/ui/tree/MapBasedTree", "<init>"));
        }
        this(identity, keyFunction, null);
    }

    public MapBasedTree(boolean identity, @NotNull Function<N, K> keyFunction, TreePath path) {
        if (keyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyFunction", "com/intellij/ui/tree/MapBasedTree", "<init>"));
        }
        this.map = identity ? new IdentityHashMap() : new HashMap();
        this.keyFunction = keyFunction;
        this.path = path;
    }

    public Entry<N> findEntry(K key2) {
        return key2 == null ? null : this.map.get(key2);
    }

    public N findNode(K key2) {
        Entry<N> entry = this.findEntry(key2);
        return (N)(entry == null ? null : ((Entry)entry).node);
    }

    public Entry<N> getEntry(N node) {
        K key2 = this.getKey(node);
        Entry<N> entry = this.findEntry(key2);
        return entry == null || ((Entry)entry).node == node ? entry : null;
    }

    public Entry<N> getRootEntry() {
        return this.root;
    }

    public K getKey(N node) {
        if (node == null) {
            return null;
        }
        K key2 = this.keyFunction.apply(node);
        if (key2 != null) {
            return key2;
        }
        LOG.warn("MapBasedTree: key function provides null");
        return null;
    }

    public boolean updateRoot(Pair<N, Boolean> pair) {
        Object newNode;
        Object oldNode = this.root == null ? null : ((Entry)this.root).node;
        Object object = newNode = pair == null ? null : pair.first;
        if (oldNode == newNode) {
            return false;
        }
        this.map.clear();
        if (newNode == null) {
            this.root = null;
        } else {
            this.root = new Entry(this.path, null, newNode, (Boolean)pair.second);
            K key2 = this.keyFunction.apply(newNode);
            if (key2 != null) {
                this.map.put(key2, this.root);
            }
        }
        return true;
    }

    public UpdateResult<N> update(@NotNull Entry<N> parent, List<Pair<N, Boolean>> children2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/tree/MapBasedTree", "update"));
        }
        ArrayList newChildren = new ArrayList(children2 == null ? 0 : children2.size());
        List<Entry<N>> oldChildren = ((Entry)parent).children;
        IdentityHashMap<Entry, Object> mapInserted = new IdentityHashMap<Entry, Object>();
        IdentityHashMap mapContained = new IdentityHashMap();
        if (children2 != null && !children2.isEmpty()) {
            children2.forEach(pair -> {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/tree/MapBasedTree", "lambda$update$0"));
                }
                if (pair == null || pair.first == null) {
                    LOG.warn("MapBasedTree: ignore null node");
                    return;
                }
                K key2 = this.getKey(pair.first);
                if (key2 == null) {
                    return;
                }
                Entry<N> entry = this.findEntry(key2);
                if (entry == null) {
                    entry = new Entry(parent, ((Entry)parent).node, pair.first, (Boolean)pair.second);
                    mapInserted.put(entry, key2);
                } else {
                    if (parent != entry.getParentPath()) {
                        LOG.warn("MapBasedTree: ignore node that belongs to another parent");
                        return;
                    }
                    mapContained.put(entry, key2);
                }
                ((Entry)entry).index = newChildren.size();
                newChildren.add(entry);
            });
        }
        ((Entry)parent).leaf = children2 == null;
        ((Entry)parent).children = MapBasedTree.guard(newChildren);
        List<Entry<Object>> removed = oldChildren;
        List<Object> inserted = newChildren;
        List contained = null;
        if (!mapContained.isEmpty()) {
            if (oldChildren == null) {
                oldChildren = Collections.emptyList();
                LOG.warn("MapBasedTree: unexpected state");
            }
            removed = oldChildren.stream().filter(entry -> !mapContained.containsKey(entry)).collect(Collectors.toList());
            inserted = newChildren.stream().filter(entry -> !mapContained.containsKey(entry)).collect(Collectors.toList());
            contained = newChildren.stream().filter(entry -> mapContained.containsKey(entry)).collect(Collectors.toList());
        }
        this.removeChildren(parent, removed);
        mapInserted.forEach((entry, key2) -> this.map.put(key2, (Entry<N>)entry));
        return new UpdateResult(removed, inserted, contained);
    }

    private void removeChildren(Entry<N> parent, List<Entry<N>> children2) {
        if (children2 != null) {
            for (Entry<N> entry : children2) {
                if (((Entry)parent).loading == ((Entry)entry).node) {
                    ((Entry)parent).loading = null;
                    continue;
                }
                K key2 = this.getKey(((Entry)entry).node);
                if (key2 == null) continue;
                Entry<N> removed = this.map.remove(key2);
                if (removed == null) {
                    LOG.warn("MapBasedTree: expected entry is not found");
                    continue;
                }
                if (removed != entry) {
                    LOG.warn("MapBasedTree: do not remove unexpected entry");
                    this.map.put(key2, removed);
                    continue;
                }
                this.removeChildren(removed, ((Entry)removed).children);
            }
        }
    }

    private static <T> List<T> guard(List<T> list) {
        return list == null || list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public static final class UpdateResult<N> {
        private final List<Entry<N>> removed;
        private final List<Entry<N>> inserted;
        private final List<Entry<N>> contained;

        private UpdateResult(List<Entry<N>> removed, List<Entry<N>> inserted, List<Entry<N>> contained) {
            this.removed = MapBasedTree.guard(removed);
            this.inserted = MapBasedTree.guard(inserted);
            this.contained = MapBasedTree.guard(contained);
        }

        public TreeModelEvent getEvent(@NotNull Object source, TreePath path, @NotNull List<Entry<N>> list) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ui/tree/MapBasedTree$UpdateResult", "getEvent"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/tree/MapBasedTree$UpdateResult", "getEvent"));
            }
            int size = list.size();
            int[] indices = new int[size];
            Object[] nodes = new Object[size];
            int index = 0;
            for (Entry<N> entry : list) {
                indices[index] = ((Entry)entry).index;
                nodes[index++] = ((Entry)entry).node;
            }
            return new TreeModelEvent(source, path, indices, nodes);
        }

        public List<Entry<N>> getRemoved() {
            return this.removed;
        }

        public List<Entry<N>> getInserted() {
            return this.inserted;
        }

        public List<Entry<N>> getContained() {
            return this.contained;
        }
    }

    public static final class Entry<N>
    extends TreePath {
        private final N node;
        private final N parent;
        private volatile int index;
        private volatile boolean leaf;
        private volatile List<Entry<N>> children;
        private volatile N loading;

        private Entry(TreePath path, N parent, N node, Boolean leaf) {
            super(path, node);
            this.node = node;
            this.parent = parent;
            this.leaf = Boolean.TRUE.equals(leaf);
            if (this.leaf) {
                this.children = Collections.emptyList();
            }
        }

        public N getNode() {
            return this.node;
        }

        public N getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public boolean isLoadingRequired() {
            return this.children == null;
        }

        public int getChildCount() {
            return this.children == null ? 0 : this.children.size();
        }

        public N getChild(int index) {
            if (this.children != null && 0 <= index && index < this.children.size()) {
                return this.children.get(index).getNode();
            }
            return null;
        }

        public int getIndexOf(N child) {
            if (this.children != null) {
                for (int i2 = 0; i2 < this.children.size(); ++i2) {
                    if (child != this.children.get(i2).getNode()) continue;
                    return i2;
                }
            }
            return -1;
        }

        void setLoadingChildren(N loading) {
            if (this.children != null) {
                LOG.warn("MapBasedTree: rewrite loaded nodes");
            }
            this.loading = loading;
            this.children = loading == null ? Collections.emptyList() : Collections.singletonList(new Entry<N>(this, this.node, loading, true));
        }
    }
}

