/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.configurable.VcsContentAnnotationConfigurable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.ThreadDumpConsoleFactory;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadState;
import com.intellij.unscramble.UnscrambleSupport;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnscrambleDialog
extends DialogWrapper {
    @NonNls
    private static final String PROPERTY_LOG_FILE_HISTORY_URLS = "UNSCRAMBLE_LOG_FILE_URL";
    @NonNls
    private static final String PROPERTY_LOG_FILE_LAST_URL = "UNSCRAMBLE_LOG_FILE_LAST_URL";
    @NonNls
    private static final String PROPERTY_UNSCRAMBLER_NAME_USED = "UNSCRAMBLER_NAME_USED";
    private static final Condition<ThreadState> DEADLOCK_CONDITION = state -> state.isDeadlocked();
    private static final String[] IMPORTANT_THREAD_DUMP_WORDS = (String[])ContainerUtil.ar((Object[])new String[]{"tid", "nid", "wait", "parking", "prio", "os_prio", "java"});
    private final Project myProject;
    private JPanel myEditorPanel;
    private JPanel myLogFileChooserPanel;
    private JComboBox myUnscrambleChooser;
    private JPanel myPanel;
    private TextFieldWithHistory myLogFile;
    private JCheckBox myUseUnscrambler;
    private JPanel myUnscramblePanel;
    private JCheckBox myOnTheFly;
    private JPanel myBottomPanel;
    private JPanel mySettingsPanel;
    protected AnalyzeStacktraceUtil.StacktraceEditorPanel myStacktraceEditorPanel;
    private VcsContentAnnotationConfigurable myConfigurable;

    public UnscrambleDialog(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/unscramble/UnscrambleDialog", "<init>"));
        }
        super(false);
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.populateRegisteredUnscramblerList();
        this.myUnscrambleChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnscrambleSupport unscrambleSupport = UnscrambleDialog.this.getSelectedUnscrambler();
                GuiUtils.enableChildren((Component)UnscrambleDialog.this.myLogFileChooserPanel, (unscrambleSupport != null ? 1 : 0) != 0, (JComponent[])new JComponent[0]);
                UnscrambleDialog.this.updateUnscramblerSettings();
            }
        });
        this.myUseUnscrambler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnscrambleDialog.this.useUnscramblerChanged();
            }
        });
        this.myOnTheFly.setSelected(Registry.get((String)"analyze.exceptions.on.the.fly").asBoolean());
        this.myOnTheFly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Registry.get((String)"analyze.exceptions.on.the.fly").setValue(UnscrambleDialog.this.myOnTheFly.isSelected());
            }
        });
        this.createLogFileChooser();
        this.createEditor();
        this.reset();
        this.setTitle(IdeBundle.message((String)"unscramble.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    private void useUnscramblerChanged() {
        boolean selected = this.myUseUnscrambler.isSelected();
        GuiUtils.enableChildren((Component)this.myUnscramblePanel, (boolean)selected, (JComponent[])new JComponent[]{this.myUseUnscrambler});
        if (selected) {
            this.updateUnscramblerSettings();
        }
    }

    private void updateUnscramblerSettings() {
        UnscrambleSupport unscrambleSupport = (UnscrambleSupport)this.myUnscrambleChooser.getSelectedItem();
        JComponent settingsComponent = unscrambleSupport == null ? null : unscrambleSupport.createSettingsComponent();
        this.mySettingsPanel.removeAll();
        if (settingsComponent != null) {
            this.mySettingsPanel.add((Component)settingsComponent, "Center");
        }
        this.myUnscramblePanel.validate();
    }

    private void reset() {
        List<String> savedUrls = UnscrambleDialog.getSavedLogFileUrls();
        this.myLogFile.setHistorySize(10);
        this.myLogFile.setHistory(savedUrls);
        String lastUrl = this.getPropertyValue(PROPERTY_LOG_FILE_LAST_URL);
        if (lastUrl == null && !savedUrls.isEmpty()) {
            lastUrl = savedUrls.get(savedUrls.size() - 1);
        }
        if (lastUrl != null) {
            this.myLogFile.setText(lastUrl);
            this.myLogFile.setSelectedItem((Object)lastUrl);
        }
        UnscrambleSupport selectedUnscrambler = this.getSavedUnscrambler();
        int count = this.myUnscrambleChooser.getItemCount();
        int index = 0;
        if (selectedUnscrambler != null) {
            for (int i2 = 0; i2 < count; ++i2) {
                UnscrambleSupport unscrambleSupport = (UnscrambleSupport)this.myUnscrambleChooser.getItemAt(i2);
                if (unscrambleSupport == null || !Comparing.strEqual((String)unscrambleSupport.getPresentableName(), (String)selectedUnscrambler.getPresentableName())) continue;
                index = i2;
                break;
            }
        }
        if (count > 0) {
            this.myUseUnscrambler.setEnabled(true);
            this.myUnscrambleChooser.setSelectedIndex(index);
            this.myUseUnscrambler.setSelected(selectedUnscrambler != null);
        } else {
            this.myUseUnscrambler.setEnabled(false);
        }
        this.useUnscramblerChanged();
        this.updateUnscramblerSettings();
        this.myStacktraceEditorPanel.pasteTextFromClipboard();
    }

    private void createUIComponents() {
        this.myBottomPanel = new JPanel(new BorderLayout());
        if (ProjectLevelVcsManager.getInstance((Project)this.myProject).hasActiveVcss()) {
            this.myConfigurable = new VcsContentAnnotationConfigurable(this.myProject);
            this.myBottomPanel.add((Component)this.myConfigurable.createComponent(), "Center");
            this.myConfigurable.reset();
        }
    }

    @Nullable
    private UnscrambleSupport getSavedUnscrambler() {
        String savedUnscramblerName = this.getPropertyValue(PROPERTY_UNSCRAMBLER_NAME_USED);
        UnscrambleSupport selectedUnscrambler = null;
        for (UnscrambleSupport unscrambleSupport : (UnscrambleSupport[])UnscrambleSupport.EP_NAME.getExtensions()) {
            if (!Comparing.strEqual((String)unscrambleSupport.getPresentableName(), (String)savedUnscramblerName)) continue;
            selectedUnscrambler = unscrambleSupport;
        }
        return selectedUnscrambler;
    }

    @NotNull
    public static List<String> getSavedLogFileUrls() {
        ArrayList<String> res = new ArrayList<String>();
        String savedUrl = PropertiesComponent.getInstance().getValue(PROPERTY_LOG_FILE_HISTORY_URLS);
        String[] strings = savedUrl == null ? ArrayUtil.EMPTY_STRING_ARRAY : savedUrl.split(":::");
        for (int i2 = 0; i2 != strings.length; ++i2) {
            res.add(strings[i2]);
        }
        ArrayList<String> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/unscramble/UnscrambleDialog", "getSavedLogFileUrls"));
        }
        return arrayList;
    }

    @Nullable
    private UnscrambleSupport getSelectedUnscrambler() {
        if (!this.myUseUnscrambler.isSelected()) {
            return null;
        }
        return (UnscrambleSupport)this.myUnscrambleChooser.getSelectedItem();
    }

    private void createEditor() {
        this.myStacktraceEditorPanel = AnalyzeStacktraceUtil.createEditorPanel(this.myProject, this.myDisposable);
        this.myEditorPanel.setLayout(new BorderLayout());
        this.myEditorPanel.add((Component)this.myStacktraceEditorPanel, "Center");
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.createNormalizeTextAction(), this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/unscramble/UnscrambleDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        JRootPane pane = this.getRootPane();
        return pane != null ? pane.getDefaultButton() : super.getPreferredFocusedComponent();
    }

    private void createLogFileChooser() {
        this.myLogFile = new TextFieldWithHistory();
        JPanel panel2 = GuiUtils.constructFieldWithBrowseButton((TextFieldWithHistory)this.myLogFile, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)UnscrambleDialog.this.myProject, null, files -> UnscrambleDialog.this.myLogFile.setText(FileUtil.toSystemDependentName((String)((VirtualFile)files.get(files.size() - 1)).getPath())));
            }
        });
        this.myLogFileChooserPanel.setLayout(new BorderLayout());
        this.myLogFileChooserPanel.add((Component)panel2, "Center");
    }

    private void populateRegisteredUnscramblerList() {
        for (UnscrambleSupport unscrambleSupport : (UnscrambleSupport[])UnscrambleSupport.EP_NAME.getExtensions()) {
            this.myUnscrambleChooser.addItem(unscrambleSupport);
        }
        this.myUnscrambleChooser.setRenderer(new ListCellRendererWrapper<UnscrambleSupport>(){

            public void customize(JList list, UnscrambleSupport unscrambleSupport, int index, boolean selected, boolean hasFocus) {
                this.setText(unscrambleSupport == null ? IdeBundle.message((String)"unscramble.no.unscrambler.item", (Object[])new Object[0]) : unscrambleSupport.getPresentableName());
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public void dispose() {
        if (this.isOK()) {
            List list = this.myLogFile.getHistory();
            PropertiesComponent.getInstance().setValue(PROPERTY_LOG_FILE_HISTORY_URLS, list.isEmpty() ? null : StringUtil.join((Collection)list, (String)":::"), null);
            UnscrambleSupport selectedUnscrambler = this.getSelectedUnscrambler();
            this.saveProperty(PROPERTY_UNSCRAMBLER_NAME_USED, selectedUnscrambler == null ? null : selectedUnscrambler.getPresentableName());
            this.saveProperty(PROPERTY_LOG_FILE_LAST_URL, StringUtil.nullize((String)this.myLogFile.getText()));
        }
        super.dispose();
    }

    private void saveProperty(@NotNull String name, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/unscramble/UnscrambleDialog", "saveProperty"));
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(name, value);
        PropertiesComponent.getInstance().setValue(name, value);
    }

    @Nullable
    private String getPropertyValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/unscramble/UnscrambleDialog", "getPropertyValue"));
        }
        String projectValue = PropertiesComponent.getInstance((Project)this.myProject).getValue(name);
        if (projectValue != null) {
            return projectValue;
        }
        return PropertiesComponent.getInstance().getValue(name);
    }

    public void setText(String trace) {
        this.myStacktraceEditorPanel.setText(trace);
    }

    public Action createNormalizeTextAction() {
        return new NormalizeTextAction();
    }

    public static String normalizeText(@NonNls String text) {
        StringBuilder builder = new StringBuilder(text.length());
        text = text.replaceAll("(\\S[ \\t\\x0B\\f\\r]+)(at\\s+)", "$1\n$2");
        String[] lines = text.split("\n");
        boolean first = true;
        boolean inAuxInfo = false;
        for (String line : lines) {
            StringBuilder lastLine;
            if (!inAuxInfo && (line.startsWith("JNI global references") || line.trim().equals("Heap"))) {
                builder.append("\n");
                inAuxInfo = true;
            }
            if (inAuxInfo) {
                builder.append(UnscrambleDialog.trimSuffix(line)).append("\n");
                continue;
            }
            if (line.startsWith("at breakpoint")) {
                builder.append(" ").append(UnscrambleDialog.trimSuffix(line));
                continue;
            }
            if (!first && (UnscrambleDialog.mustHaveNewLineBefore(line) || StringUtil.endsWith((CharSequence)builder, (CharSequence)")"))) {
                if (!StringUtil.endsWith((CharSequence)builder, (CharSequence)"\n")) {
                    builder.append("\n");
                }
                if (line.startsWith("\"")) {
                    builder.append("\n");
                }
            }
            first = false;
            int i2 = builder.lastIndexOf("\n");
            CharSequence charSequence = lastLine = i2 == -1 ? builder : builder.subSequence(i2 + 1, builder.length());
            if (!line.matches("\\s+.*") && lastLine.length() > 0 && (lastLine.toString().matches("\\s*at") || ContainerUtil.or((Object[])IMPORTANT_THREAD_DUMP_WORDS, word -> line.startsWith((String)word)))) {
                builder.append(" ");
            }
            builder.append(UnscrambleDialog.trimSuffix(line));
        }
        return builder.toString();
    }

    private static String trimSuffix(String line) {
        int len;
        for (len = line.length(); 0 < len && line.charAt(len - 1) <= ' '; --len) {
        }
        return len < line.length() ? line.substring(0, len) : line;
    }

    private static boolean mustHaveNewLineBefore(String line) {
        int nonWs = CharArrayUtil.shiftForward((CharSequence)line, (int)0, (String)" \t");
        if (nonWs < line.length()) {
            line = line.substring(nonWs);
        }
        if (line.startsWith("at")) {
            return true;
        }
        if (line.startsWith("Caused")) {
            return true;
        }
        if (line.startsWith("- locked")) {
            return true;
        }
        if (line.startsWith("- waiting")) {
            return true;
        }
        if (line.startsWith("- parking to wait")) {
            return true;
        }
        if (line.startsWith("java.lang.Thread.State")) {
            return true;
        }
        return line.startsWith("\"");
    }

    protected void doOKAction() {
        if (this.myConfigurable != null && this.myConfigurable.isModified()) {
            try {
                this.myConfigurable.apply();
            }
            catch (ConfigurationException e) {
                this.setText(e.getMessage());
                return;
            }
        }
        DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(() -> {
            if (this.performUnscramble()) {
                this.myLogFile.addCurrentTextToHistory();
                this.close(0);
            }
        });
    }

    public void doHelpAction() {
        HelpManager.getInstance().invokeHelp("find.analyzeStackTrace");
    }

    private boolean performUnscramble() {
        UnscrambleSupport selectedUnscrambler = this.getSelectedUnscrambler();
        JComponent settings = this.mySettingsPanel.getComponentCount() == 0 ? null : (JComponent)this.mySettingsPanel.getComponent(0);
        return UnscrambleDialog.showUnscrambledText(selectedUnscrambler, this.myLogFile.getText(), settings, this.myProject, this.myStacktraceEditorPanel.getText()) != null;
    }

    @Nullable
    static <T extends JComponent> RunContentDescriptor showUnscrambledText(@Nullable UnscrambleSupport<T> unscrambleSupport, String logName, @Nullable T settings, Project project2, String textToUnscramble) {
        String unscrambledTrace;
        String string = unscrambledTrace = unscrambleSupport == null ? textToUnscramble : unscrambleSupport.unscramble(project2, textToUnscramble, logName, settings);
        if (unscrambledTrace == null) {
            return null;
        }
        List<ThreadState> threadStates = ThreadDumpParser.parse(unscrambledTrace);
        return UnscrambleDialog.addConsole(project2, threadStates, unscrambledTrace);
    }

    private static RunContentDescriptor addConsole(Project project2, List<ThreadState> threadDump, String unscrambledTrace) {
        Icon icon = null;
        String message = IdeBundle.message((String)"unscramble.unscrambled.stacktrace.tab", (Object[])new Object[0]);
        if (!threadDump.isEmpty()) {
            message = IdeBundle.message((String)"unscramble.unscrambled.threaddump.tab", (Object[])new Object[0]);
            icon = AllIcons.Debugger.ThreadStates.Threaddump;
        } else {
            String name = UnscrambleDialog.getExceptionName(unscrambledTrace);
            if (name != null) {
                message = name;
                icon = AllIcons.Debugger.ThreadStates.Exception;
            }
        }
        if (ContainerUtil.find(threadDump, DEADLOCK_CONDITION) != null) {
            message = IdeBundle.message((String)"unscramble.unscrambled.deadlock.tab", (Object[])new Object[0]);
            icon = AllIcons.Debugger.KillProcess;
        }
        return AnalyzeStacktraceUtil.addConsole(project2, threadDump.size() > 1 ? new ThreadDumpConsoleFactory(project2, threadDump) : null, message, unscrambledTrace, icon);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.unscramble.UnscrambleDialog";
    }

    @Nullable
    private static String getExceptionName(String unscrambledTrace) {
        BufferedReader reader = new BufferedReader(new StringReader(unscrambledTrace));
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                String line = reader.readLine();
                if (line == null) {
                    return null;
                }
                String name = UnscrambleDialog.getExceptionAbbreviation(line = line.trim());
                if (name == null) continue;
                return name;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static String getExceptionAbbreviation(String line) {
        int lastDelimiter = 0;
        for (int j = 0; j < line.length(); ++j) {
            char c = line.charAt(j);
            if (c == '.' || c == '$') {
                lastDelimiter = j;
                continue;
            }
            if (StringUtil.isJavaIdentifierPart((char)c)) continue;
            return null;
        }
        String clazz = line.substring(lastDelimiter);
        String abbreviate = UnscrambleDialog.abbreviate(clazz);
        return abbreviate.length() > 1 ? abbreviate : clazz;
    }

    private static String abbreviate(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            if (!Character.isUpperCase(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JComboBox jComboBox;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEditorPanel = jPanel4 = new JPanel();
        jPanel5.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("unscramble.stacktrace.caption"));
        jPanel5.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUnscramblePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/IdeBundle").getString("unscramble.unscrambler.combobox"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUnscrambleChooser = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/IdeBundle").getString("unscramble.log.path.label"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLogFileChooserPanel = jPanel2 = new JPanel();
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myUseUnscrambler = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("unscramble.use.unscrambler.checkbox"));
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myOnTheFly = jCheckBox = new JCheckBox();
        jCheckBox.setText("Automatically detect and analyze thread dumps copied to the clipboard outside of IntelliJ IDEA");
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jPanel5.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = this.myBottomPanel;
        jPanel5.add((Component)jPanel6, new GridConstraints(4, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private final class NormalizeTextAction
    extends AbstractAction {
        public NormalizeTextAction() {
            this.putValue("Name", IdeBundle.message((String)"unscramble.normalize.button", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.FALSE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = UnscrambleDialog.this.myStacktraceEditorPanel.getText();
            UnscrambleDialog.this.myStacktraceEditorPanel.setText(UnscrambleDialog.normalizeText(text));
        }
    }
}

