/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Expirable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class Invoker
implements Disposable {
    private static final Logger LOG = Logger.getInstance(Invoker.class);
    private static final AtomicInteger UID = new AtomicInteger();
    private final AtomicInteger count = new AtomicInteger();
    private final String description;
    volatile boolean disposed;

    private Invoker(String prefix, Disposable parent) {
        this.description = UID.getAndIncrement() + ".Invoker." + prefix + ":" + parent.getClass().getName();
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public String toString() {
        return this.description;
    }

    public void dispose() {
        this.disposed = true;
    }

    public abstract boolean isValidThread();

    public final void invokeLater(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/Invoker", "invokeLater"));
        }
        if (this.canInvoke(task)) {
            this.count.incrementAndGet();
            this.offer(() -> {
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/Invoker", "lambda$invokeLater$0"));
                }
                this.invokeSafely(task);
            });
        }
    }

    public final void invokeLaterIfNeeded(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/Invoker", "invokeLaterIfNeeded"));
        }
        if (this.isValidThread()) {
            this.count.incrementAndGet();
            this.invokeSafely(task);
        } else {
            this.invokeLater(task);
        }
    }

    public final int getTaskCount() {
        return this.disposed ? 0 : this.count.get();
    }

    abstract void offer(Runnable var1);

    final void invokeSafely(Runnable task) {
        try {
            if (this.canInvoke(task)) {
                task.run();
            }
        }
        catch (Exception exception) {
            LOG.warn((Throwable)exception);
        }
        finally {
            this.count.decrementAndGet();
        }
    }

    final boolean canInvoke(Runnable task) {
        Expirable expirable;
        if (this.disposed) {
            LOG.debug("Invoker is disposed");
            return false;
        }
        if (task instanceof Expirable && (expirable = (Expirable)task).isExpired()) {
            LOG.debug("Task is expired");
            return false;
        }
        return true;
    }

    public static final class BackgroundThread
    extends Invoker {
        private final ExecutorService executor;
        private volatile Thread thread;

        public BackgroundThread(@NotNull Disposable parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/concurrency/Invoker$BackgroundThread", "<init>"));
            }
            super("Background.Thread", parent);
            this.executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)this.toString(), (int)1);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.executor.shutdown();
        }

        @Override
        public boolean isValidThread() {
            return this.thread == Thread.currentThread();
        }

        @Override
        void offer(Runnable runnable2) {
            this.executor.execute(() -> {
                this.thread = Thread.currentThread();
                runnable2.run();
                this.thread = null;
            });
        }
    }

    public static final class BackgroundPool
    extends Invoker {
        public BackgroundPool(@NotNull Disposable parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/concurrency/Invoker$BackgroundPool", "<init>"));
            }
            super("Background.Pool", parent);
        }

        @Override
        public boolean isValidThread() {
            return !SwingUtilities.isEventDispatchThread();
        }

        @Override
        void offer(Runnable runnable2) {
            AppExecutorUtil.getAppExecutorService().submit(runnable2);
        }
    }

    public static final class EDT
    extends Invoker {
        private final TransferToEDTQueue<Runnable> queue;

        public EDT(@NotNull Disposable parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/concurrency/Invoker$EDT", "<init>"));
            }
            this(parent, 200);
        }

        public EDT(@NotNull Disposable parent, int maxUnitOfWorkThresholdMs) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/concurrency/Invoker$EDT", "<init>"));
            }
            super("EDT", parent);
            this.queue = TransferToEDTQueue.createRunnableMerger((String)this.toString(), (int)maxUnitOfWorkThresholdMs);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.queue.stop();
        }

        @Override
        public boolean isValidThread() {
            return SwingUtilities.isEventDispatchThread();
        }

        @Override
        void offer(Runnable runnable2) {
            this.queue.offer((Object)runnable2);
        }
    }
}

