/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualFileGistImpl<Data>
implements VirtualFileGist<Data> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.gist.VirtualFileGist");
    private static final int ourInternalVersion = 2;
    @NotNull
    private final String myId;
    private final int myVersion;
    @NotNull
    private final VirtualFileGist.GistCalculator<Data> myCalculator;
    @NotNull
    private final DataExternalizer<Data> myExternalizer;
    private static final Map<Pair<String, Integer>, FileAttribute> ourAttributes = new FactoryMap<Pair<String, Integer>, FileAttribute>(){

        @Nullable
        protected FileAttribute create(Pair<String, Integer> key2) {
            return new FileAttribute((String)key2.first, ((Integer)key2.second).intValue(), false);
        }
    };

    VirtualFileGistImpl(@NotNull String id, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull VirtualFileGist.GistCalculator<Data> calcData2) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/util/gist/VirtualFileGistImpl", "<init>"));
        }
        if (externalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/util/gist/VirtualFileGistImpl", "<init>"));
        }
        if (calcData2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calcData", "com/intellij/util/gist/VirtualFileGistImpl", "<init>"));
        }
        this.myId = id;
        this.myVersion = version;
        this.myExternalizer = externalizer;
        this.myCalculator = calcData2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Data getFileData(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/gist/VirtualFileGistImpl", "getFileData"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/gist/VirtualFileGistImpl", "getFileData"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        if (!(file2 instanceof VirtualFileWithId)) {
            return (Data)this.myCalculator.calcData(project2, file2);
        }
        int stamp = PersistentFS.getInstance().getModificationCount(file2) + ((GistManagerImpl)GistManager.getInstance()).getReindexCount();
        try (DataInputStream stream = this.getFileAttribute(project2).readAttribute(file2);){
            if (stream != null && DataInputOutputUtil.readINT((DataInput)stream) == stamp) {
                Object object = stream.readBoolean() ? this.myExternalizer.read((DataInput)stream) : null;
                return (Data)object;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        Object result2 = this.myCalculator.calcData(project2, file2);
        this.cacheResult(stamp, result2, project2, file2);
        return (Data)result2;
    }

    private void cacheResult(int modCount, @Nullable Data result2, Project project2, VirtualFile file2) {
        try (DataOutputStream out = this.getFileAttribute(project2).writeAttribute(file2);){
            DataInputOutputUtil.writeINT((DataOutput)out, (int)modCount);
            out.writeBoolean(result2 != null);
            if (result2 != null) {
                this.myExternalizer.save((DataOutput)out, result2);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAttribute getFileAttribute(Project project2) {
        Map<Pair<String, Integer>, FileAttribute> map = ourAttributes;
        synchronized (map) {
            return ourAttributes.get(Pair.create((Object)(this.myId + project2.getLocationHash()), (Object)(this.myVersion + 2)));
        }
    }
}

