/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ProjectTopics;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.FileContent;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UnindexedFilesUpdater
extends DumbModeTask {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.UnindexedFilesUpdater");
    private final FileBasedIndexImpl myIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
    private final Project myProject;

    public UnindexedFilesUpdater(final Project project2) {
        this.myProject = project2;
        project2.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                DumbService.getInstance((Project)project2).cancelTask((DumbModeTask)UnindexedFilesUpdater.this);
            }
        });
    }

    private void updateUnindexedFiles(ProgressIndicator indicator) {
        boolean trackResponsiveness;
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        PushedFilePropertiesUpdater.getInstance((Project)this.myProject).pushAllPropertiesNow();
        boolean bl = trackResponsiveness = !ApplicationManager.getApplication().isUnitTestMode();
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Pushing properties");
        }
        indicator.setIndeterminate(true);
        indicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        this.myIndex.clearIndicesIfNecessary();
        CollectingContentIterator finder = this.myIndex.createContentIterator(indicator);
        snapshot = PerformanceWatcher.takeSnapshot();
        this.myIndex.iterateIndexableFilesConcurrently((ContentIterator)finder, this.myProject, indicator);
        this.myIndex.filesUpdateEnumerationFinished();
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Indexable file iteration");
        }
        List files = finder.getFiles();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ((StartupManagerImpl)StartupManager.getInstance((Project)this.myProject)).scheduleInitialVfsRefresh();
        }
        if (files.isEmpty()) {
            return;
        }
        snapshot = PerformanceWatcher.takeSnapshot();
        if (trackResponsiveness) {
            LOG.info("Unindexed files update started: " + files.size() + " files to update");
        }
        indicator.setIndeterminate(false);
        indicator.setText(IdeBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
        this.indexFiles(indicator, files);
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Unindexed files update");
        }
    }

    private void indexFiles(ProgressIndicator indicator, List<VirtualFile> files) {
        CacheUpdateRunner.processFiles(indicator, true, files, this.myProject, (Consumer<FileContent>)((Consumer)content -> this.myIndex.indexFileContent(this.myProject, (FileContent)content)));
    }

    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/UnindexedFilesUpdater", "performInDumbMode"));
        }
        this.myIndex.filesUpdateStarted(this.myProject);
        try {
            this.updateUnindexedFiles(indicator);
        }
        catch (ProcessCanceledException e) {
            LOG.info("Unindexed files update canceled");
            throw e;
        }
        finally {
            this.myIndex.filesUpdateFinished(this.myProject);
        }
    }
}

