/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.Intersect;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.PrimaryKey;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import gnu.trove.THashSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelMergerImpl
implements ModelMerger {
    private final List<Pair<ModelMerger.InvocationStrategy, Class>> myInvocationStrategies = new ArrayList<Pair<ModelMerger.InvocationStrategy, Class>>();
    private final List<ModelMerger.MergingStrategy> myMergingStrategies = new ArrayList<ModelMerger.MergingStrategy>();
    private final List<Class> myMergingStrategyClasses = new ArrayList<Class>();
    private static final Class<MergedObject> MERGED_OBJECT_CLASS = MergedObject.class;
    private final ConcurrentFactoryMap<Method, List<Pair<ModelMerger.InvocationStrategy, Class>>> myAcceptsCache = new ConcurrentFactoryMap<Method, List<Pair<ModelMerger.InvocationStrategy, Class>>>(){

        protected List<Pair<ModelMerger.InvocationStrategy, Class>> create(Method method2) {
            ArrayList<Pair<ModelMerger.InvocationStrategy, Class>> result2 = new ArrayList<Pair<ModelMerger.InvocationStrategy, Class>>();
            for (int i2 = ModelMergerImpl.this.myInvocationStrategies.size() - 1; i2 >= 0; --i2) {
                Pair pair = (Pair)ModelMergerImpl.this.myInvocationStrategies.get(i2);
                if (!((ModelMerger.InvocationStrategy)pair.first).accepts(method2)) continue;
                result2.add((Pair<ModelMerger.InvocationStrategy, Class>)pair);
            }
            return result2;
        }
    };
    private static final Map<Class<?>, Method> ourPrimaryKeyMethods = new HashMap();

    public ModelMergerImpl() {
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return true;
            }

            public Object invokeMethod(JavaMethod javaMethod, Object proxy, Object[] args, List<Object> implementations) throws IllegalAccessException, InvocationTargetException {
                Method method2 = javaMethod.getMethod();
                List results = ModelMergerImpl.this.getMergedImplementations(method2, args, method2.getReturnType(), implementations, ModelMergerImpl.this.isIntersectionMethod(javaMethod));
                return results.isEmpty() ? null : results.get(0);
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return Collection.class.isAssignableFrom(method2.getReturnType());
            }

            public Object invokeMethod(JavaMethod method2, Object proxy, Object[] args, List<Object> implementations) throws IllegalAccessException, InvocationTargetException {
                Type type = DomReflectionUtil.extractCollectionElementType((Type)method2.getGenericReturnType());
                assert (type != null) : "No generic return type in method " + method2;
                return ModelMergerImpl.this.getMergedImplementations(method2.getMethod(), args, ReflectionUtil.getRawType((Type)type), implementations, ModelMergerImpl.this.isIntersectionMethod(method2));
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return Object.class.equals(method2.getDeclaringClass());
            }

            public Object invokeMethod(JavaMethod method2, Object proxy, Object[] args, List<Object> implementations) {
                String methodName = method2.getName();
                if ("toString".equals(methodName)) {
                    return "Merger: " + implementations;
                }
                if ("hashCode".equals(methodName)) {
                    int result2 = 1;
                    for (Object element : implementations) {
                        result2 = 31 * result2 + element.hashCode();
                    }
                    return result2;
                }
                if ("equals".equals(methodName)) {
                    Object arg = args[0];
                    return arg != null && arg instanceof MergedObject && implementations.equals(((MergedObject)arg).getImplementations());
                }
                return null;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return "isValid".equals(method2.getName());
            }

            public Object invokeMethod(JavaMethod method2, Object proxy, Object[] args, List<Object> implementations) throws IllegalAccessException, InvocationTargetException {
                for (Object implementation : implementations) {
                    if (((Boolean)method2.invoke(implementation, args)).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return Void.TYPE.equals(method2.getReturnType());
            }

            public Object invokeMethod(JavaMethod method2, Object proxy, Object[] args, List<Object> implementations) throws IllegalAccessException, InvocationTargetException {
                for (Object t : implementations) {
                    method2.invoke(t, args);
                }
                return null;
            }
        });
        this.addInvocationStrategy(Object.class, new ModelMerger.InvocationStrategy<Object>(){

            public boolean accepts(Method method2) {
                return MERGED_OBJECT_CLASS.equals(method2.getDeclaringClass());
            }

            public Object invokeMethod(JavaMethod method2, Object proxy, Object[] args, List<Object> implementations) throws IllegalAccessException, InvocationTargetException {
                assert ("getImplementations".equals(method2.getName()));
                return implementations;
            }
        });
        this.addInvocationStrategy(DomElement.class, new ModelMerger.InvocationStrategy<DomElement>(){

            public boolean accepts(Method method2) {
                return DomInvocationHandler.ACCEPT_METHOD.equals(method2);
            }

            public Object invokeMethod(JavaMethod method2, DomElement proxy, Object[] args, List<DomElement> implementations) throws IllegalAccessException, InvocationTargetException {
                DomElementVisitor visitor = (DomElementVisitor)args[0];
                ((DomManagerImpl)implementations.get(0).getManager()).getApplicationComponent().getVisitorDescription(visitor.getClass()).acceptElement(visitor, proxy);
                return null;
            }
        });
        this.addInvocationStrategy(DomElement.class, new ModelMerger.InvocationStrategy<DomElement>(){

            public boolean accepts(Method method2) {
                return DomInvocationHandler.ACCEPT_CHILDREN_METHOD.equals(method2);
            }

            public Object invokeMethod(JavaMethod method2, DomElement proxy, Object[] args, List<DomElement> implementations) throws IllegalAccessException, InvocationTargetException {
                DomElementVisitor visitor = (DomElementVisitor)args[0];
                for (AbstractDomChildrenDescription description : implementations.get(0).getGenericInfo().getChildrenDescriptions()) {
                    for (DomElement value : description.getValues(proxy)) {
                        value.accept(visitor);
                    }
                }
                return null;
            }
        });
    }

    private boolean isIntersectionMethod(JavaMethod javaMethod) {
        return javaMethod.getMethod().getAnnotation(Intersect.class) != null;
    }

    public final <T> void addInvocationStrategy(Class<T> aClass, ModelMerger.InvocationStrategy<T> strategy) {
        this.myInvocationStrategies.add((Pair<ModelMerger.InvocationStrategy, Class>)Pair.create(strategy, aClass));
    }

    public final <T> void addMergingStrategy(Class<T> aClass, ModelMerger.MergingStrategy<T> strategy) {
        this.myMergingStrategies.add(strategy);
        this.myMergingStrategyClasses.add(aClass);
    }

    public <T> T mergeModels(Class<T> aClass, T ... implementations) {
        if (implementations.length == 1) {
            return implementations[0];
        }
        MergingInvocationHandler<T> handler2 = new MergingInvocationHandler<T>(aClass, Arrays.asList(implementations));
        return this._mergeModels(aClass, handler2, implementations);
    }

    public <T> T mergeModels(Class<T> aClass, Collection<? extends T> implementations) {
        return (T)this.mergeModels(aClass, implementations.toArray());
    }

    private <T> T _mergeModels(Class<? super T> aClass, MergingInvocationHandler<T> handler2, T ... implementations) {
        Set commonClasses = (Set)ModelMergerImpl.getCommonClasses(new THashSet(), implementations);
        commonClasses.add(MERGED_OBJECT_CLASS);
        commonClasses.add(aClass);
        Object t = AdvancedProxy.createProxy(handler2, null, commonClasses.toArray(new Class[commonClasses.size()]));
        return t;
    }

    private static <T extends Collection<Class>> T getCommonClasses(T result2, Object ... implementations) {
        if (implementations.length > 0) {
            DomUtil.getAllInterfaces(implementations[0].getClass(), result2);
            for (int i2 = 1; i2 < implementations.length; ++i2) {
                ArrayList list1 = new ArrayList();
                DomUtil.getAllInterfaces(implementations[i2].getClass(), list1);
                result2.retainAll(list1);
            }
        }
        return result2;
    }

    @Nullable
    private static Object getPrimaryKey(Object implementation, boolean singleValuedInvocation) {
        Method method2 = ModelMergerImpl.getPrimaryKeyMethod(implementation.getClass());
        if (method2 != null) {
            Object o = DomReflectionUtil.invokeMethod((Method)method2, (Object)implementation, (Object[])new Object[0]);
            return ReflectionUtil.isAssignable(GenericValue.class, method2.getReturnType()) ? ((GenericValue)o).getValue() : o;
        }
        if (implementation instanceof GenericValue) {
            return singleValuedInvocation ? Boolean.TRUE : ((GenericValue)implementation).getValue();
        }
        return null;
    }

    @Nullable
    private static Method getPrimaryKeyMethod(Class<?> aClass) {
        Method method2 = ourPrimaryKeyMethods.get(aClass);
        if (method2 == null) {
            Method method1;
            if (ourPrimaryKeyMethods.containsKey(aClass)) {
                return null;
            }
            Iterator iterator = ReflectionUtil.getClassPublicMethods(aClass).iterator();
            while (iterator.hasNext() && (method2 = ModelMergerImpl.findPrimaryKeyAnnotatedMethod(method1 = (Method)iterator.next(), aClass)) == null) {
            }
            ourPrimaryKeyMethods.put(aClass, method2);
        }
        return method2;
    }

    @Nullable
    private static Method findPrimaryKeyAnnotatedMethod(Method method2, Class aClass) {
        return method2.getReturnType() != Void.TYPE && method2.getParameterTypes().length == 0 ? new JavaMethodSignature(method2).findAnnotatedMethod(PrimaryKey.class, aClass) : null;
    }

    private List<Object> getMergedImplementations(Method method2, Object[] args, Class returnType, final List<Object> implementations, boolean intersect) throws IllegalAccessException, InvocationTargetException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (returnType.isInterface()) {
            SmartList orderedPrimaryKeys = new SmartList();
            FactoryMap<Object, List<Set<Object>>> map = new FactoryMap<Object, List<Set<Object>>>((List)orderedPrimaryKeys){
                final /* synthetic */ List val$orderedPrimaryKeys;
                {
                    this.val$orderedPrimaryKeys = list;
                }

                @NotNull
                protected List<Set<Object>> create(Object key2) {
                    this.val$orderedPrimaryKeys.add(key2);
                    SmartList smartList = new SmartList();
                    if (smartList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ModelMergerImpl$10", "create"));
                    }
                    return smartList;
                }
            };
            FactoryMap<Object, int[]> counts = new FactoryMap<Object, int[]>(){

                @NotNull
                protected int[] create(Object key2) {
                    int[] nArray = new int[implementations.size()];
                    if (nArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ModelMergerImpl$11", "create"));
                    }
                    return nArray;
                }
            };
            for (int i2 = 0; i2 < implementations.size(); ++i2) {
                Object t = implementations.get(i2);
                Object o = method2.invoke(t, args);
                if (o instanceof Collection) {
                    for (Object o1 : (Collection)o) {
                        this.addToMaps(o1, counts, map, i2, results, false, intersect);
                    }
                    continue;
                }
                if (o == null) continue;
                this.addToMaps(o, counts, map, i2, results, true, intersect);
            }
            for (Object primaryKey : orderedPrimaryKeys) {
                for (Set objects : (List)map.get(primaryKey)) {
                    results.add(this.mergeImplementations(returnType, new ArrayList<Object>(objects)));
                }
            }
        } else {
            HashSet<Object> map = new HashSet<Object>();
            for (Object t : implementations) {
                Object o = method2.invoke(t, args);
                if (o instanceof Collection) {
                    map.addAll((Collection)o);
                    continue;
                }
                if (o == null) continue;
                map.add(o);
                break;
            }
            results.addAll(map);
        }
        return results;
    }

    protected final Object mergeImplementations(Class returnType, List<Object> implementations) {
        for (int i2 = this.myMergingStrategies.size() - 1; i2 >= 0; --i2) {
            Object o;
            if (!ReflectionUtil.isAssignable((Class)this.myMergingStrategyClasses.get(i2), (Class)returnType) || (o = this.myMergingStrategies.get(i2).mergeChildren(returnType, implementations)) == null) continue;
            return o;
        }
        if (implementations.size() == 1) {
            return implementations.get(0);
        }
        return this.mergeModels((Class)returnType, (Collection)implementations);
    }

    private boolean addToMaps(Object o, FactoryMap<Object, int[]> counts, FactoryMap<Object, List<Set<Object>>> map, int index, List<Object> results, boolean singleValuedInvocation, boolean intersect) {
        Object primaryKey = ModelMergerImpl.getPrimaryKey(o, singleValuedInvocation);
        if (primaryKey != null || singleValuedInvocation) {
            int n;
            List list = (List)map.get(primaryKey);
            int[] indices = (int[])counts.get(primaryKey);
            if (intersect) {
                n = indices[index];
            } else {
                int n2 = index;
                int n3 = indices[n2];
                n = n3;
                indices[n2] = n3 + 1;
            }
            int objIndex = n;
            if (list.size() <= objIndex) {
                list.add(new LinkedHashSet());
            }
            ((Set)list.get(objIndex)).add(o);
            return false;
        }
        results.add(o);
        return true;
    }

    public class MergingInvocationHandler<T>
    implements InvocationHandler {
        private final Class<? super T> myClass;
        private List<T> myImplementations;

        public MergingInvocationHandler(Class<T> aClass, List<T> implementations) {
            this(aClass);
            for (T implementation : implementations) {
                if (implementation instanceof StableElement) {
                    throw new AssertionError((Object)("Stable values merging is prohibited: " + implementation));
                }
            }
            this.myImplementations = implementations;
        }

        public MergingInvocationHandler(Class<T> aClass) {
            this.myClass = aClass;
        }

        @NotNull
        private ModelMerger.InvocationStrategy findStrategy(Object proxy, Method method2) {
            for (Pair pair : (List)ModelMergerImpl.this.myAcceptsCache.get((Object)method2)) {
                if (!Object.class.equals(pair.second) && !((Class)pair.second).isInstance(proxy)) continue;
                ModelMerger.InvocationStrategy invocationStrategy = (ModelMerger.InvocationStrategy)pair.first;
                if (invocationStrategy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ModelMergerImpl$MergingInvocationHandler", "findStrategy"));
                }
                return invocationStrategy;
            }
            throw new AssertionError((Object)"impossible");
        }

        public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
            try {
                return this.findStrategy(proxy, method2).invokeMethod(this.getJavaMethod(method2), proxy, args, this.myImplementations);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private JavaMethod getJavaMethod(Method method2) {
            if (ReflectionUtil.isAssignable((Class)MERGED_OBJECT_CLASS, method2.getDeclaringClass())) {
                return JavaMethod.getMethod((Class)MERGED_OBJECT_CLASS, (Method)method2);
            }
            if (ReflectionUtil.isAssignable(method2.getDeclaringClass(), this.myClass)) {
                return JavaMethod.getMethod(this.myClass, (Method)method2);
            }
            return JavaMethod.getMethod(method2.getDeclaringClass(), (Method)method2);
        }
    }
}

