/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CompressedRefs {
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final TIntObjectHashMap<TIntArrayList> myTags;
    @NotNull
    private final TIntObjectHashMap<List<VcsRef>> myBranches;

    public CompressedRefs(@NotNull Set<VcsRef> refs, @NotNull VcsLogStorage storage2) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/CompressedRefs", "<init>"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/CompressedRefs", "<init>"));
        }
        this.myTags = new TIntObjectHashMap();
        this.myBranches = new TIntObjectHashMap();
        this.myStorage = storage2;
        Ref root = new Ref();
        refs.forEach(ref -> {
            assert (root.get() == null || ((VirtualFile)root.get()).equals(ref.getRoot())) : "All references are supposed to be from the single root";
            root.set((Object)ref.getRoot());
            if (ref.getType().isBranch()) {
                CompressedRefs.putRef(this.myBranches, ref, this.myStorage);
            } else {
                CompressedRefs.putRefIndex(this.myTags, ref, this.myStorage);
            }
        });
        this.myTags.forEachValue(list -> {
            list.trimToSize();
            return true;
        });
        this.myStorage.flush();
    }

    @NotNull
    SmartList<VcsRef> refsToCommit(int index) {
        TIntArrayList tags;
        SmartList result2 = new SmartList();
        if (this.myBranches.containsKey(index)) {
            result2.addAll((Collection)this.myBranches.get(index));
        }
        if ((tags = (TIntArrayList)this.myTags.get(index)) != null) {
            tags.forEach(value -> {
                result2.add((Object)this.myStorage.getVcsRef(value));
                return true;
            });
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "refsToCommit"));
        }
        return smartList;
    }

    @NotNull
    public Stream<VcsRef> streamBranches() {
        Stream<VcsRef> stream = TroveUtil.streamValues(this.myBranches).flatMap(Collection::stream);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "streamBranches"));
        }
        return stream;
    }

    @NotNull
    private Stream<VcsRef> streamTags() {
        Stream<VcsRef> stream = TroveUtil.streamValues(this.myTags).flatMapToInt(TroveUtil::stream).mapToObj(this.myStorage::getVcsRef);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "streamTags"));
        }
        return stream;
    }

    @NotNull
    public Stream<VcsRef> stream() {
        Stream<VcsRef> stream = Stream.concat(this.streamBranches(), this.streamTags());
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "stream"));
        }
        return stream;
    }

    @NotNull
    public Collection<VcsRef> getRefs() {
        AbstractCollection<VcsRef> abstractCollection = new AbstractCollection<VcsRef>(){
            private final Supplier<Collection<VcsRef>> myLoadedRefs = Suppliers.memoize(() -> CompressedRefs.this.stream().collect(Collectors.toList()));

            @Override
            @NotNull
            public Iterator<VcsRef> iterator() {
                Iterator<VcsRef> iterator = ((Collection)this.myLoadedRefs.get()).iterator();
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs$1", "iterator"));
                }
                return iterator;
            }

            @Override
            public int size() {
                return ((Collection)this.myLoadedRefs.get()).size();
            }
        };
        if (abstractCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "getRefs"));
        }
        return abstractCollection;
    }

    @NotNull
    public Collection<Integer> getCommits() {
        HashSet result2 = ContainerUtil.newHashSet();
        TroveUtil.streamKeys(this.myBranches).forEach(result2::add);
        TroveUtil.streamKeys(this.myTags).forEach(result2::add);
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "getCommits"));
        }
        return hashSet;
    }

    private static void putRef(@NotNull TIntObjectHashMap<List<VcsRef>> map, @NotNull VcsRef ref, @NotNull VcsLogStorage storage2) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/vcs/log/data/CompressedRefs", "putRef"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/data/CompressedRefs", "putRef"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/CompressedRefs", "putRef"));
        }
        int index = storage2.getCommitIndex(ref.getCommitHash(), ref.getRoot());
        List list = (List)map.get(index);
        if (list == null) {
            list = new SmartList();
            map.put(index, (Object)list);
        }
        list.add(ref);
    }

    private static void putRefIndex(@NotNull TIntObjectHashMap<TIntArrayList> map, @NotNull VcsRef ref, @NotNull VcsLogStorage storage2) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/vcs/log/data/CompressedRefs", "putRefIndex"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/data/CompressedRefs", "putRefIndex"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/CompressedRefs", "putRefIndex"));
        }
        int index = storage2.getCommitIndex(ref.getCommitHash(), ref.getRoot());
        TIntArrayList list = (TIntArrayList)map.get(index);
        if (list == null) {
            list = new TIntArrayList();
            map.put(index, (Object)list);
        }
        list.add(storage2.getRefIndex(ref));
    }
}

