/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.PersistentUtil;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;

public class VcsLogFullDetailsIndex<T>
implements Disposable {
    protected static final String INDEX = "index";
    @NotNull
    protected final MyMapReduceIndex myMapReduceIndex;
    @NotNull
    private final ID<Integer, T> myID;
    @NotNull
    private final String myLogId;
    @NotNull
    private final String myName;
    @NotNull
    protected final DataIndexer<Integer, T, VcsFullCommitDetails> myIndexer;
    @NotNull
    private final FatalErrorHandler myFatalErrorHandler;

    public VcsLogFullDetailsIndex(@NotNull String logId, @NotNull String name, int version, @NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, @NotNull DataExternalizer<T> externalizer, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        if (indexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        if (externalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        if (fatalErrorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        this.myID = ID.create((String)name);
        this.myName = name;
        this.myLogId = logId;
        this.myIndexer = indexer;
        this.myFatalErrorHandler = fatalErrorHandler;
        this.myMapReduceIndex = new MyMapReduceIndex(this.myIndexer, externalizer, version);
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    @NotNull
    public TIntHashSet getCommitsWithAnyKey(@NotNull Set<Integer> keys) throws StorageException {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getCommitsWithAnyKey"));
        }
        TIntHashSet result2 = new TIntHashSet();
        for (Integer key2 : keys) {
            this.iterateCommitIds(key2, (Consumer<Integer>)((Consumer)arg_0 -> ((TIntHashSet)result2).add(arg_0)));
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getCommitsWithAnyKey"));
        }
        return tIntHashSet;
    }

    @NotNull
    public TIntHashSet getCommitsWithAllKeys(@NotNull Collection<Integer> keys) throws StorageException {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getCommitsWithAllKeys"));
        }
        TIntHashSet tIntHashSet = InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)this.myMapReduceIndex, keys, k -> {
            ProgressManager.checkCanceled();
            return true;
        }, null, null);
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getCommitsWithAllKeys"));
        }
        return tIntHashSet;
    }

    private void iterateCommitIds(int key2, @NotNull Consumer<Integer> consumer) throws StorageException {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "iterateCommitIds"));
        }
        ValueContainer data = this.myMapReduceIndex.getData(key2);
        data.forEach((id, value) -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "lambda$iterateCommitIds$1"));
            }
            consumer.consume((Object)id);
            return true;
        });
    }

    protected void iterateCommitIdsAndValues(int key2, @NotNull ObjIntConsumer<T> consumer) throws StorageException {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "iterateCommitIdsAndValues"));
        }
        this.myMapReduceIndex.getData(key2).forEach((id, value) -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "lambda$iterateCommitIdsAndValues$2"));
            }
            consumer.accept(value, id);
            return true;
        });
    }

    protected boolean iterateCommitIdsAndValues(int key2, @NotNull BiPredicate<T, Integer> consumer) throws StorageException {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "iterateCommitIdsAndValues"));
        }
        return this.myMapReduceIndex.getData(key2).forEach((id, value) -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "lambda$iterateCommitIdsAndValues$3"));
            }
            return consumer.test(value, id);
        });
    }

    public void update(int commitId, @NotNull VcsFullCommitDetails details) throws IOException {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "update"));
        }
        this.myMapReduceIndex.update(commitId, details).compute();
    }

    public void flush() throws StorageException {
        this.myMapReduceIndex.flush();
    }

    public void dispose() {
        this.myMapReduceIndex.dispose();
    }

    @NotNull
    public static File getStorageFile(@NotNull String kind, @NotNull String id) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getStorageFile"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getStorageFile"));
        }
        File file2 = PersistentUtil.getStorageFile(INDEX, kind, id, VcsLogPersistentIndex.getVersion(), false);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getStorageFile"));
        }
        return file2;
    }

    private static class EmptyForwardIndex<T>
    implements ForwardIndex<Integer, T> {
        private EmptyForwardIndex() {
        }

        @NotNull
        public InputDataDiffBuilder<Integer, T> getDiffBuilder(int inputId) {
            EmptyInputDataDiffBuilder emptyInputDataDiffBuilder = new EmptyInputDataDiffBuilder(inputId);
            if (emptyInputDataDiffBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$EmptyForwardIndex", "getDiffBuilder"));
            }
            return emptyInputDataDiffBuilder;
        }

        public void putInputData(int inputId, @NotNull Map<Integer, T> data) throws IOException {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$EmptyForwardIndex", "putInputData"));
            }
        }

        public void flush() {
        }

        public void clear() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    private class MyIndexExtension
    extends IndexExtension<Integer, T, VcsFullCommitDetails> {
        @NotNull
        private final DataIndexer<Integer, T, VcsFullCommitDetails> myIndexer;
        @NotNull
        private final DataExternalizer<T> myExternalizer;
        private final int myVersion;

        public MyIndexExtension(@NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, DataExternalizer<T> externalizer, int version) {
            if (indexer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "<init>"));
            }
            if (externalizer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "<init>"));
            }
            this.myIndexer = indexer;
            this.myExternalizer = externalizer;
            this.myVersion = version;
        }

        @NotNull
        public ID<Integer, T> getName() {
            ID iD = VcsLogFullDetailsIndex.this.myID;
            if (iD == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "getName"));
            }
            return iD;
        }

        @NotNull
        public DataIndexer<Integer, T, VcsFullCommitDetails> getIndexer() {
            DataIndexer dataIndexer = this.myIndexer;
            if (dataIndexer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "getIndexer"));
            }
            return dataIndexer;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
            if (enumeratorIntegerDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "getKeyDescriptor"));
            }
            return enumeratorIntegerDescriptor;
        }

        @NotNull
        public DataExternalizer<T> getValueExternalizer() {
            DataExternalizer dataExternalizer = this.myExternalizer;
            if (dataExternalizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "getValueExternalizer"));
            }
            return dataExternalizer;
        }

        public int getVersion() {
            return this.myVersion;
        }
    }

    private static class MyMapIndexStorage<T>
    extends MapIndexStorage<Integer, T> {
        public MyMapIndexStorage(@NotNull String name, @NotNull String logId, @NotNull DataExternalizer<T> externalizer) throws IOException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapIndexStorage", "<init>"));
            }
            if (logId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapIndexStorage", "<init>"));
            }
            if (externalizer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapIndexStorage", "<init>"));
            }
            super(VcsLogFullDetailsIndex.getStorageFile(name, logId), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, externalizer, 5000, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }
    }

    private class MyMapReduceIndex
    extends MapReduceIndex<Integer, T, VcsFullCommitDetails> {
        public MyMapReduceIndex(@NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, DataExternalizer<T> externalizer, int version) throws IOException {
            if (indexer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapReduceIndex", "<init>"));
            }
            if (externalizer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapReduceIndex", "<init>"));
            }
            super((IndexExtension)new MyIndexExtension(indexer, externalizer, version), new MyMapIndexStorage(VcsLogFullDetailsIndex.this.myName, VcsLogFullDetailsIndex.this.myLogId, externalizer), new EmptyForwardIndex());
        }

        public void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        public void requestRebuild(@NotNull Exception ex) {
            if (ex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapReduceIndex", "requestRebuild"));
            }
            VcsLogFullDetailsIndex.this.myFatalErrorHandler.consume((Object)this, ex);
        }
    }
}

