/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIntHashSet;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogMessagesTrigramIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogUserIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import com.intellij.vcs.log.util.PersistentSet;
import com.intellij.vcs.log.util.PersistentSetImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.THash;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPersistentIndex
implements VcsLogIndex,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogPersistentIndex.class);
    private static final int VERSION = 1;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsLogProgress myProgress;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @Nullable
    private final IndexStorage myIndexStorage;
    @Nullable
    private final IndexDataGetter myDataGetter;
    @NotNull
    private final SingleTaskController<IndexingRequest, Void> mySingleTaskController;
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myNumberOfTasks;
    @NotNull
    private final List<VcsLogIndex.IndexingFinishedListener> myListeners;
    @NotNull
    private Map<VirtualFile, TIntHashSet> myCommitsToIndex;

    public VcsLogPersistentIndex(@NotNull Project project2, @NotNull VcsLogStorage storage2, @NotNull VcsLogProgress progress, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull FatalErrorHandler fatalErrorsConsumer, @NotNull Disposable disposableParent) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        if (fatalErrorsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorsConsumer", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "<init>"));
        }
        this.mySingleTaskController = new MySingleTaskController();
        this.myNumberOfTasks = ContainerUtil.newHashMap();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCommitsToIndex = ContainerUtil.newHashMap();
        this.myStorage = storage2;
        this.myProject = project2;
        this.myProgress = progress;
        this.myProviders = providers;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        this.myRoots = ContainerUtil.newLinkedHashSet();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            if (!((Boolean)VcsLogProperties.get((VcsLogProvider)entry.getValue(), (VcsLogProperties.VcsLogProperty)VcsLogProperties.SUPPORTS_INDEXING)).booleanValue()) continue;
            this.myRoots.add(entry.getKey());
        }
        this.myUserRegistry = (VcsUserRegistryImpl)ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        this.myIndexStorage = this.createIndexStorage(fatalErrorsConsumer, PersistentUtil.calcLogId(this.myProject, providers));
        this.myDataGetter = this.myIndexStorage != null ? new IndexDataGetter(this.myProject, this.myRoots, this.myIndexStorage, this.myFatalErrorsConsumer) : null;
        for (VirtualFile root : this.myRoots) {
            this.myNumberOfTasks.put(root, new AtomicInteger());
        }
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    protected IndexStorage createIndexStorage(@NotNull FatalErrorHandler fatalErrorHandler, @NotNull String logId) {
        if (fatalErrorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "createIndexStorage"));
        }
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "createIndexStorage"));
        }
        try {
            return (IndexStorage)IOUtil.openCleanOrResetBroken(() -> {
                if (logId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$createIndexStorage$0"));
                }
                if (fatalErrorHandler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$createIndexStorage$0"));
                }
                return new IndexStorage(logId, this.myUserRegistry, this.myRoots, fatalErrorHandler, this);
            }, () -> {
                if (logId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$createIndexStorage$1"));
                }
                IndexStorage.cleanup(logId);
            });
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return null;
        }
    }

    public static int getVersion() {
        return 6;
    }

    @Override
    public synchronized void scheduleIndex(boolean full) {
        if (this.myCommitsToIndex.isEmpty()) {
            return;
        }
        Map<VirtualFile, TIntHashSet> commitsToIndex = this.myCommitsToIndex;
        for (VirtualFile root : commitsToIndex.keySet()) {
            this.myNumberOfTasks.get(root).incrementAndGet();
        }
        this.myCommitsToIndex = ContainerUtil.newHashMap();
        this.mySingleTaskController.request(new IndexingRequest(commitsToIndex, full));
    }

    private void storeDetail(@NotNull VcsFullCommitDetails detail) {
        if (detail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detail", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "storeDetail"));
        }
        if (this.myIndexStorage == null) {
            return;
        }
        try {
            int index = this.myStorage.getCommitIndex((Hash)detail.getId(), detail.getRoot());
            this.myIndexStorage.messages.put((Object)index, (Object)detail.getFullMessage());
            this.myIndexStorage.trigrams.update(index, detail);
            this.myIndexStorage.users.update(index, detail);
            this.myIndexStorage.paths.update(index, detail);
            this.myIndexStorage.commits.put(index);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    private void flush() {
        try {
            if (this.myIndexStorage != null) {
                this.myIndexStorage.messages.force();
                this.myIndexStorage.trigrams.flush();
                this.myIndexStorage.users.flush();
                this.myIndexStorage.paths.flush();
                this.myIndexStorage.commits.flush();
            }
        }
        catch (StorageException e) {
            this.myFatalErrorsConsumer.consume(this, (Exception)((Object)e));
        }
    }

    @Override
    public void markCorrupted() {
        if (this.myIndexStorage != null) {
            this.myIndexStorage.commits.markCorrupted();
        }
    }

    @Override
    public boolean isIndexed(int commit) {
        try {
            return this.myIndexStorage == null || this.myIndexStorage.commits.contains(commit);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return false;
        }
    }

    @Override
    public synchronized boolean isIndexed(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "isIndexed"));
        }
        return this.myRoots.contains(root) && !this.myCommitsToIndex.containsKey(root) && this.myNumberOfTasks.get(root).get() == 0;
    }

    @Override
    public synchronized void markForIndexing(int index, @NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "markForIndexing"));
        }
        if (this.isIndexed(index) || !this.myRoots.contains(root)) {
            return;
        }
        TIntHashSet set2 = this.myCommitsToIndex.get(root);
        if (set2 == null) {
            set2 = new TIntHashSet();
            this.myCommitsToIndex.put(root, set2);
        }
        set2.add(index);
    }

    @NotNull
    private <T> TIntHashSet filter(@NotNull PersistentMap<Integer, T> map, @NotNull Condition<T> condition) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
        }
        TIntHashSet result2 = new TIntHashSet();
        if (this.myIndexStorage == null) {
            TIntHashSet tIntHashSet = result2;
            if (tIntHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
            }
            return tIntHashSet;
        }
        try {
            Processor processor2 = integer -> {
                if (map == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$filter$2"));
                }
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$filter$2"));
                }
                try {
                    Object value = map.get(integer);
                    if (value != null && condition.value(value)) {
                        result2.add(integer.intValue());
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            };
            if (this.myIndexStorage.messages instanceof PersistentHashMap) {
                ((PersistentHashMap)this.myIndexStorage.messages).processKeysWithExistingMapping(processor2);
            } else {
                this.myIndexStorage.messages.processKeys(processor2);
            }
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
        }
        return tIntHashSet;
    }

    @NotNull
    private TIntHashSet filterUsers(@NotNull Set<VcsUser> users) {
        if (users == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "users", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterUsers"));
        }
        if (this.myIndexStorage != null) {
            TIntHashSet tIntHashSet;
            try {
                tIntHashSet = this.myIndexStorage.users.getCommitsForUsers(users);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, (Exception)e);
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
            if (tIntHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterUsers"));
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = new TIntHashSet();
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterUsers"));
        }
        return tIntHashSet;
    }

    @NotNull
    private TIntHashSet filterPaths(@NotNull Collection<FilePath> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterPaths"));
        }
        if (this.myIndexStorage != null) {
            TIntHashSet tIntHashSet;
            try {
                tIntHashSet = this.myIndexStorage.paths.getCommitsForPaths(paths);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, (Exception)e);
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
            if (tIntHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterPaths"));
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = new TIntHashSet();
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterPaths"));
        }
        return tIntHashSet;
    }

    @NotNull
    public TIntHashSet filterMessages(@NotNull VcsLogTextFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterMessages"));
        }
        if (this.myIndexStorage != null) {
            block8: {
                TIntHashSet tIntHashSet;
                try {
                    TIntHashSet commitsForSearch;
                    if (filter.isRegex() || (commitsForSearch = this.myIndexStorage.trigrams.getCommitsForSubstring(filter.getText())) == null) break block8;
                    TIntHashSet result2 = new TIntHashSet();
                    commitsForSearch.forEach(commit -> {
                        if (filter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$filterMessages$3"));
                        }
                        try {
                            String value = (String)this.myIndexStorage.messages.get((Object)commit);
                            if (value != null && VcsLogTextFilterImpl.matches(filter, value)) {
                                result2.add(commit);
                            }
                        }
                        catch (IOException e) {
                            this.myFatalErrorsConsumer.consume(this, e);
                            return false;
                        }
                        return true;
                    });
                    tIntHashSet = result2;
                }
                catch (StorageException e) {
                    this.myFatalErrorsConsumer.consume(this, (Exception)((Object)e));
                }
                catch (RuntimeException e) {
                    this.processRuntimeException(e);
                }
                if (tIntHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterMessages"));
                }
                return tIntHashSet;
            }
            TIntHashSet tIntHashSet = this.filter(this.myIndexStorage.messages, message -> {
                if (filter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "lambda$filterMessages$4"));
                }
                return VcsLogTextFilterImpl.matches(filter, message);
            });
            if (tIntHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterMessages"));
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = EmptyIntHashSet.INSTANCE;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filterMessages"));
        }
        return tIntHashSet;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "processRuntimeException"));
        }
        if (this.myIndexStorage != null) {
            this.myIndexStorage.markCorrupted();
        }
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            throw new RuntimeException(e);
        }
        this.myFatalErrorsConsumer.consume(this, e);
    }

    @Override
    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "canFilter"));
        }
        if (filters.isEmpty() || this.myIndexStorage == null) {
            return false;
        }
        for (VcsLogDetailsFilter filter : filters) {
            if (filter instanceof VcsLogTextFilter || filter instanceof VcsLogUserFilter || filter instanceof VcsLogStructureFilter) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsFilters", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        TIntHashSet filteredByMessage = null;
        if (textFilter != null) {
            filteredByMessage = this.filterMessages(textFilter);
        }
        TIntHashSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = ContainerUtil.newHashSet();
            for (VirtualFile root : this.myRoots) {
                users.addAll(userFilter.getUsers(root));
            }
            filteredByUser = this.filterUsers(users);
        }
        TIntHashSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        Set<Integer> set2 = TroveUtil.intersect(filteredByMessage, filteredByPath, filteredByUser);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "filter"));
        }
        return set2;
    }

    @Override
    @Nullable
    public IndexDataGetter getDataGetter() {
        if (this.myIndexStorage == null) {
            return null;
        }
        return this.myDataGetter;
    }

    @Override
    public void addListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "addListener"));
        }
        this.myListeners.add(l);
    }

    @Override
    public void removeListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex", "removeListener"));
        }
        this.myListeners.remove(l);
    }

    public void dispose() {
    }

    private static class CommitsCounter {
        @NotNull
        public final ProgressIndicator indicator;
        public final int allCommits;
        public volatile int newIndexedCommits;
        public volatile int oldCommits;

        private CommitsCounter(@NotNull ProgressIndicator indicator, int commits) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$CommitsCounter", "<init>"));
            }
            this.indicator = indicator;
            this.allCommits = commits;
        }

        public void displayProgress() {
            this.indicator.setFraction(((double)this.newIndexedCommits + (double)this.oldCommits) / (double)this.allCommits);
        }
    }

    private class IndexingRequest {
        private static final int MAGIC_NUMBER = 150000;
        private static final int BATCH_SIZE = 1000;
        private final Map<VirtualFile, TIntHashSet> myCommits;
        private final boolean myFull;

        public IndexingRequest(Map<VirtualFile, TIntHashSet> commits, boolean full) {
            if (commits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "<init>"));
            }
            this.myCommits = commits;
            this.myFull = full;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "run"));
            }
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            long time = System.currentTimeMillis();
            CommitsCounter counter = new CommitsCounter(indicator, this.myCommits.values().stream().mapToInt(THash::size).sum());
            LOG.debug("Indexing " + counter.allCommits + " commits");
            for (VirtualFile root : this.myCommits.keySet()) {
                try {
                    if (this.myFull) {
                        this.indexAll(root, this.myCommits.get(root), counter);
                    } else {
                        this.indexOneByOne(root, this.myCommits.get(root), counter);
                    }
                }
                finally {
                    ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(root)).decrementAndGet();
                }
                if (!VcsLogPersistentIndex.this.isIndexed(root)) continue;
                VcsLogPersistentIndex.this.myListeners.forEach(listener2 -> listener2.indexingFinished(root));
            }
            LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - time) + " for indexing " + counter.newIndexedCommits + " new commits out of " + counter.allCommits);
            int leftCommits = counter.allCommits - counter.newIndexedCommits - counter.oldCommits;
            if (leftCommits > 0) {
                LOG.warn("Did not index " + leftCommits + " commits");
            }
        }

        private void indexOneByOne(@NotNull VirtualFile root, @NotNull TIntHashSet commitsSet, @NotNull CommitsCounter counter) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            if (commitsSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsSet", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            if (counter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            IntStream commits = TroveUtil.stream(commitsSet).filter(c -> {
                if (counter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexOneByOne$1"));
                }
                if (VcsLogPersistentIndex.this.isIndexed(c)) {
                    ++counter.oldCommits;
                    return false;
                }
                return true;
            });
            this.indexOneByOne(root, counter, commits);
        }

        private void indexOneByOne(@NotNull VirtualFile root, @NotNull CommitsCounter counter, @NotNull IntStream commits) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            if (counter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            if (commits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            TroveUtil.processBatches(commits, 1000, (Consumer<TIntHashSet>)((Consumer)batch -> {
                if (counter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexOneByOne$2"));
                }
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexOneByOne$2"));
                }
                counter.indicator.checkCanceled();
                if (this.indexOneByOne(root, (TIntHashSet)batch)) {
                    counter.newIndexedCommits += batch.size();
                }
                counter.displayProgress();
            }));
            VcsLogPersistentIndex.this.flush();
        }

        private boolean indexOneByOne(@NotNull VirtualFile root, @NotNull TIntHashSet commits) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            if (commits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexOneByOne"));
            }
            VcsLogProvider provider = (VcsLogProvider)VcsLogPersistentIndex.this.myProviders.get(root);
            try {
                List<String> hashes = TroveUtil.map(commits, value -> VcsLogPersistentIndex.this.myStorage.getCommitId(value).getHash().asString());
                provider.readFullDetails(root, hashes, x$0 -> VcsLogPersistentIndex.this.storeDetail(x$0));
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
                commits.forEach(value -> {
                    if (root == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexOneByOne$5"));
                    }
                    VcsLogPersistentIndex.this.markForIndexing(value, root);
                    return true;
                });
                return false;
            }
            return true;
        }

        public void indexAll(@NotNull VirtualFile root, @NotNull TIntHashSet commitsSet, @NotNull CommitsCounter counter) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexAll"));
            }
            if (commitsSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsSet", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexAll"));
            }
            if (counter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "indexAll"));
            }
            TIntHashSet notIndexed = new TIntHashSet();
            TroveUtil.stream(commitsSet).forEach(c -> {
                if (counter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexAll$6"));
                }
                if (VcsLogPersistentIndex.this.isIndexed(c)) {
                    ++counter.oldCommits;
                } else {
                    notIndexed.add(c);
                }
            });
            counter.displayProgress();
            if (notIndexed.size() <= 150000) {
                this.indexOneByOne(root, counter, TroveUtil.stream(notIndexed));
            } else {
                try {
                    ((VcsLogProvider)VcsLogPersistentIndex.this.myProviders.get(root)).readAllFullDetails(root, details -> {
                        if (counter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexAll$7"));
                        }
                        int index = VcsLogPersistentIndex.this.myStorage.getCommitIndex((Hash)details.getId(), details.getRoot());
                        if (notIndexed.contains(index)) {
                            VcsLogPersistentIndex.this.storeDetail(details);
                            ++counter.newIndexedCommits;
                        }
                        counter.indicator.checkCanceled();
                        counter.displayProgress();
                    });
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                    notIndexed.forEach(value -> {
                        if (root == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest", "lambda$indexAll$8"));
                        }
                        VcsLogPersistentIndex.this.markForIndexing(value, root);
                        return true;
                    });
                }
            }
            VcsLogPersistentIndex.this.flush();
        }
    }

    private class MySingleTaskController
    extends SingleTaskController<IndexingRequest, Void> {
        public MySingleTaskController() {
            super(EmptyConsumer.getInstance());
        }

        @Override
        protected void startNewBackgroundTask() {
            ApplicationManager.getApplication().invokeLater(() -> {
                Task.Backgroundable task = new Task.Backgroundable(VcsLogPersistentIndex.this.myProject, "Indexing Commit Data", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                    public void run(@NotNull ProgressIndicator indicator) {
                        List requests;
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController$1", "run"));
                        }
                        while (!(requests = MySingleTaskController.this.popRequests()).isEmpty()) {
                            for (IndexingRequest request : requests) {
                                try {
                                    request.run(indicator);
                                }
                                catch (ProcessCanceledException reThrown) {
                                    throw reThrown;
                                }
                                catch (Throwable t) {
                                    LOG.error("Error while indexing", t);
                                }
                            }
                        }
                        MySingleTaskController.this.taskCompleted(null);
                    }
                };
                ProgressIndicator indicator = VcsLogPersistentIndex.this.myProgress.createProgressIndicator(false);
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, indicator);
            });
        }
    }

    static class IndexStorage {
        private static final String INPUTS = "inputs";
        private static final String COMMITS = "commits";
        private static final String MESSAGES = "messages";
        private static final int MESSAGES_VERSION = 0;
        @NotNull
        public final PersistentSet<Integer> commits;
        @NotNull
        public final PersistentMap<Integer, String> messages;
        @NotNull
        public final VcsLogMessagesTrigramIndex trigrams;
        @NotNull
        public final VcsLogUserIndex users;
        @NotNull
        public final VcsLogPathsIndex paths;

        public IndexStorage(@NotNull String logId, @NotNull VcsUserRegistryImpl userRegistry, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable parentDisposable) throws IOException {
            if (logId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexStorage", "<init>"));
            }
            if (userRegistry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userRegistry", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexStorage", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexStorage", "<init>"));
            }
            if (fatalErrorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexStorage", "<init>"));
            }
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexStorage", "<init>"));
            }
            Disposable disposable = Disposer.newDisposable();
            Disposer.register((Disposable)parentDisposable, (Disposable)disposable);
            try {
                int version = VcsLogPersistentIndex.getVersion();
                File commitsStorage = PersistentUtil.getStorageFile("index", COMMITS, logId, version, true);
                this.commits = new PersistentSetImpl<Integer>(commitsStorage, (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE, Page.PAGE_SIZE, null, version);
                Disposer.register((Disposable)disposable, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::close)));
                File messagesStorage = PersistentUtil.getStorageFile("index", MESSAGES, logId, 5, true);
                this.messages = new PersistentHashMap(messagesStorage, (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)EnumeratorStringDescriptor.INSTANCE, Page.PAGE_SIZE);
                Disposer.register((Disposable)disposable, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.messages.close())));
                this.trigrams = new VcsLogMessagesTrigramIndex(logId, fatalErrorHandler, disposable);
                this.users = new VcsLogUserIndex(logId, userRegistry, fatalErrorHandler, disposable);
                this.paths = new VcsLogPathsIndex(logId, roots, fatalErrorHandler, disposable);
            }
            catch (Throwable t) {
                Disposer.dispose((Disposable)disposable);
                throw t;
            }
            PersistentUtil.cleanupOldStorageFile(MESSAGES, logId);
            PersistentUtil.cleanupOldStorageFile("index-trigrams", logId);
            PersistentUtil.cleanupOldStorageFile("index-no-trigrams", logId);
            PersistentUtil.cleanupOldStorageFile("index-inputs-trigrams", logId);
            PersistentUtil.cleanupOldStorageFile("index-paths", logId);
            PersistentUtil.cleanupOldStorageFile("index-no-paths", logId);
            PersistentUtil.cleanupOldStorageFile("index-paths-ids", logId);
            PersistentUtil.cleanupOldStorageFile("index-inputs-paths", logId);
            PersistentUtil.cleanupOldStorageFile("index-users", logId);
            PersistentUtil.cleanupOldStorageFile("index-inputs-users", logId);
        }

        void markCorrupted() {
            IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::markCorrupted));
        }

        private static void catchAndWarn(@NotNull ThrowableRunnable<IOException> runnable2) {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexStorage", "catchAndWarn"));
            }
            try {
                runnable2.run();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        private static void cleanup(@NotNull String logId) {
            if (logId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexStorage", "cleanup"));
            }
            if (!PersistentUtil.cleanupStorageFiles("index", logId)) {
                LOG.error("Could not clean up storage files in " + new File(PersistentUtil.LOG_CACHE, "index") + " starting with " + logId);
            }
        }
    }
}

