/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.history;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.history.FileHistoryFilterer;
import com.intellij.vcs.log.ui.history.FileHistoryUi;
import com.intellij.vcs.log.ui.history.FileHistoryUiProperties;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import org.jetbrains.annotations.NotNull;

public class FileHistoryUiFactory
implements VcsLogManager.VcsLogUiFactory<FileHistoryUi> {
    @NotNull
    private FilePath myFilePath;

    public FileHistoryUiFactory(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/ui/history/FileHistoryUiFactory", "<init>"));
        }
        this.myFilePath = path;
    }

    @Override
    public FileHistoryUi createLogUi(@NotNull Project project2, @NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/history/FileHistoryUiFactory", "createLogUi"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/history/FileHistoryUiFactory", "createLogUi"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/history/FileHistoryUiFactory", "createLogUi"));
        }
        FileHistoryUiProperties properties = (FileHistoryUiProperties)ServiceManager.getService((Project)project2, FileHistoryUiProperties.class);
        return new FileHistoryUi(logData, project2, colorManager, properties, new VisiblePackRefresherImpl(project2, logData, PermanentGraph.SortType.Normal, new FileHistoryFilterer(logData, this.myFilePath)), this.myFilePath);
    }
}

