/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.history;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Vcs.Log.History.Properties", storages={@Storage(file="$WORKSPACE_FILE$")})
public class FileHistoryUiProperties
implements VcsLogUiProperties,
PersistentStateComponent<State> {
    public static final VcsLogUiProperties.VcsLogUiProperty<Boolean> SHOW_ALL_BRANCHES = new VcsLogUiProperties.VcsLogUiProperty("Table.ShowOtherBranches");
    @NotNull
    private final Collection<VcsLogUiProperties.PropertiesChangeListener> myListeners = ContainerUtil.newLinkedHashSet();
    private State myState = new State();

    @Override
    @NotNull
    public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "get"));
        }
        if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
            Boolean bl = this.myState.SHOW_DETAILS;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "get"));
            }
            return (T)bl;
        }
        if (SHOW_ALL_BRANCHES.equals(property)) {
            Boolean bl = this.myState.SHOW_OTHER_BRANCHES;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "get"));
            }
            return (T)bl;
        }
        if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
            ArrayList order = this.myState.COLUMN_ORDER;
            if (order == null || order.isEmpty()) {
                order = ContainerUtilRt.newArrayList((Object[])new Integer[]{0, 2, 3, 1});
            }
            ArrayList arrayList = order;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "get"));
            }
            return (T)arrayList;
        }
        if (property instanceof CommonUiProperties.TableColumnProperty) {
            Integer savedWidth = this.myState.COLUMN_WIDTH.get(((CommonUiProperties.TableColumnProperty)property).getColumn());
            if (savedWidth == null) {
                Integer n = -1;
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "get"));
                }
                return (T)n;
            }
            Integer n = savedWidth;
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "get"));
            }
            return (T)n;
        }
        throw new UnsupportedOperationException("Unknown property " + property);
    }

    @Override
    public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, @NotNull T value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "set"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "set"));
        }
        if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
            this.myState.SHOW_DETAILS = (Boolean)value;
        } else if (SHOW_ALL_BRANCHES.equals(property)) {
            this.myState.SHOW_OTHER_BRANCHES = (Boolean)value;
        } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
            this.myState.COLUMN_ORDER = (List)value;
        } else if (property instanceof CommonUiProperties.TableColumnProperty) {
            this.myState.COLUMN_WIDTH.put(((CommonUiProperties.TableColumnProperty)property).getColumn(), (Integer)value);
        } else {
            throw new UnsupportedOperationException("Unknown property " + property);
        }
        this.myListeners.forEach(l -> {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "lambda$set$0"));
            }
            l.onPropertyChanged(property);
        });
    }

    @Override
    public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "exists"));
        }
        return CommonUiProperties.SHOW_DETAILS.equals(property) || SHOW_ALL_BRANCHES.equals(property) || CommonUiProperties.COLUMN_ORDER.equals(property) || property instanceof CommonUiProperties.TableColumnProperty;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    @Override
    public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "addChangeListener"));
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/ui/history/FileHistoryUiProperties", "removeChangeListener"));
        }
        this.myListeners.remove(listener2);
    }

    public static class State {
        public boolean SHOW_DETAILS = false;
        public boolean SHOW_OTHER_BRANCHES = false;
        public Map<Integer, Integer> COLUMN_WIDTH = ContainerUtil.newHashMap();
        public List<Integer> COLUMN_ORDER = ContainerUtil.newArrayList();
    }
}

