/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XDebuggerInlayUtil {
    public static void createInlay(@NotNull Project project2, @NotNull VirtualFile file2, int offset, String inlayText) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerInlayUtil", "createInlay"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/XDebuggerInlayUtil", "createInlay"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerInlayUtil", "lambda$createInlay$0"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/XDebuggerInlayUtil", "lambda$createInlay$0"));
            }
            FileEditor editor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(file2);
            if (editor instanceof TextEditor) {
                int insertOffset;
                Editor e = ((TextEditor)editor).getEditor();
                CharSequence text = e.getDocument().getImmutableCharSequence();
                for (insertOffset = offset; insertOffset < text.length() && Character.isJavaIdentifierPart(text.charAt(insertOffset)); ++insertOffset) {
                }
                List existing = e.getInlayModel().getInlineElementsInRange(insertOffset, insertOffset);
                for (Inlay inlay : existing) {
                    if (!(inlay.getRenderer() instanceof MyRenderer)) continue;
                    Disposer.dispose((Disposable)inlay);
                }
                e.getInlayModel().addInlineElement(insertOffset, (EditorCustomElementRenderer)new MyRenderer(inlayText));
            }
        });
    }

    public static void clearInlays(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerInlayUtil", "clearInlays"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            FileEditor[] editors;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerInlayUtil", "lambda$clearInlays$1"));
            }
            for (FileEditor editor : editors = FileEditorManager.getInstance((Project)project2).getAllEditors()) {
                if (!(editor instanceof TextEditor)) continue;
                Editor e = ((TextEditor)editor).getEditor();
                List existing = e.getInlayModel().getInlineElementsInRange(0, e.getDocument().getTextLength());
                for (Inlay inlay : existing) {
                    if (!(inlay.getRenderer() instanceof MyRenderer)) continue;
                    Disposer.dispose((Disposable)inlay);
                }
            }
        });
    }

    private static class MyRenderer
    implements EditorCustomElementRenderer {
        private final String myText;

        private MyRenderer(String text) {
            this.myText = "(" + text + ")";
        }

        private static FontInfo getFontInfo(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/XDebuggerInlayUtil$MyRenderer", "getFontInfo"));
            }
            EditorColorsScheme colorsScheme = editor.getColorsScheme();
            FontPreferences fontPreferences = colorsScheme.getFontPreferences();
            TextAttributes attributes = editor.getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
            int fontStyle = attributes == null ? 0 : attributes.getFontType();
            return ComplementaryFontsRegistry.getFontAbleToDisplay(97, fontStyle, fontPreferences, FontInfo.getFontRenderContext(editor.getContentComponent()));
        }

        public int calcWidthInPixels(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/XDebuggerInlayUtil$MyRenderer", "calcWidthInPixels"));
            }
            FontInfo fontInfo = MyRenderer.getFontInfo(editor);
            return fontInfo.fontMetrics().stringWidth(this.myText);
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/XDebuggerInlayUtil$MyRenderer", "paint"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/xdebugger/impl/XDebuggerInlayUtil$MyRenderer", "paint"));
            }
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/xdebugger/impl/XDebuggerInlayUtil$MyRenderer", "paint"));
            }
            TextAttributes attributes = editor.getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
            if (attributes == null) {
                return;
            }
            Color fgColor = attributes.getForegroundColor();
            if (fgColor == null) {
                return;
            }
            g.setColor(fgColor);
            FontInfo fontInfo = MyRenderer.getFontInfo(editor);
            g.setFont(fontInfo.getFont());
            FontMetrics metrics = fontInfo.fontMetrics();
            g.drawString(this.myText, r.x, r.y + metrics.getAscent());
        }
    }
}

