/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.breakpoints.XExpressionState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class XDebuggerWatchesManager
implements PersistentStateComponent<WatchesManagerState> {
    private final Map<String, XExpression[]> watches = ContainerUtil.newConcurrentMap();

    @NotNull
    public XExpression[] getWatches(String confName) {
        XExpression[] expressions = this.watches.get(confName);
        if (expressions == null) {
            XExpression[] xExpressionArray = new XExpression[]{};
            if (xExpressionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerWatchesManager", "getWatches"));
            }
            return xExpressionArray;
        }
        if (expressions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerWatchesManager", "getWatches"));
        }
        return expressions;
    }

    public void setWatches(String configurationName, XExpression[] expressions) {
        if (expressions != null && expressions.length > 0) {
            this.watches.put(configurationName, expressions);
        } else {
            this.watches.remove(configurationName);
        }
    }

    public WatchesManagerState getState() {
        WatchesManagerState state = new WatchesManagerState();
        for (Map.Entry<String, XExpression[]> entry : this.watches.entrySet()) {
            state.expressions.add(new ConfigurationState(entry.getKey(), entry.getValue()));
        }
        return state;
    }

    public void loadState(WatchesManagerState state) {
        this.watches.clear();
        if (state != null) {
            for (ConfigurationState expressionState : state.expressions) {
                XExpression[] expressions = (XExpression[])ContainerUtil.mapNotNull((Object[])expressionState.myExpressionStates, XExpressionState::toXExpression, (Object[])new XExpression[0]);
                this.watches.put(expressionState.myName, expressions);
            }
        }
    }

    @Tag(value="watch")
    public static class WatchState
    extends XExpressionState {
        public WatchState() {
        }

        public WatchState(XExpression expression) {
            super(expression);
        }
    }

    @Tag(value="configuration")
    public static class ConfigurationState {
        @Attribute(value="name")
        public String myName;
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public WatchState[] myExpressionStates;

        public ConfigurationState() {
        }

        public ConfigurationState(String name, XExpression[] expressions) {
            this.myName = name;
            this.myExpressionStates = new WatchState[expressions.length];
            for (int i2 = 0; i2 < expressions.length; ++i2) {
                this.myExpressionStates[i2] = new WatchState(expressions[i2]);
            }
        }
    }

    @Tag(value="watches-manager")
    public static class WatchesManagerState {
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<ConfigurationState> expressions = new ArrayList<ConfigurationState>();
    }
}

