/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XErrorValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class WatchNodeImpl
extends XValueNodeImpl
implements WatchNode {
    private final XExpression myExpression;

    public WatchNodeImpl(@NotNull XDebuggerTree tree, @NotNull WatchesRootNode parent, @NotNull XExpression expression, @Nullable XStackFrame stackFrame) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl", "<init>"));
        }
        super(tree, parent, expression.getExpression(), (XValue)new XWatchValue(expression, tree, stackFrame));
        this.myExpression = expression;
    }

    @Override
    @NotNull
    public XExpression getExpression() {
        XExpression xExpression = this.myExpression;
        if (xExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl", "getExpression"));
        }
        return xExpression;
    }

    @Override
    @NotNull
    public XValue getValueContainer() {
        XValue container = (XValue)super.getValueContainer();
        XValue value = ((XWatchValue)container).myValue;
        XValue xValue = value != null ? value : container;
        if (xValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl", "getValueContainer"));
        }
        return xValue;
    }

    void computePresentationIfNeeded() {
        if (this.getValuePresentation() == null) {
            this.getValueContainer().computePresentation((XValueNode)this, XValuePlace.TREE);
        }
    }

    private static class XWatchValue
    extends XNamedValue {
        private final XExpression myExpression;
        private final XDebuggerTree myTree;
        private final XStackFrame myStackFrame;
        private volatile XValue myValue;
        private static final XValuePresentation EMPTY_PRESENTATION = new XValuePresentation(){

            @NotNull
            public String getSeparator() {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$1", "getSeparator"));
                }
                return "";
            }

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                if (renderer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$1", "renderValue"));
                }
            }
        };

        public XWatchValue(XExpression expression, XDebuggerTree tree, XStackFrame stackFrame) {
            super(expression.getExpression());
            this.myExpression = expression;
            this.myTree = tree;
            this.myStackFrame = stackFrame;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue", "computeChildren"));
            }
            if (this.myValue != null) {
                this.myValue.computeChildren(node);
            }
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue", "computePresentation"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue", "computePresentation"));
            }
            if (this.myStackFrame != null) {
                if (this.myTree.isShowing() || ApplicationManager.getApplication().isUnitTestMode()) {
                    XDebuggerEvaluator evaluator = this.myStackFrame.getEvaluator();
                    if (evaluator != null) {
                        evaluator.evaluate(this.myExpression, (XDebuggerEvaluator.XEvaluationCallback)new MyEvaluationCallback(node, place), this.myStackFrame.getSourcePosition());
                        return;
                    }
                } else {
                    return;
                }
            }
            node.setPresentation(AllIcons.Debugger.Watch, EMPTY_PRESENTATION, false);
        }

        @Nullable
        public String getEvaluationExpression() {
            return this.myValue != null ? this.myValue.getEvaluationExpression() : null;
        }

        @NotNull
        public Promise<XExpression> calculateEvaluationExpression() {
            Promise promise2 = Promise.resolve((Object)this.myExpression);
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue", "calculateEvaluationExpression"));
            }
            return promise2;
        }

        @Nullable
        public XInstanceEvaluator getInstanceEvaluator() {
            return this.myValue != null ? this.myValue.getInstanceEvaluator() : null;
        }

        @Nullable
        public XValueModifier getModifier() {
            return this.myValue != null ? this.myValue.getModifier() : null;
        }

        public void computeSourcePosition(@NotNull XNavigatable navigatable) {
            if (navigatable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue", "computeSourcePosition"));
            }
            if (this.myValue != null) {
                this.myValue.computeSourcePosition(navigatable);
            }
        }

        @NotNull
        public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue", "computeInlineDebuggerData"));
            }
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue", "computeInlineDebuggerData"));
            }
            return threeState;
        }

        public boolean canNavigateToSource() {
            return this.myValue != null && this.myValue.canNavigateToSource();
        }

        public boolean canNavigateToTypeSource() {
            return this.myValue != null && this.myValue.canNavigateToTypeSource();
        }

        public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
            if (navigatable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue", "computeTypeSourcePosition"));
            }
            if (this.myValue != null) {
                this.myValue.computeTypeSourcePosition(navigatable);
            }
        }

        @Nullable
        public XReferrersProvider getReferrersProvider() {
            return this.myValue != null ? this.myValue.getReferrersProvider() : null;
        }

        private class MyEvaluationCallback
        extends XEvaluationCallbackBase
        implements Obsolescent {
            @NotNull
            private final XValueNode myNode;
            @NotNull
            private final XValuePlace myPlace;

            public MyEvaluationCallback(@NotNull XValueNode node, XValuePlace place) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$MyEvaluationCallback", "<init>"));
                }
                if (place == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$MyEvaluationCallback", "<init>"));
                }
                this.myNode = node;
                this.myPlace = place;
            }

            public boolean isObsolete() {
                return this.myNode.isObsolete();
            }

            public void evaluated(@NotNull XValue result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$MyEvaluationCallback", "evaluated"));
                }
                XWatchValue.this.myValue = result2;
                result2.computePresentation(this.myNode, this.myPlace);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$MyEvaluationCallback", "errorOccurred"));
                }
                this.myNode.setPresentation(XDebuggerUIConstants.ERROR_MESSAGE_ICON, (XValuePresentation)new XErrorValuePresentation(errorMessage), false);
            }
        }
    }
}

