/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.jetbrains.jsonSchema.JsonSchemaFileType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import com.jetbrains.jsonSchema.impl.JsonValueAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonBySchemaObjectAnnotator
implements Annotator {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.jsonSchema.JsonBySchemaAnnotator");
    private static final Key<Set<PsiElement>> ANNOTATED_PROPERTIES = Key.create((String)"JsonSchema.Properties.Annotated");
    @NotNull
    private final VirtualFile mySchemaFile;
    private final JsonSchemaObject myRootSchema;

    public JsonBySchemaObjectAnnotator(@NotNull VirtualFile schemaFile, @NotNull JsonSchemaObject schema) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "<init>"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "<init>"));
        }
        this.mySchemaFile = schemaFile;
        this.myRootSchema = schema;
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "annotate"));
        }
        JsonLikePsiWalker walker = JsonSchemaWalker.getWalker(element, this.myRootSchema);
        if (walker == null) {
            return;
        }
        JsonPropertyAdapter firstProp = walker.getParentPropertyAdapter(element);
        if (firstProp == null) {
            JsonValueAdapter root = JsonBySchemaObjectAnnotator.findTopLevelElement(walker, element);
            if (root != null) {
                this.checkRootObject(holder, root, walker);
            }
            return;
        }
        if (JsonBySchemaObjectAnnotator.checkIfAlreadyProcessed(holder, firstProp.getDelegate())) {
            return;
        }
        JsonValueAdapter firstPropValue = firstProp.getValue();
        if (firstPropValue != null) {
            this.checkFirstPropValue(element, holder, walker, firstProp, firstPropValue);
        }
        if (firstProp.getParentObject() != null && walker.isTopJsonElement(firstProp.getParentObject().getDelegate().getParent())) {
            this.checkRootObject(holder, firstProp.getParentObject(), walker);
        }
        if (firstProp.getParentArray() != null && walker.isTopJsonElement(firstProp.getParentArray().getDelegate().getParent())) {
            this.checkRootObject(holder, firstProp.getParentArray(), walker);
        }
    }

    private void checkFirstPropValue(@NotNull PsiElement element, @NotNull AnnotationHolder holder, final JsonLikePsiWalker walker, JsonPropertyAdapter firstProp, final JsonValueAdapter firstPropValue) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "checkFirstPropValue"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "checkFirstPropValue"));
        }
        final ArrayList checkers = new ArrayList();
        JsonSchemaWalker.findSchemasForAnnotation(firstProp.getDelegate(), JsonSchemaWalker.getWalker(element, this.myRootSchema), new JsonSchemaWalker.CompletionSchemesConsumer(){

            @Override
            public void consume(boolean isName, @NotNull JsonSchemaObject schema, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                if (schema == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$1", "consume"));
                }
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$1", "consume"));
                }
                if (steps == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$1", "consume"));
                }
                BySchemaChecker checker = new BySchemaChecker(walker);
                HashSet validatedProperties = new HashSet();
                checker.checkByScheme(firstPropValue, schema, validatedProperties);
                checkers.add(checker);
            }

            @Override
            public void oneOf(boolean isName, @NotNull List<JsonSchemaObject> list, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$1", "oneOf"));
                }
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$1", "oneOf"));
                }
                if (steps == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$1", "oneOf"));
                }
                BySchemaChecker checker = new BySchemaChecker(walker);
                HashSet validatedProperties = new HashSet();
                checker.processOneOf(firstPropValue, list, validatedProperties);
                checkers.add(checker);
            }

            @Override
            public void anyOf(boolean isName, @NotNull List<JsonSchemaObject> list, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$1", "anyOf"));
                }
                if (schemaFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$1", "anyOf"));
                }
                if (steps == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$1", "anyOf"));
                }
                BySchemaChecker checker = new BySchemaChecker(walker);
                HashSet validatedProperties = new HashSet();
                checker.processAnyOf(firstPropValue, list, validatedProperties);
                checkers.add(checker);
            }
        }, this.myRootSchema, this.mySchemaFile);
        if (checkers.isEmpty()) {
            return;
        }
        BySchemaChecker checker = null;
        if (checkers.size() == 1) {
            checker = (BySchemaChecker)checkers.get(0);
        } else {
            for (BySchemaChecker schemaChecker : checkers) {
                if (schemaChecker.isHadTypeError()) continue;
                checker = schemaChecker;
                break;
            }
            if (checker == null) {
                checker = (BySchemaChecker)checkers.get(0);
            }
        }
        JsonBySchemaObjectAnnotator.processCheckerResults(holder, checker);
    }

    private static JsonValueAdapter findTopLevelElement(@NotNull JsonLikePsiWalker walker, @NotNull PsiElement element) {
        if (walker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "walker", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "findTopLevelElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "findTopLevelElement"));
        }
        Ref ref = new Ref();
        PsiTreeUtil.findFirstParent((PsiElement)element, el -> {
            if (walker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "walker", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "lambda$findTopLevelElement$0"));
            }
            boolean isTop = walker.isTopJsonElement((PsiElement)el);
            if (!isTop) {
                ref.set(el);
            }
            return isTop;
        });
        return ref.isNull() ? null : walker.createValueAdapter((PsiElement)ref.get());
    }

    private void checkRootObject(@NotNull AnnotationHolder holder, @NotNull JsonValueAdapter adapter, JsonLikePsiWalker walker) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "checkRootObject"));
        }
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "checkRootObject"));
        }
        if (!adapter.isObject() && !adapter.isArray()) {
            return;
        }
        BySchemaChecker rootChecker = new BySchemaChecker(walker);
        HashSet validatedProperties = new HashSet();
        rootChecker.checkByScheme(adapter, this.myRootSchema, validatedProperties);
        JsonBySchemaObjectAnnotator.processCheckerResults(holder, rootChecker);
    }

    private static boolean checkIfAlreadyProcessed(@NotNull AnnotationHolder holder, PsiElement property) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "checkIfAlreadyProcessed"));
        }
        AnnotationSession session2 = holder.getCurrentAnnotationSession();
        HashSet<PsiElement> data = (HashSet<PsiElement>)session2.getUserData(ANNOTATED_PROPERTIES);
        if (data == null) {
            data = new HashSet<PsiElement>();
            session2.putUserData(ANNOTATED_PROPERTIES, data);
        }
        if (data.contains(property)) {
            return true;
        }
        data.add(property);
        return false;
    }

    private static void processCheckerResults(@NotNull AnnotationHolder holder, BySchemaChecker checker) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "processCheckerResults"));
        }
        if (!checker.isCorrect()) {
            for (Map.Entry<PsiElement, String> entry : checker.getErrors().entrySet()) {
                if (JsonBySchemaObjectAnnotator.checkIfAlreadyProcessed(holder, entry.getKey())) continue;
                holder.createWarningAnnotation(entry.getKey(), entry.getValue());
            }
        }
    }

    @Nullable
    private static JsonSchemaType matchSchemaType(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType input) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "matchSchemaType"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "matchSchemaType"));
        }
        if (schema.getType() != null) {
            JsonSchemaType matchType = schema.getType();
            if (matchType == input) {
                return matchType;
            }
            if (input == JsonSchemaType._integer && matchType == JsonSchemaType._number) {
                return JsonSchemaType._number;
            }
        }
        if (schema.getTypeVariants() != null) {
            List<JsonSchemaType> matchTypes = schema.getTypeVariants();
            if (matchTypes.contains((Object)input)) {
                return input;
            }
            if (input == JsonSchemaType._integer && matchTypes.contains((Object)JsonSchemaType._number)) {
                return JsonSchemaType._number;
            }
        }
        return null;
    }

    @Nullable
    private static JsonSchemaType getType(JsonValueAdapter value) {
        if (value.isNull()) {
            return JsonSchemaType._null;
        }
        if (value.isBooleanLiteral()) {
            return JsonSchemaType._boolean;
        }
        if (value.isStringLiteral()) {
            return JsonSchemaType._string;
        }
        if (value.isArray()) {
            return JsonSchemaType._array;
        }
        if (value.isObject()) {
            return JsonSchemaType._object;
        }
        if (value.isNumberLiteral()) {
            return JsonBySchemaObjectAnnotator.isInteger(value.getDelegate().getText()) ? JsonSchemaType._integer : JsonSchemaType._number;
        }
        return null;
    }

    private static boolean isInteger(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "isInteger"));
        }
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static class BySchemaChecker {
        private final JsonLikePsiWalker myWalker;
        private final Map<PsiElement, String> myErrors;
        private boolean myHadTypeError;

        public BySchemaChecker(JsonLikePsiWalker walker) {
            this.myWalker = walker;
            this.myErrors = new HashMap<PsiElement, String>();
        }

        public Map<PsiElement, String> getErrors() {
            return this.myErrors;
        }

        public boolean isHadTypeError() {
            return this.myHadTypeError;
        }

        private void error(String error, PsiElement holder) {
            if (this.myErrors.containsKey(holder)) {
                return;
            }
            this.myErrors.put(holder, error);
        }

        private void typeError(@NotNull PsiElement value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "typeError"));
            }
            this.error("Type is not allowed", value);
            this.myHadTypeError = true;
        }

        private void checkByScheme(@Nullable JsonValueAdapter value, @NotNull JsonSchemaObject schema, Set<String> validatedProperties) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "checkByScheme"));
            }
            if (value == null) {
                return;
            }
            if (schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) {
                this.processAnyOf(value, JsonSchemaWalker.mergeList(schema.getAnyOf(), schema, false), validatedProperties);
            } else if (schema.getOneOf() != null && !schema.getOneOf().isEmpty()) {
                this.processOneOf(value, JsonSchemaWalker.mergeList(schema.getOneOf(), schema, true), validatedProperties);
            } else if (schema.getAllOf() != null && !schema.getAllOf().isEmpty()) {
                this.checkByScheme(value, JsonSchemaWalker.mergeAll(schema), validatedProperties);
            } else {
                this.checkBySchemeBare(value, schema, validatedProperties);
            }
        }

        private void checkBySchemeBare(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema, Set<String> validatedProperties) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "checkBySchemeBare"));
            }
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "checkBySchemeBare"));
            }
            JsonSchemaType type = JsonBySchemaObjectAnnotator.getType(value);
            if (type != null) {
                JsonSchemaType schemaType = JsonBySchemaObjectAnnotator.matchSchemaType(schema, type);
                if (schemaType == null && schema.hasSpecifiedType()) {
                    this.typeError(value.getDelegate());
                } else if (JsonSchemaType._boolean.equals((Object)type)) {
                    this.checkForEnum(value.getDelegate(), schema);
                } else if (JsonSchemaType._number.equals((Object)type) || JsonSchemaType._integer.equals((Object)type)) {
                    this.checkNumber(value.getDelegate(), schema, schemaType);
                    this.checkForEnum(value.getDelegate(), schema);
                } else if (JsonSchemaType._string.equals((Object)type)) {
                    this.checkString(value.getDelegate(), schema);
                    this.checkForEnum(value.getDelegate(), schema);
                } else if (JsonSchemaType._array.equals((Object)type)) {
                    this.checkArray(value, schema);
                    this.checkForEnum(value.getDelegate(), schema);
                } else if (JsonSchemaType._object.equals((Object)type)) {
                    this.checkObject(value, schema, validatedProperties);
                    this.checkForEnum(value.getDelegate(), schema);
                }
            }
            if (schema.getNot() != null) {
                BySchemaChecker checker = new BySchemaChecker(this.myWalker);
                checker.checkByScheme(value, schema.getNot(), new HashSet<String>());
                if (checker.isCorrect()) {
                    this.error("Validates against 'not' schema", value.getDelegate());
                }
            }
        }

        private void checkObject(JsonValueAdapter value, JsonSchemaObject schema, Set<String> validatedProperties) {
            Map<String, JsonSchemaObject> properties = schema.getProperties();
            JsonObjectValueAdapter object = value.getAsObject();
            if (object == null) {
                return;
            }
            List<JsonPropertyAdapter> propertyList = object.getPropertyList();
            HashSet<String> set2 = new HashSet<String>();
            for (JsonPropertyAdapter jsonPropertyAdapter : propertyList) {
                set2.add(jsonPropertyAdapter.getName());
                JsonValueAdapter jsonValueAdapter = jsonPropertyAdapter.getValue();
                JsonSchemaObject jsonSchemaObject = properties.get(jsonPropertyAdapter.getName());
                if (jsonSchemaObject != null) {
                    this.checkByScheme(jsonValueAdapter, jsonSchemaObject, new HashSet<String>());
                } else {
                    JsonSchemaObject patternSchema = schema.getMatchingPatternPropertySchema(StringUtil.notNullize((String)jsonPropertyAdapter.getName()));
                    if (patternSchema != null) {
                        this.checkByScheme(jsonValueAdapter, patternSchema, new HashSet<String>());
                    } else if (schema.getAdditionalPropertiesSchema() != null) {
                        this.checkByScheme(jsonValueAdapter, schema.getAdditionalPropertiesSchema(), new HashSet<String>());
                    } else if (!Boolean.TRUE.equals(schema.getAdditionalPropertiesAllowed()) && !validatedProperties.contains(jsonPropertyAdapter.getName())) {
                        this.error("Property '" + jsonPropertyAdapter.getName() + "' is not allowed", jsonPropertyAdapter.getDelegate());
                    }
                }
                validatedProperties.add(jsonPropertyAdapter.getName());
            }
            if (object.shouldCheckIntegralRequirements()) {
                Map<String, JsonSchemaObject> map;
                Map<String, List<String>> map2;
                List<String> required = schema.getRequired();
                if (required != null) {
                    for (String string : required) {
                        if (set2.contains(string)) continue;
                        this.error("Missing required property '" + string + "'", value.getDelegate());
                    }
                }
                if (schema.getMinProperties() != null && propertyList.size() < schema.getMinProperties()) {
                    this.error("Number of properties is less than " + schema.getMinProperties(), value.getDelegate());
                }
                if (schema.getMaxProperties() != null && propertyList.size() > schema.getMaxProperties()) {
                    this.error("Number of properties is greater than " + schema.getMaxProperties(), value.getDelegate());
                }
                if ((map2 = schema.getPropertyDependencies()) != null) {
                    for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
                        if (!set2.contains(entry.getKey())) continue;
                        List<String> list = entry.getValue();
                        for (String s : list) {
                            if (set2.contains(s)) continue;
                            this.error("Dependency is violated: '" + s + "' must be specified, since '" + entry.getKey() + "' is specified", value.getDelegate());
                        }
                    }
                }
                if ((map = schema.getSchemaDependencies()) != null) {
                    for (Map.Entry<String, JsonSchemaObject> entry : map.entrySet()) {
                        if (!set2.contains(entry.getKey())) continue;
                        this.checkByScheme(value, entry.getValue(), new HashSet<String>());
                    }
                }
            }
            this.validateAsJsonSchema(object.getDelegate());
        }

        private void validateAsJsonSchema(@NotNull PsiElement objElement) {
            if (objElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objElement", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "validateAsJsonSchema"));
            }
            JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)objElement, JsonObject.class);
            if (object == null) {
                return;
            }
            if (JsonSchemaFileType.INSTANCE.equals(object.getContainingFile().getFileType())) {
                final VirtualFile schemaFile = object.getContainingFile().getVirtualFile();
                if (schemaFile == null) {
                    return;
                }
                Processor processor2 = schemaObject -> {
                    List<JsonSchemaWalker.Step> steps = BySchemaChecker.skipProperties(JsonOriginalPsiWalker.INSTANCE.findPosition(object, false, true));
                    JsonSchemaWalker.CompletionSchemesConsumer consumer = new JsonSchemaWalker.CompletionSchemesConsumer(){

                        @Override
                        public void consume(boolean isName, @NotNull JsonSchemaObject schema, @NotNull VirtualFile schemaFile1, @NotNull List<JsonSchemaWalker.Step> steps1) {
                            if (schema == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "consume"));
                            }
                            if (schemaFile1 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile1", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "consume"));
                            }
                            if (steps1 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps1", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "consume"));
                            }
                            if (schemaFile.equals(schemaFile1)) {
                                JsonProperty pattern;
                                SmartPsiElementPointer<JsonObject> pointer;
                                String patternError;
                                JsonObject element;
                                Map<SmartPsiElementPointer<JsonObject>, String> invalidPatternProperties = schema.getInvalidPatternProperties();
                                if (invalidPatternProperties != null) {
                                    for (Map.Entry<SmartPsiElementPointer<JsonObject>, String> entry : invalidPatternProperties.entrySet()) {
                                        PsiElement parent;
                                        element = (JsonObject)entry.getKey().getElement();
                                        if (element == null || !element.isValid() || !((parent = element.getParent()) instanceof JsonProperty)) continue;
                                        this.error(StringUtil.convertLineSeparators((String)entry.getValue()), ((JsonProperty)parent).getNameElement());
                                    }
                                }
                                if ((patternError = schema.getPatternError()) != null && schema.getPattern() != null && (element = (JsonObject)(pointer = schema.getPeerPointer()).getElement()) != null && element.isValid() && (pattern = element.findProperty("pattern")) != null) {
                                    this.error(StringUtil.convertLineSeparators((String)patternError), pattern.getValue());
                                }
                            }
                        }

                        @Override
                        public void oneOf(boolean isName, @NotNull List<JsonSchemaObject> list, @NotNull VirtualFile schemaFile2, @NotNull List<JsonSchemaWalker.Step> steps) {
                            if (list == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "oneOf"));
                            }
                            if (schemaFile2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "oneOf"));
                            }
                            if (steps == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "oneOf"));
                            }
                            list.forEach(s -> {
                                if (schemaFile2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "lambda$oneOf$0"));
                                }
                                if (steps == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "lambda$oneOf$0"));
                                }
                                this.consume(isName, (JsonSchemaObject)s, schemaFile2, steps);
                            });
                        }

                        @Override
                        public void anyOf(boolean isName, @NotNull List<JsonSchemaObject> list, @NotNull VirtualFile schemaFile2, @NotNull List<JsonSchemaWalker.Step> steps) {
                            if (list == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "anyOf"));
                            }
                            if (schemaFile2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "anyOf"));
                            }
                            if (steps == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "anyOf"));
                            }
                            list.forEach(s -> {
                                if (schemaFile2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "lambda$anyOf$1"));
                                }
                                if (steps == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$1", "lambda$anyOf$1"));
                                }
                                this.consume(isName, (JsonSchemaObject)s, schemaFile2, steps);
                            });
                        }
                    };
                    JsonSchemaWalker.extractSchemaVariants(object.getProject(), consumer, schemaFile, schemaObject, false, steps, true);
                    return true;
                };
                JsonSchemaService.Impl.getEx(object.getProject()).visitSchemaObject(object.getContainingFile().getVirtualFile(), (Processor<JsonSchemaObject>)processor2);
            }
        }

        private static List<JsonSchemaWalker.Step> skipProperties(List<JsonSchemaWalker.Step> position) {
            Iterator<JsonSchemaWalker.Step> iterator = position.iterator();
            boolean canSkip = true;
            while (iterator.hasNext()) {
                JsonSchemaWalker.Step step = iterator.next();
                if (canSkip && step.getTransition() instanceof JsonSchemaWalker.PropertyTransition && "properties".equals(((JsonSchemaWalker.PropertyTransition)step.getTransition()).getName())) {
                    iterator.remove();
                    canSkip = false;
                    continue;
                }
                canSkip = true;
            }
            return position;
        }

        private void checkForEnum(PsiElement value, JsonSchemaObject schema) {
            if (schema.getEnum() == null || schema.getPattern() != null) {
                return;
            }
            String text = StringUtil.notNullize((String)value.getText());
            List<Object> objects = schema.getEnum();
            for (Object object : objects) {
                if (!(this.myWalker.onlyDoubleQuotesForStringLiterals() ? object.toString().equalsIgnoreCase(text) : BySchemaChecker.equalsIgnoreQuotesAndCase(object.toString(), text))) continue;
                return;
            }
            this.error("Value should be one of: [" + StringUtil.join(objects, o -> o.toString(), (String)", ") + "]", value);
        }

        private static boolean equalsIgnoreQuotesAndCase(@NotNull String s1, @NotNull String s2) {
            boolean quoted2;
            if (s1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "equalsIgnoreQuotesAndCase"));
            }
            if (s2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "equalsIgnoreQuotesAndCase"));
            }
            boolean quoted1 = StringUtil.isQuotedString((String)s1);
            if (quoted1 != (quoted2 = StringUtil.isQuotedString((String)s2))) {
                return false;
            }
            if (!quoted1) {
                return s1.equalsIgnoreCase(s2);
            }
            return StringUtil.unquoteString((String)s1).equalsIgnoreCase(StringUtil.unquoteString((String)s2));
        }

        private void checkArray(JsonValueAdapter value, JsonSchemaObject schema) {
            JsonArrayValueAdapter asArray = value.getAsArray();
            if (asArray == null) {
                return;
            }
            List<JsonValueAdapter> elements = asArray.getElements();
            if (schema.getMinLength() != null && elements.size() < schema.getMinLength()) {
                this.error("Array is shorter than " + schema.getMinLength(), value.getDelegate());
                return;
            }
            new ArrayItemsChecker().check(value, elements, schema);
        }

        private void checkString(PsiElement propValue, JsonSchemaObject schema) {
            String value = StringUtil.unquoteString((String)propValue.getText());
            if (schema.getMinLength() != null && value.length() < schema.getMinLength()) {
                this.error("String is shorter than " + schema.getMinLength(), propValue);
                return;
            }
            if (schema.getMaxLength() != null && value.length() > schema.getMaxLength()) {
                this.error("String is longer than " + schema.getMaxLength(), propValue);
                return;
            }
            if (schema.getPattern() != null) {
                if (schema.getPatternError() != null) {
                    this.error("Can not check string by pattern because of error: " + StringUtil.convertLineSeparators((String)schema.getPatternError()), propValue);
                }
                if (!schema.checkByPattern(value)) {
                    this.error("String is violating the pattern: '" + StringUtil.convertLineSeparators((String)schema.getPattern()) + "'", propValue);
                }
            }
        }

        private void checkNumber(PsiElement propValue, JsonSchemaObject schema, JsonSchemaType schemaType) {
            double leftOver;
            Number value;
            if (JsonSchemaType._integer.equals((Object)schemaType)) {
                try {
                    value = Integer.valueOf(propValue.getText());
                }
                catch (NumberFormatException e) {
                    this.error("Integer value expected", propValue);
                    return;
                }
            }
            try {
                value = Double.valueOf(propValue.getText());
            }
            catch (NumberFormatException e) {
                this.error("Double value expected", propValue);
                return;
            }
            Number multipleOf = schema.getMultipleOf();
            if (multipleOf != null && (leftOver = value.doubleValue() % multipleOf.doubleValue()) > 1.0E-6) {
                String multipleOfValue = String.valueOf(Math.abs(multipleOf.doubleValue() - (double)multipleOf.intValue()) < 1.0E-6 ? (Number)multipleOf.intValue() : (Number)multipleOf);
                this.error("Is not multiple of " + multipleOfValue, propValue);
                return;
            }
            if (schema.getMinimum() != null) {
                this.checkMinimum(schema, value, propValue, schemaType);
            }
            if (schema.getMaximum() != null) {
                this.checkMaximum(schema, value, propValue, schemaType);
            }
        }

        private void checkMaximum(JsonSchemaObject schema, Number value, PsiElement propertyValue, @NotNull JsonSchemaType propValueType) {
            if (propValueType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propValueType", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "checkMaximum"));
            }
            if (JsonSchemaType._integer.equals((Object)propValueType)) {
                int intValue = schema.getMaximum().intValue();
                if (Boolean.TRUE.equals(schema.isExclusiveMaximum())) {
                    if (value.intValue() >= intValue) {
                        this.error("Greater than an exclusive maximum " + intValue, propertyValue);
                    }
                } else if (value.intValue() > intValue) {
                    this.error("Greater than a maximum " + intValue, propertyValue);
                }
            } else {
                double doubleValue = schema.getMaximum().doubleValue();
                if (Boolean.TRUE.equals(schema.isExclusiveMaximum())) {
                    if (value.doubleValue() >= doubleValue) {
                        this.error("Greater than an exclusive maximum " + schema.getMinimum(), propertyValue);
                    }
                } else if (value.doubleValue() > doubleValue) {
                    this.error("Greater than a maximum " + schema.getMaximum(), propertyValue);
                }
            }
        }

        private void checkMinimum(JsonSchemaObject schema, Number value, PsiElement propertyValue, @NotNull JsonSchemaType schemaType) {
            if (schemaType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaType", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "checkMinimum"));
            }
            if (JsonSchemaType._integer.equals((Object)schemaType)) {
                int intValue = schema.getMinimum().intValue();
                if (Boolean.TRUE.equals(schema.isExclusiveMinimum())) {
                    if (value.intValue() <= intValue) {
                        this.error("Less than an exclusive minimum " + intValue, propertyValue);
                    }
                } else if (value.intValue() < intValue) {
                    this.error("Less than a minimum " + intValue, propertyValue);
                }
            } else {
                double doubleValue = schema.getMinimum().doubleValue();
                if (Boolean.TRUE.equals(schema.isExclusiveMinimum())) {
                    if (value.doubleValue() <= doubleValue) {
                        this.error("Less than an exclusive minimum " + schema.getMinimum(), propertyValue);
                    }
                } else if (value.doubleValue() < doubleValue) {
                    this.error("Less than a minimum " + schema.getMinimum(), propertyValue);
                }
            }
        }

        private void processOneOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> oneOf, Set<String> validatedProperties) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "processOneOf"));
            }
            HashMap<PsiElement, String> errors = new HashMap<PsiElement, String>();
            int cntCorrect = 0;
            boolean validatedPropertiesAdded = false;
            for (JsonSchemaObject jsonSchemaObject : oneOf) {
                if (jsonSchemaObject.isShouldValidateAgainstJSType()) continue;
                BySchemaChecker checker = new BySchemaChecker(this.myWalker);
                HashSet<String> local = new HashSet<String>();
                checker.checkByScheme(value, jsonSchemaObject, local);
                if (checker.isCorrect()) {
                    errors.clear();
                    if (!validatedPropertiesAdded) {
                        validatedPropertiesAdded = true;
                        validatedProperties.addAll(local);
                    }
                    ++cntCorrect;
                    continue;
                }
                if (!errors.isEmpty() && !BySchemaChecker.notTypeError(value.getDelegate(), checker)) continue;
                errors.clear();
                errors.putAll(checker.getErrors());
            }
            if (cntCorrect == 1) {
                return;
            }
            if (cntCorrect > 0) {
                JsonSchemaType type = JsonBySchemaObjectAnnotator.getType(value);
                if (type != null) {
                    this.error("Validates to more than one variant", value.getDelegate());
                }
            } else if (!errors.isEmpty()) {
                for (Map.Entry entry : errors.entrySet()) {
                    this.error((String)entry.getValue(), (PsiElement)entry.getKey());
                }
            }
        }

        private static boolean notTypeError(PsiElement value, BySchemaChecker checker) {
            if (!checker.isHadTypeError()) {
                return true;
            }
            return !checker.getErrors().containsKey(value);
        }

        private void processAnyOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> anyOf, Set<String> validatedProperties) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "processAnyOf"));
            }
            HashMap<PsiElement, String> errors = new HashMap<PsiElement, String>();
            for (JsonSchemaObject jsonSchemaObject : anyOf) {
                BySchemaChecker checker = new BySchemaChecker(this.myWalker);
                HashSet<String> local = new HashSet<String>();
                checker.checkBySchemeBare(value, jsonSchemaObject, local);
                if (checker.isCorrect()) {
                    validatedProperties.addAll(local);
                    return;
                }
                if (!errors.isEmpty() || !BySchemaChecker.notTypeError(value.getDelegate(), checker)) continue;
                errors.clear();
                errors.putAll(checker.getErrors());
            }
            if (!errors.isEmpty()) {
                for (Map.Entry entry : errors.entrySet()) {
                    this.error((String)entry.getValue(), (PsiElement)entry.getKey());
                }
            }
        }

        private boolean isCorrect() {
            return this.myErrors.isEmpty();
        }

        private class ArrayItemsChecker {
            private final Map<String, JsonValueAdapter> myValueTexts = new HashMap<String, JsonValueAdapter>();
            private List<JsonValueAdapter> myNonUnique;
            private boolean myCheckUnique;

            private ArrayItemsChecker() {
            }

            public void check(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list, JsonSchemaObject schema) {
                if (array == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$ArrayItemsChecker", "check"));
                }
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker$ArrayItemsChecker", "check"));
                }
                this.myCheckUnique = schema.isUniqueItems();
                if (schema.getItemsSchema() != null) {
                    for (JsonValueAdapter jsonValueAdapter : list) {
                        BySchemaChecker.this.checkByScheme(jsonValueAdapter, schema.getItemsSchema(), new HashSet());
                        this.checkUnique(jsonValueAdapter);
                    }
                } else if (schema.getItemsSchemaList() != null) {
                    Iterator<JsonSchemaObject> iterator = schema.getItemsSchemaList().iterator();
                    for (JsonValueAdapter arrayValue : list) {
                        if (iterator.hasNext()) {
                            BySchemaChecker.this.checkByScheme(arrayValue, iterator.next(), new HashSet());
                        } else if (!Boolean.TRUE.equals(schema.getAdditionalItemsAllowed())) {
                            BySchemaChecker.this.error("Additional items are not allowed", arrayValue.getDelegate());
                        }
                        this.checkUnique(arrayValue);
                    }
                } else {
                    for (JsonValueAdapter jsonValueAdapter : list) {
                        this.checkUnique(jsonValueAdapter);
                    }
                }
                if (this.myNonUnique != null) {
                    for (JsonValueAdapter jsonValueAdapter : this.myNonUnique) {
                        BySchemaChecker.this.error("Item is not unique", jsonValueAdapter.getDelegate());
                    }
                }
                if (schema.getMinItems() != null && list.size() < schema.getMinItems()) {
                    BySchemaChecker.this.error("Array is shorter than " + schema.getMinItems(), array.getDelegate());
                }
                if (schema.getMaxItems() != null && list.size() > schema.getMaxItems()) {
                    BySchemaChecker.this.error("Array is longer than " + schema.getMaxItems(), array.getDelegate());
                }
            }

            private void checkUnique(JsonValueAdapter arrayValue) {
                String text = arrayValue.getDelegate().getText();
                if (this.myCheckUnique && this.myValueTexts.containsKey(text)) {
                    if (this.myNonUnique == null) {
                        this.myNonUnique = new ArrayList<JsonValueAdapter>();
                    }
                    this.myNonUnique.add(arrayValue);
                    this.myNonUnique.add(this.myValueTexts.get(text));
                }
                this.myValueTexts.put(text, arrayValue);
            }
        }
    }
}

