/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.impl.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonJsonPropertyAdapter;
import com.jetbrains.jsonSchema.impl.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonPropertyAdapter;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonJsonObjectAdapter
implements JsonObjectValueAdapter {
    @NotNull
    private final JsonObject myValue;

    public JsonJsonObjectAdapter(@NotNull JsonObject value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonJsonObjectAdapter", "<init>"));
        }
        this.myValue = value;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isStringLiteral() {
        return false;
    }

    @Override
    public boolean isNumberLiteral() {
        return false;
    }

    @Override
    public boolean isBooleanLiteral() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement getDelegate() {
        JsonObject jsonObject = this.myValue;
        if (jsonObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonJsonObjectAdapter", "getDelegate"));
        }
        return jsonObject;
    }

    @Override
    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return this;
    }

    @Override
    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }

    @Override
    @NotNull
    public List<JsonPropertyAdapter> getPropertyList() {
        List<JsonPropertyAdapter> list = this.myValue.getPropertyList().stream().filter(p -> p != null).map(p -> new JsonJsonPropertyAdapter((JsonProperty)p)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonJsonObjectAdapter", "getPropertyList"));
        }
        return list;
    }
}

