/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.jetbrains.jsonSchema.JsonSchemaFileType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonLikePsiWalkerFactory;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaExportedDefinitions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceEx;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaWalker {
    public static final JsonOriginalPsiWalker JSON_ORIGINAL_PSI_WALKER = new JsonOriginalPsiWalker();

    public static void findSchemasForAnnotation(@NotNull PsiElement element, @NotNull JsonLikePsiWalker walker, @NotNull CompletionSchemesConsumer consumer, @NotNull JsonSchemaObject rootSchema, @NotNull VirtualFile schemaFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForAnnotation"));
        }
        if (walker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "walker", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForAnnotation"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForAnnotation"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForAnnotation"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForAnnotation"));
        }
        List<Step> position = walker.findPosition(element, false, true);
        if (position == null || position.isEmpty()) {
            return;
        }
        Step firstStep = position.get(0);
        if (JsonSchemaFileType.INSTANCE.equals(element.getContainingFile().getFileType()) && firstStep != null && firstStep.getTransition() instanceof PropertyTransition && "definitions".equals(((PropertyTransition)firstStep.getTransition()).getName())) {
            return;
        }
        JsonSchemaWalker.extractSchemaVariants(element.getProject(), consumer, schemaFile, rootSchema, false, position, true);
    }

    public static void findSchemasForCompletion(@NotNull PsiElement element, @NotNull JsonLikePsiWalker walker, @NotNull CompletionSchemesConsumer consumer, @NotNull JsonSchemaObject rootSchema, @NotNull VirtualFile schemaFile) {
        boolean isName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForCompletion"));
        }
        if (walker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "walker", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForCompletion"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForCompletion"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForCompletion"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForCompletion"));
        }
        PsiElement checkable = walker.goUpToCheckable(element);
        if (checkable == null) {
            return;
        }
        List<Step> position = walker.findPosition(checkable, isName, !(isName = walker.isName(checkable)));
        if (position == null || position.isEmpty()) {
            if (isName) {
                consumer.consume(true, rootSchema, schemaFile, Collections.emptyList());
            }
            return;
        }
        JsonSchemaWalker.extractSchemaVariants(element.getProject(), consumer, schemaFile, rootSchema, isName, position, false);
    }

    public static void findSchemasForDocumentation(@NotNull PsiElement element, @NotNull JsonLikePsiWalker walker, @NotNull CompletionSchemesConsumer consumer, @NotNull JsonSchemaObject rootSchema, @NotNull VirtualFile schemaFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForDocumentation"));
        }
        if (walker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "walker", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForDocumentation"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForDocumentation"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForDocumentation"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForDocumentation"));
        }
        PsiElement checkable = walker.goUpToCheckable(element);
        if (checkable == null) {
            return;
        }
        List<Step> position = walker.findPosition(checkable, true, true);
        if (position == null || position.isEmpty()) {
            consumer.consume(true, rootSchema, schemaFile, Collections.emptyList());
            return;
        }
        JsonSchemaWalker.extractSchemaVariants(element.getProject(), consumer, schemaFile, rootSchema, true, position, false);
    }

    public static Pair<List<Step>, String> buildSteps(@NotNull String nameInSchema) {
        if (nameInSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameInSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "buildSteps"));
        }
        List chain = StringUtil.split((String)JsonSchemaExportedDefinitions.normalizeId(nameInSchema).replace("\\", "/"), (String)"/");
        List steps = chain.stream().filter(s -> !s.isEmpty()).map(item -> new Step(StateType._unknown, new PropertyTransition((String)item))).collect(Collectors.toList());
        if (steps.isEmpty()) {
            return Pair.create(Collections.emptyList(), (Object)nameInSchema);
        }
        return Pair.create(steps, chain.get(chain.size() - 1));
    }

    public static void extractSchemaVariants(@NotNull Project project2, @NotNull CompletionSchemesConsumer consumer, @NotNull VirtualFile rootSchemaFile, @NotNull JsonSchemaObject rootSchema, boolean isName, List<Step> position, boolean acceptAdditionalPropertiesSchemas) {
        Trinity trinity;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        if (rootSchemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        HashSet<Trinity> control = new HashSet<Trinity>();
        JsonSchemaServiceEx serviceEx = JsonSchemaService.Impl.getEx(project2);
        ArrayDeque<Trinity<JsonSchemaObject, VirtualFile, List<Step>>> queue = new ArrayDeque<Trinity<JsonSchemaObject, VirtualFile, List<Step>>>();
        queue.add(Trinity.create((Object)rootSchema, (Object)rootSchemaFile, position));
        while (!queue.isEmpty() && control.add(trinity = (Trinity)queue.removeFirst())) {
            JsonSchemaObject object = (JsonSchemaObject)trinity.getFirst();
            VirtualFile schemaFile = (VirtualFile)trinity.getSecond();
            List path = (List)trinity.getThird();
            if (path.isEmpty()) {
                consumer.consume(isName, object, schemaFile, path);
                continue;
            }
            DefinitionsResolver definitionsResolver = new DefinitionsResolver(path);
            JsonSchemaWalker.extractSchemaVariants(definitionsResolver, object, path, acceptAdditionalPropertiesSchemas);
            if (definitionsResolver.isFound()) {
                List<JsonSchemaObject> matchedSchemas = definitionsResolver.getSchemaObjects();
                matchedSchemas.forEach(matchedSchema -> {
                    List<JsonSchemaObject> list = JsonSchemaWalker.gatherSchemas(matchedSchema);
                    for (JsonSchemaObject schemaObject : list) {
                        if (schemaObject.getDefinitionAddress() == null || schemaObject.getDefinitionAddress().startsWith("#/")) continue;
                        ArrayList<Step> steps = new ArrayList<Step>();
                        if (!isName) {
                            steps.add(new Step(StateType._value, null));
                        }
                        JsonSchemaWalker.visitSchemaByDefinitionAddress(serviceEx, queue, schemaFile, schemaObject.getDefinitionAddress(), steps);
                    }
                });
                if (matchedSchemas.size() == 1) {
                    consumer.consume(isName, matchedSchemas.get(0), schemaFile, path);
                    continue;
                }
                if (definitionsResolver.isOneOf()) {
                    consumer.oneOf(isName, matchedSchemas, schemaFile, path);
                    continue;
                }
                consumer.anyOf(isName, matchedSchemas, schemaFile, path);
                continue;
            }
            List<Pair<JsonSchemaObject, List<Step>>> variants = definitionsResolver.getVariants();
            for (Pair<JsonSchemaObject, List<Step>> variant : variants) {
                if (((JsonSchemaObject)variant.getFirst()).getDefinitionAddress() == null) continue;
                JsonSchemaWalker.visitSchemaByDefinitionAddress(serviceEx, queue, schemaFile, ((JsonSchemaObject)variant.getFirst()).getDefinitionAddress(), (List)variant.getSecond());
            }
        }
    }

    private static void visitSchemaByDefinitionAddress(JsonSchemaServiceEx serviceEx, ArrayDeque<Trinity<JsonSchemaObject, VirtualFile, List<Step>>> queue, VirtualFile schemaFile, @NotNull String definitionAddress, List<Step> steps) {
        VirtualFile variantSchemaFile;
        if (definitionAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionAddress", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "visitSchemaByDefinitionAddress"));
        }
        JsonSchemaReader.SchemaUrlSplitter splitter = new JsonSchemaReader.SchemaUrlSplitter(definitionAddress);
        VirtualFile virtualFile = variantSchemaFile = splitter.isAbsolute() ? serviceEx.getSchemaFileById(splitter.getSchemaId(), schemaFile) : schemaFile;
        if (variantSchemaFile == null) {
            return;
        }
        serviceEx.visitSchemaObject(variantSchemaFile, (Processor<JsonSchemaObject>)((Processor)variantObject -> {
            List variantSteps = (List)JsonSchemaWalker.buildSteps(splitter.getRelativePath()).getFirst();
            if (variantSteps.isEmpty()) {
                variantSteps = steps;
            } else {
                variantSteps.addAll(steps);
            }
            queue.add(Trinity.create((Object)variantObject, (Object)variantSchemaFile, (Object)variantSteps));
            return true;
        }));
    }

    private static void extractSchemaVariants(@NotNull DefinitionsResolver consumer, @NotNull JsonSchemaObject rootSchema, @NotNull List<Step> position, boolean acceptAdditionalPropertiesSchemas) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        queue.add(Pair.create((Object)rootSchema, (Object)0));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            JsonSchemaObject schema = (JsonSchemaObject)pair.getFirst();
            Integer level = (Integer)pair.getSecond();
            if (position.size() <= level) {
                return;
            }
            Step step = position.get(level);
            if (step.getTransition() == null) {
                consumer.consumeResult(schema);
                continue;
            }
            if (step.getTransition() != null && !StateType._unknown.equals((Object)step.getType()) && !step.getTransition().possibleFromState(step.getType())) continue;
            Condition byTypeFilter = object -> JsonSchemaWalker.byStateType(step.getType(), object);
            boolean isOneOf = schema.getOneOf() != null;
            List list = JsonSchemaWalker.gatherSchemas(schema);
            list = ContainerUtil.filter(list, (Condition)byTypeFilter);
            Consumer reporter = object -> {
                if (position == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "lambda$extractSchemaVariants$5"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "lambda$extractSchemaVariants$5"));
                }
                if (level + 1 >= position.size()) {
                    consumer.setOneOf(isOneOf);
                    consumer.consumeResult((JsonSchemaObject)object);
                } else {
                    consumer.consumeSmallStep((JsonSchemaObject)object, level);
                    queue.add(Pair.create((Object)object, (Object)(level + 1)));
                }
            };
            for (JsonSchemaObject object2 : list) {
                TransitionResultConsumer transitionResultConsumer = new TransitionResultConsumer();
                step.getTransition().step(object2, transitionResultConsumer, acceptAdditionalPropertiesSchemas);
                if (transitionResultConsumer.isNothing() || transitionResultConsumer.getSchema() == null) continue;
                reporter.consume((Object)transitionResultConsumer.getSchema());
            }
        }
    }

    private static List<JsonSchemaObject> gatherSchemas(JsonSchemaObject schema) {
        if (schema.getAllOf() != null) {
            return JsonSchemaWalker.gatherSchemas(JsonSchemaWalker.mergeAll(schema));
        }
        if (schema.getAnyOf() != null) {
            return JsonSchemaWalker.mergeList(schema.getAnyOf(), schema, false);
        }
        if (schema.getOneOf() != null) {
            return JsonSchemaWalker.mergeList(schema.getOneOf(), schema, true);
        }
        return Collections.singletonList(schema);
    }

    @NotNull
    public static JsonSchemaObject mergeAll(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "mergeAll"));
        }
        JsonSchemaObject currentBase = JsonSchemaWalker.copySchema(schema);
        currentBase.setAllOf(null);
        for (JsonSchemaObject object : schema.getAllOf()) {
            currentBase = JsonSchemaWalker.merge(currentBase, object);
        }
        JsonSchemaObject jsonSchemaObject = currentBase;
        if (jsonSchemaObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "mergeAll"));
        }
        return jsonSchemaObject;
    }

    @NotNull
    private static JsonSchemaObject copySchema(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "copySchema"));
        }
        JsonSchemaObject currentBase = new JsonSchemaObject(schema.getPeerPointer());
        currentBase.mergeValues(schema);
        currentBase.setDefinitionsPointer(schema.getDefinitionsPointer());
        JsonSchemaObject jsonSchemaObject = currentBase;
        if (jsonSchemaObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "copySchema"));
        }
        return jsonSchemaObject;
    }

    public static List<JsonSchemaObject> mergeList(@NotNull Collection<JsonSchemaObject> coll, @NotNull JsonSchemaObject schema, boolean oneOf) {
        if (coll == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coll", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "mergeList"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "mergeList"));
        }
        JsonSchemaObject copy = JsonSchemaWalker.copySchema(schema);
        if (oneOf) {
            copy.setOneOf(null);
        } else {
            copy.setAnyOf(null);
        }
        return coll.stream().map(s -> JsonSchemaWalker.merge(copy, s)).collect(Collectors.toList());
    }

    public static JsonSchemaObject merge(@NotNull JsonSchemaObject base, @NotNull JsonSchemaObject other) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "merge"));
        }
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "merge"));
        }
        JsonSchemaObject object = new JsonSchemaObject(base.getPeerPointer());
        object.mergeValues(other);
        object.mergeValues(base);
        object.setDefinitionsPointer(base.getDefinitionsPointer());
        return object;
    }

    private static boolean byStateType(@NotNull StateType type, @NotNull JsonSchemaObject schema) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "byStateType"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "byStateType"));
        }
        if (StateType._unknown.equals((Object)type)) {
            return true;
        }
        JsonSchemaType requiredType = type.getCorrespondingJsonType();
        if (requiredType == null) {
            return true;
        }
        if (schema.getType() != null) {
            return requiredType.equals((Object)schema.getType());
        }
        if (schema.getTypeVariants() != null) {
            for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                if (!requiredType.equals((Object)schemaType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static JsonLikePsiWalker getWalker(@NotNull PsiElement element, JsonSchemaObject schemaObject) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "getWalker"));
        }
        return (JsonLikePsiWalker)JsonSchemaWalker.getJsonLikeThing(element, walker -> walker, schemaObject);
    }

    @Nullable
    private static <T> T getJsonLikeThing(@NotNull PsiElement element, @NotNull Convertor<JsonLikePsiWalker, T> convertor, JsonSchemaObject schemaObject) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "getJsonLikeThing"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "getJsonLikeThing"));
        }
        ArrayList<JsonOriginalPsiWalker> list = new ArrayList<JsonOriginalPsiWalker>();
        list.add(JSON_ORIGINAL_PSI_WALKER);
        JsonLikePsiWalkerFactory[] extensions = (JsonLikePsiWalkerFactory[])Extensions.getExtensions(JsonLikePsiWalkerFactory.EXTENSION_POINT_NAME);
        list.addAll(Arrays.stream(extensions).map(extension -> extension.create(schemaObject)).collect(Collectors.toList()));
        for (JsonLikePsiWalker jsonLikePsiWalker : list) {
            if (!jsonLikePsiWalker.handles(element)) continue;
            return (T)convertor.convert((Object)jsonLikePsiWalker);
        }
        return null;
    }

    private static class TransitionResultConsumer {
        @Nullable
        private JsonSchemaObject mySchema;
        private boolean myAny;
        private boolean myNothing = true;
        private boolean myOneOf;

        @Nullable
        public JsonSchemaObject getSchema() {
            return this.mySchema;
        }

        public void setSchema(@Nullable JsonSchemaObject schema) {
            this.mySchema = schema;
            this.myNothing = schema == null;
        }

        public boolean isAny() {
            return this.myAny;
        }

        public void anything() {
            this.myAny = true;
            this.myNothing = false;
        }

        public boolean isNothing() {
            return this.myNothing;
        }

        public void nothing() {
            this.myNothing = true;
            this.myAny = false;
        }

        public void oneOf() {
            this.myOneOf = true;
        }

        public boolean isOneOf() {
            return this.myOneOf;
        }
    }

    public static enum StateType {
        _object(JsonSchemaType._object),
        _array(JsonSchemaType._array),
        _value(null),
        _unknown(null);

        @Nullable
        private final JsonSchemaType myCorrespondingJsonType;

        private StateType(JsonSchemaType correspondingJsonType) {
            this.myCorrespondingJsonType = correspondingJsonType;
        }

        @Nullable
        public JsonSchemaType getCorrespondingJsonType() {
            return this.myCorrespondingJsonType;
        }
    }

    private static interface Transition {
        public boolean possibleFromState(@NotNull StateType var1);

        public void step(@NotNull JsonSchemaObject var1, @NotNull TransitionResultConsumer var2, boolean var3);
    }

    public static class ArrayTransition
    implements Transition {
        private final int myIdx;

        public ArrayTransition(int idx) {
            this.myIdx = idx;
        }

        @Override
        public boolean possibleFromState(@NotNull StateType stateType) {
            if (stateType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateType", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$ArrayTransition", "possibleFromState"));
            }
            return StateType._array.equals((Object)stateType);
        }

        @Override
        public void step(@NotNull JsonSchemaObject parent, @NotNull TransitionResultConsumer resultConsumer, boolean acceptAdditionalPropertiesSchemas) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$ArrayTransition", "step"));
            }
            if (resultConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultConsumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$ArrayTransition", "step"));
            }
            if (parent.getItemsSchema() != null) {
                resultConsumer.setSchema(parent.getItemsSchema());
            } else if (parent.getItemsSchemaList() != null) {
                List<JsonSchemaObject> list = parent.getItemsSchemaList();
                if (this.myIdx >= 0 && this.myIdx < list.size()) {
                    resultConsumer.setSchema(list.get(this.myIdx));
                } else if (parent.getAdditionalItemsSchema() != null) {
                    resultConsumer.setSchema(parent.getAdditionalItemsSchema());
                } else if (!Boolean.FALSE.equals(parent.getAdditionalItemsAllowed())) {
                    resultConsumer.anything();
                } else {
                    resultConsumer.nothing();
                }
            }
        }
    }

    public static class PropertyTransition
    implements Transition {
        @NotNull
        private final String myName;

        public PropertyTransition(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$PropertyTransition", "<init>"));
            }
            this.myName = name;
        }

        @Override
        public boolean possibleFromState(@NotNull StateType stateType) {
            if (stateType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateType", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$PropertyTransition", "possibleFromState"));
            }
            return StateType._object.equals((Object)stateType);
        }

        @Override
        public void step(@NotNull JsonSchemaObject parent, @NotNull TransitionResultConsumer resultConsumer, boolean acceptAdditionalPropertiesSchemas) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$PropertyTransition", "step"));
            }
            if (resultConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultConsumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$PropertyTransition", "step"));
            }
            if ("definitions".equals(this.myName) && parent.getDefinitions() != null) {
                SmartPsiElementPointer<JsonObject> pointer = parent.getDefinitionsPointer();
                JsonSchemaObject object = new JsonSchemaObject(pointer);
                object.setProperties(parent.getDefinitions());
                resultConsumer.setSchema(object);
                return;
            }
            JsonSchemaObject child = parent.getProperties().get(this.myName);
            if (child != null) {
                resultConsumer.setSchema(child);
            } else {
                JsonSchemaObject schema = parent.getMatchingPatternPropertySchema(this.myName);
                if (schema != null) {
                    resultConsumer.setSchema(schema);
                    return;
                }
                if (parent.getAdditionalPropertiesSchema() != null) {
                    if (acceptAdditionalPropertiesSchemas) {
                        resultConsumer.setSchema(parent.getAdditionalPropertiesSchema());
                    }
                } else if (!Boolean.FALSE.equals(parent.getAdditionalPropertiesAllowed())) {
                    resultConsumer.anything();
                } else {
                    resultConsumer.nothing();
                }
            }
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$PropertyTransition", "getName"));
            }
            return string;
        }
    }

    public static class Step {
        private final StateType myType;
        @Nullable
        private final Transition myTransition;

        public Step(StateType type, @Nullable Transition transition) {
            this.myType = type;
            this.myTransition = transition;
        }

        public StateType getType() {
            return this.myType;
        }

        @Nullable
        public Transition getTransition() {
            return this.myTransition;
        }
    }

    protected static class DefinitionsResolver {
        @NotNull
        private final List<Step> myPosition;
        final List<Pair<JsonSchemaObject, List<Step>>> myVariants;
        private List<JsonSchemaObject> mySchemaObjects;
        private boolean myOneOf;

        public DefinitionsResolver(@NotNull List<Step> position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$DefinitionsResolver", "<init>"));
            }
            this.mySchemaObjects = new ArrayList<JsonSchemaObject>();
            this.myPosition = position;
            this.myVariants = new ArrayList<Pair<JsonSchemaObject, List<Step>>>();
        }

        public void consumeResult(@NotNull JsonSchemaObject schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$DefinitionsResolver", "consumeResult"));
            }
            this.mySchemaObjects.add(schema);
        }

        public void consumeSmallStep(@NotNull JsonSchemaObject schema, int idx) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$DefinitionsResolver", "consumeSmallStep"));
            }
            List list = JsonSchemaWalker.gatherSchemas(schema);
            for (JsonSchemaObject object : list) {
                if (StringUtil.isEmptyOrSpaces((String)object.getDefinitionAddress())) continue;
                this.myVariants.add((Pair<JsonSchemaObject, List<Step>>)Pair.create((Object)object, this.myPosition.subList(idx + 1, this.myPosition.size())));
            }
        }

        public boolean isFound() {
            return !this.mySchemaObjects.isEmpty();
        }

        public List<JsonSchemaObject> getSchemaObjects() {
            return this.mySchemaObjects;
        }

        public boolean isOneOf() {
            return this.myOneOf;
        }

        public List<Pair<JsonSchemaObject, List<Step>>> getVariants() {
            return this.myVariants;
        }

        public void setOneOf(boolean oneOf) {
            this.myOneOf = oneOf;
        }
    }

    public static interface CompletionSchemesConsumer {
        public void consume(boolean var1, @NotNull JsonSchemaObject var2, @NotNull VirtualFile var3, @NotNull List<Step> var4);

        public void oneOf(boolean var1, @NotNull List<JsonSchemaObject> var2, @NotNull VirtualFile var3, @NotNull List<Step> var4);

        public void anyOf(boolean var1, @NotNull List<JsonSchemaObject> var2, @NotNull VirtualFile var3, @NotNull List<Step> var4);
    }
}

