/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonNullLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.PairConsumer;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadJsonSchemaFromPsi {
    private final Set<JsonSchemaObject> myAllObjects = new HashSet<JsonSchemaObject>();
    private final Map<String, JsonSchemaObject> myIds = new HashMap<String, JsonSchemaObject>();
    private final Map<String, PairConsumer<JsonElement, JsonSchemaObject>> myMap = new HashMap<String, PairConsumer<JsonElement, JsonSchemaObject>>();
    private final ArrayDeque<JsonSchemaObject> myQueue;

    public ReadJsonSchemaFromPsi() {
        this.fillMap();
        this.myQueue = new ArrayDeque();
    }

    public JsonSchemaObject read(@NotNull JsonObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "read"));
        }
        JsonSchemaObject root = new JsonSchemaObject(object);
        this.myQueue.add(root);
        while (!this.myQueue.isEmpty()) {
            JsonSchemaObject currentSchema = this.myQueue.removeFirst();
            this.myAllObjects.add(currentSchema);
            JsonObject jsonObject = (JsonObject)currentSchema.getPeerPointer().getElement();
            if (jsonObject == null) continue;
            List<JsonProperty> list = jsonObject.getPropertyList();
            for (JsonProperty property : list) {
                if (StringUtil.isEmptyOrSpaces((String)property.getName()) || property.getValue() == null) continue;
                PairConsumer<JsonElement, JsonSchemaObject> consumer = this.myMap.get(property.getName());
                if (consumer != null) {
                    consumer.consume((Object)property.getValue(), (Object)currentSchema);
                    continue;
                }
                this.readSingleDefinition(property.getName(), property.getValue(), currentSchema);
            }
            if (currentSchema.getId() == null) continue;
            this.myIds.put(currentSchema.getId(), currentSchema);
        }
        return root;
    }

    public Set<JsonSchemaObject> getAllObjects() {
        return this.myAllObjects;
    }

    public Map<String, JsonSchemaObject> getIds() {
        return this.myIds;
    }

    private void readSingleDefinition(@NotNull String name, @NotNull JsonValue value, @NotNull JsonSchemaObject schema) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "readSingleDefinition"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "readSingleDefinition"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "readSingleDefinition"));
        }
        if (value instanceof JsonObject) {
            JsonSchemaObject defined = new JsonSchemaObject((JsonObject)value);
            this.myQueue.add(defined);
            Map<String, JsonSchemaObject> definitions = schema.getDefinitions();
            if (definitions == null) {
                definitions = new HashMap<String, JsonSchemaObject>();
                schema.setDefinitions(definitions);
            }
            definitions.put(name, defined);
        }
    }

    private void fillMap() {
        this.myMap.put("id", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonStringLiteral) {
                object.setId(StringUtil.unquoteString((String)element.getText()));
            }
        }));
        this.myMap.put("$schema", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonStringLiteral) {
                object.setSchema(StringUtil.unquoteString((String)element.getText()));
            }
        }));
        this.myMap.put("description", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonStringLiteral) {
                object.setDescription(StringUtil.unquoteString((String)element.getText()));
            }
        }));
        this.myMap.put("title", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonStringLiteral) {
                object.setTitle(StringUtil.unquoteString((String)element.getText()));
            }
        }));
        this.myMap.put("$ref", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonStringLiteral) {
                object.setRef(StringUtil.unquoteString((String)element.getText()));
            }
        }));
        this.myMap.put("default", this.createDefault());
        this.myMap.put("format", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonStringLiteral) {
                object.setFormat(StringUtil.unquoteString((String)element.getText()));
            }
        }));
        this.myMap.put("definitions", this.createDefinitionsConsumer());
        this.myMap.put("properties", this.createPropertiesConsumer());
        this.myMap.put("multipleOf", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMultipleOf(((JsonNumberLiteral)element).getValue());
            }
        }));
        this.myMap.put("maximum", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaximum(((JsonNumberLiteral)element).getValue());
            }
        }));
        this.myMap.put("minimum", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinimum(((JsonNumberLiteral)element).getValue());
            }
        }));
        this.myMap.put("exclusiveMaximum", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setExclusiveMaximum(((JsonBooleanLiteral)element).getValue());
            }
        }));
        this.myMap.put("exclusiveMinimum", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setExclusiveMinimum(((JsonBooleanLiteral)element).getValue());
            }
        }));
        this.myMap.put("maxLength", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaxLength((int)((JsonNumberLiteral)element).getValue());
            }
        }));
        this.myMap.put("minLength", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinLength((int)((JsonNumberLiteral)element).getValue());
            }
        }));
        this.myMap.put("pattern", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonStringLiteral) {
                object.setPattern(StringUtil.unquoteString((String)element.getText()));
            }
        }));
        this.myMap.put("additionalItems", this.createAdditionalItems());
        this.myMap.put("items", this.createItems());
        this.myMap.put("maxItems", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaxItems((int)((JsonNumberLiteral)element).getValue());
            }
        }));
        this.myMap.put("minItems", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinItems((int)((JsonNumberLiteral)element).getValue());
            }
        }));
        this.myMap.put("uniqueItems", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setUniqueItems(((JsonBooleanLiteral)element).getValue());
            }
        }));
        this.myMap.put("maxProperties", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaxProperties((int)((JsonNumberLiteral)element).getValue());
            }
        }));
        this.myMap.put("minProperties", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinProperties((int)((JsonNumberLiteral)element).getValue());
            }
        }));
        this.myMap.put("required", ReadJsonSchemaFromPsi.createRequired());
        this.myMap.put("additionalProperties", this.createAdditionalProperties());
        this.myMap.put("patternProperties", this.createPatternProperties());
        this.myMap.put("dependencies", this.createDependencies());
        this.myMap.put("enum", ReadJsonSchemaFromPsi.createEnum());
        this.myMap.put("type", ReadJsonSchemaFromPsi.createType());
        this.myMap.put("allOf", this.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setAllOf((List<JsonSchemaObject>)members))));
        this.myMap.put("anyOf", this.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setAnyOf((List<JsonSchemaObject>)members))));
        this.myMap.put("oneOf", this.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setOneOf((List<JsonSchemaObject>)members))));
        this.myMap.put("not", this.createNot());
        this.myMap.put("instanceof", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> object.shouldValidateAgainstJSType()));
        this.myMap.put("typeof", (PairConsumer<JsonElement, JsonSchemaObject>)((PairConsumer)(element, object) -> object.shouldValidateAgainstJSType()));
    }

    private PairConsumer<JsonElement, JsonSchemaObject> createNot() {
        return (element, object) -> {
            if (element instanceof JsonObject) {
                JsonSchemaObject not = new JsonSchemaObject((JsonObject)element);
                this.myQueue.add(not);
                object.setNot(not);
            }
        };
    }

    private PairConsumer<JsonElement, JsonSchemaObject> createContainer(@NotNull PairConsumer<JsonSchemaObject, List<JsonSchemaObject>> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "createContainer"));
        }
        return (element, object) -> {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "lambda$createContainer$27"));
            }
            if (element instanceof JsonArray) {
                List<JsonValue> list = ((JsonArray)element).getValueList();
                List members = list.stream().filter(el -> el instanceof JsonObject).map(el -> {
                    JsonSchemaObject child = new JsonSchemaObject((JsonObject)el);
                    this.myQueue.add(child);
                    return child;
                }).collect(Collectors.toList());
                delegate.consume(object, members);
            }
        };
    }

    private static PairConsumer<JsonElement, JsonSchemaObject> createType() {
        return (element, object) -> {
            List<JsonSchemaType> typeList;
            if (element instanceof JsonStringLiteral) {
                JsonSchemaType type = ReadJsonSchemaFromPsi.parseType(StringUtil.unquoteString((String)element.getText()));
                if (type != null) {
                    object.setType(type);
                }
            } else if (element instanceof JsonArray && !(typeList = ((JsonArray)element).getValueList().stream().filter(ReadJsonSchemaFromPsi.notEmptyString()).map(el -> ReadJsonSchemaFromPsi.parseType(StringUtil.unquoteString((String)el.getText()))).filter(el -> el != null).collect(Collectors.toList())).isEmpty()) {
                object.setTypeVariants(typeList);
            }
        };
    }

    @Nullable
    private static JsonSchemaType parseType(@NotNull String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "parseType"));
        }
        try {
            return JsonSchemaType.valueOf("_" + typeString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static PairConsumer<JsonElement, JsonSchemaObject> createEnum() {
        return (element, object) -> {
            if (element instanceof JsonArray) {
                ArrayList<Object> objects = new ArrayList<Object>();
                List<JsonValue> list = ((JsonArray)element).getValueList();
                for (JsonValue value : list) {
                    if (value instanceof JsonStringLiteral) {
                        objects.add("\"" + StringUtil.unquoteString((String)((JsonStringLiteral)value).getValue()) + "\"");
                        continue;
                    }
                    if (value instanceof JsonNumberLiteral) {
                        objects.add(ReadJsonSchemaFromPsi.getNumber((JsonNumberLiteral)value));
                        continue;
                    }
                    if (value instanceof JsonBooleanLiteral) {
                        objects.add(((JsonBooleanLiteral)value).getValue());
                        continue;
                    }
                    if (!(value instanceof JsonNullLiteral)) continue;
                    objects.add("null");
                }
                object.setEnum(objects);
            }
        };
    }

    @NotNull
    private static Number getNumber(@NotNull JsonNumberLiteral value) {
        Number numberValue;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "getNumber"));
        }
        try {
            numberValue = Integer.parseInt(value.getText());
        }
        catch (NumberFormatException e) {
            numberValue = value.getValue();
        }
        Number number = numberValue;
        if (number == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "getNumber"));
        }
        return number;
    }

    private PairConsumer<JsonElement, JsonSchemaObject> createDependencies() {
        return (element, object) -> {
            if (element instanceof JsonObject) {
                HashMap<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();
                HashMap<String, JsonSchemaObject> schemaDependencies = new HashMap<String, JsonSchemaObject>();
                List<JsonProperty> list = ((JsonObject)element).getPropertyList();
                for (JsonProperty property : list) {
                    if (StringUtil.isEmptyOrSpaces((String)property.getName()) || property.getValue() == null) continue;
                    if (property.getValue() instanceof JsonArray) {
                        List dependencies = ((JsonArray)property.getValue()).getValueList().stream().filter(ReadJsonSchemaFromPsi.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getText())).collect(Collectors.toList());
                        if (dependencies.isEmpty()) continue;
                        propertyDependencies.put(property.getName(), dependencies);
                        continue;
                    }
                    if (!(property.getValue() instanceof JsonObject)) continue;
                    JsonSchemaObject child = new JsonSchemaObject((JsonObject)property.getValue());
                    this.myQueue.add(child);
                    schemaDependencies.put(property.getName(), child);
                }
                object.setPropertyDependencies(propertyDependencies);
                object.setSchemaDependencies(schemaDependencies);
            }
        };
    }

    @NotNull
    private static Predicate<JsonValue> notEmptyString() {
        Predicate<JsonValue> predicate = el -> el instanceof JsonStringLiteral && !StringUtil.isEmptyOrSpaces((String)el.getText());
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "notEmptyString"));
        }
        return predicate;
    }

    private PairConsumer<JsonElement, JsonSchemaObject> createPatternProperties() {
        return (element, object) -> {
            if (element instanceof JsonObject) {
                object.setPatternProperties(this.readInnerObject((JsonObject)element));
            }
        };
    }

    private PairConsumer<JsonElement, JsonSchemaObject> createAdditionalProperties() {
        return (element, object) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setAdditionalPropertiesAllowed(((JsonBooleanLiteral)element).getValue());
            } else if (element instanceof JsonObject) {
                JsonSchemaObject schema = new JsonSchemaObject((JsonObject)element);
                this.myQueue.add(schema);
                object.setAdditionalPropertiesSchema(schema);
            }
        };
    }

    private static PairConsumer<JsonElement, JsonSchemaObject> createRequired() {
        return (element, object) -> {
            if (element instanceof JsonArray) {
                object.setRequired(((JsonArray)element).getValueList().stream().filter(ReadJsonSchemaFromPsi.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getText())).collect(Collectors.toList()));
            }
        };
    }

    private PairConsumer<JsonElement, JsonSchemaObject> createItems() {
        return (element, object) -> {
            if (element instanceof JsonObject) {
                JsonSchemaObject schema = new JsonSchemaObject((JsonObject)element);
                this.myQueue.add(schema);
                object.setItemsSchema(schema);
            } else if (element instanceof JsonArray) {
                ArrayList<JsonSchemaObject> list = new ArrayList<JsonSchemaObject>();
                List<JsonValue> values = ((JsonArray)element).getValueList();
                for (JsonValue value : values) {
                    if (!(value instanceof JsonObject)) continue;
                    JsonSchemaObject child = new JsonSchemaObject((JsonObject)value);
                    this.myQueue.add(child);
                    list.add(child);
                }
                object.setItemsSchemaList(list);
            }
        };
    }

    private PairConsumer<JsonElement, JsonSchemaObject> createAdditionalItems() {
        return (element, object) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setAdditionalItemsAllowed(((JsonBooleanLiteral)element).getValue());
            } else if (element instanceof JsonObject) {
                JsonSchemaObject additionalItemsSchema = new JsonSchemaObject((JsonObject)element);
                this.myQueue.add(additionalItemsSchema);
                object.setAdditionalItemsSchema(additionalItemsSchema);
            }
        };
    }

    private PairConsumer<JsonElement, JsonSchemaObject> createPropertiesConsumer() {
        return (element, object) -> {
            if (element instanceof JsonObject) {
                object.setProperties(this.readInnerObject((JsonObject)element));
            }
        };
    }

    private PairConsumer<JsonElement, JsonSchemaObject> createDefinitionsConsumer() {
        return (element, object) -> {
            if (element instanceof JsonObject) {
                object.setDefinitions(this.readInnerObject((JsonObject)element));
                object.setDefinitionsPointer((SmartPsiElementPointer<JsonObject>)SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer((PsiElement)((JsonObject)element)));
            }
        };
    }

    @NotNull
    private Map<String, JsonSchemaObject> readInnerObject(JsonObject element) {
        List<JsonProperty> properties = element.getPropertyList();
        HashMap<String, JsonSchemaObject> map = new HashMap<String, JsonSchemaObject>();
        for (JsonProperty property : properties) {
            if (StringUtil.isEmptyOrSpaces((String)property.getName()) || !(property.getValue() instanceof JsonObject)) continue;
            JsonSchemaObject child = new JsonSchemaObject((JsonObject)property.getValue());
            this.myQueue.add(child);
            map.put(property.getName(), child);
        }
        HashMap<String, JsonSchemaObject> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/ReadJsonSchemaFromPsi", "readInnerObject"));
        }
        return hashMap;
    }

    private PairConsumer<JsonElement, JsonSchemaObject> createDefault() {
        return (element, object) -> {
            if (element instanceof JsonObject) {
                JsonSchemaObject schemaObject = new JsonSchemaObject((JsonObject)element);
                this.myQueue.add(schemaObject);
                object.setDefault(schemaObject);
            } else if (element instanceof JsonStringLiteral) {
                object.setDefault(StringUtil.unquoteString((String)((JsonStringLiteral)element).getValue()));
            } else if (element instanceof JsonNumberLiteral) {
                object.setDefault(ReadJsonSchemaFromPsi.getNumber((JsonNumberLiteral)element));
            } else if (element instanceof JsonBooleanLiteral) {
                object.setDefault(((JsonBooleanLiteral)element).getValue());
            }
        };
    }
}

