/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MagicNumberInspectionBase
extends BaseInspection {
    public boolean ignoreInHashCode = true;
    public boolean ignoreInTestCode = false;
    public boolean ignoreInAnnotations = true;
    public boolean ignoreInitialCapacity = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("magic.number.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/MagicNumberInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("magic.number.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/MagicNumberInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.in.hashcode", new Object[0]), "ignoreInHashCode");
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.in.annotations", new Object[0]), "ignoreInAnnotations");
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.as.initial.capacity", new Object[0]), "ignoreInitialCapacity");
        return panel2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MagicNumberVisitor();
    }

    private class MagicNumberVisitor
    extends BaseInspectionVisitor {
        private MagicNumberVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            boolean insideAnnotation;
            PsiMethod containingMethod;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/abstraction/MagicNumberInspectionBase$MagicNumberVisitor", "visitLiteralExpression"));
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (!ClassUtils.isPrimitiveNumericType(type) || PsiType.CHAR.equals((Object)type)) {
                return;
            }
            if (this.isSpecialCaseLiteral(expression) || this.isFinalVariableInitialization((PsiExpression)expression)) {
                return;
            }
            if (MagicNumberInspectionBase.this.ignoreInHashCode && MethodUtils.isHashCode(containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                return;
            }
            if (MagicNumberInspectionBase.this.ignoreInAnnotations && (insideAnnotation = AnnotationUtil.isInsideAnnotation((PsiElement)expression))) {
                return;
            }
            if (MagicNumberInspectionBase.this.ignoreInitialCapacity && this.isInitialCapacity(expression)) {
                return;
            }
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class);
            if (field != null && PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiPrefixExpression) {
                this.registerError(parent, parent);
            } else {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private boolean isInitialCapacity(PsiLiteralExpression expression) {
            PsiElement element = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{PsiTypeCastExpression.class, PsiParenthesizedExpression.class});
            if (!(element instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                return false;
            }
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            return TypeUtils.expressionHasTypeOrSubtype((PsiExpression)newExpression, "java.lang.AbstractStringBuilder", "java.util.Map", "java.util.Collection", "java.io.ByteArrayOutputStream", "java.awt.Dimension") != null;
        }

        private boolean isSpecialCaseLiteral(PsiLiteralExpression expression) {
            Object object = ExpressionUtils.computeConstantExpression((PsiExpression)expression);
            if (object instanceof Integer) {
                int i2 = (Integer)object;
                return i2 >= 0 && i2 <= 10 || i2 == 100 || i2 == 1000;
            }
            if (object instanceof Long) {
                long l = (Long)object;
                return l >= 0L && l <= 2L;
            }
            if (object instanceof Double) {
                double d = (Double)object;
                return d == 1.0 || d == 0.0;
            }
            if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                return f == 1.0f || f == 0.0f;
            }
            return false;
        }

        public boolean isFinalVariableInitialization(PsiExpression expression) {
            PsiVariable variable;
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiVariable.class, PsiAssignmentExpression.class});
            if (!(parent instanceof PsiVariable)) {
                if (!(parent instanceof PsiAssignmentExpression)) {
                    return false;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return false;
                }
                variable = (PsiVariable)target;
            } else {
                variable = (PsiVariable)parent;
            }
            return variable.hasModifierProperty("final");
        }
    }
}

