/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodOnlyUsedFromInnerClassInspection
extends BaseInspection {
    public boolean ignoreMethodsAccessedFromAnonymousClass = false;
    public boolean ignoreStaticMethodsFromNonStaticInnerClass = false;
    public boolean onlyReportStaticMethods = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiNamedElement element = (PsiNamedElement)infos[0];
        String name = element.getName();
        if (infos.length > 1) {
            if (Boolean.TRUE.equals(infos[1])) {
                String string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.problem.descriptor.anonymous.extending", name);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection", "buildErrorString"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.problem.descriptor.anonymous.implementing", name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.problem.descriptor", name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("method.only.used.from.inner.class.ignore.option", new Object[0]), "ignoreMethodsAccessedFromAnonymousClass");
        panel2.addCheckbox(InspectionGadgetsBundle.message("ignore.static.methods.accessed.from.a.non.static.inner.class", new Object[0]), "ignoreStaticMethodsFromNonStaticInnerClass");
        panel2.addCheckbox(InspectionGadgetsBundle.message("only.report.static.methods", new Object[0]), "onlyReportStaticMethods");
        return panel2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOnlyUsedFromInnerClassVisitor();
    }

    private class MethodReferenceFinder
    implements Processor<PsiReference> {
        private final PsiClass methodClass;
        private final PsiMethod method;
        private boolean onlyAccessedFromInnerClass;
        private PsiClass cache;

        MethodReferenceFinder(PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection$MethodReferenceFinder", "<init>"));
            }
            this.onlyAccessedFromInnerClass = false;
            this.cache = null;
            this.method = method2;
            this.methodClass = method2.getContainingClass();
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (this.method.equals(containingMethod)) {
                return true;
            }
            PsiClass containingClass = ClassUtils.getContainingClass(element);
            if (containingClass == null) {
                this.onlyAccessedFromInnerClass = false;
                return false;
            }
            if (containingClass instanceof PsiAnonymousClass) {
                PsiAnonymousClass anonymousClass = (PsiAnonymousClass)containingClass;
                PsiExpressionList argumentList = anonymousClass.getArgumentList();
                if (PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)element, (boolean)true)) {
                    this.onlyAccessedFromInnerClass = false;
                    return false;
                }
                if (MethodOnlyUsedFromInnerClassInspection.this.ignoreMethodsAccessedFromAnonymousClass) {
                    this.onlyAccessedFromInnerClass = false;
                    return false;
                }
            }
            if (this.cache != null) {
                if (!this.cache.equals(containingClass)) {
                    this.onlyAccessedFromInnerClass = false;
                    return false;
                }
            } else if (!PsiTreeUtil.isAncestor((PsiElement)this.methodClass, (PsiElement)containingClass, (boolean)true)) {
                this.onlyAccessedFromInnerClass = false;
                return false;
            }
            this.onlyAccessedFromInnerClass = true;
            this.cache = containingClass;
            return true;
        }

        public boolean isOnlyAccessedFromInnerClass() {
            if (DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)this.method, true)) {
                return false;
            }
            ReferencesSearch.search((PsiElement)this.method).forEach((Processor)this);
            return this.onlyAccessedFromInnerClass;
        }

        public PsiClass getContainingClass() {
            return this.cache;
        }
    }

    private class MethodOnlyUsedFromInnerClassVisitor
    extends BaseInspectionVisitor {
        private MethodOnlyUsedFromInnerClassVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            PsiElement parent;
            super.visitMethod(method2);
            if (!method2.hasModifierProperty("private") || method2.isConstructor()) {
                return;
            }
            if (MethodOnlyUsedFromInnerClassInspection.this.onlyReportStaticMethods && !method2.hasModifierProperty("static")) {
                return;
            }
            if (method2.getNameIdentifier() == null) {
                return;
            }
            MethodReferenceFinder processor2 = new MethodReferenceFinder(method2);
            if (!processor2.isOnlyAccessedFromInnerClass()) {
                return;
            }
            PsiClass containingClass = processor2.getContainingClass();
            if (MethodOnlyUsedFromInnerClassInspection.this.ignoreStaticMethodsFromNonStaticInnerClass && method2.hasModifierProperty("static") && (parent = containingClass.getParent()) instanceof PsiClass && !containingClass.hasModifierProperty("static")) {
                return;
            }
            if (containingClass instanceof PsiAnonymousClass) {
                PsiClass[] interfaces = containingClass.getInterfaces();
                if (interfaces.length == 1) {
                    PsiClass superClass = interfaces[0];
                    this.registerMethodError(method2, superClass, false);
                } else {
                    PsiClass superClass = containingClass.getSuperClass();
                    if (superClass == null) {
                        return;
                    }
                    this.registerMethodError(method2, superClass, true);
                }
            } else {
                this.registerMethodError(method2, containingClass);
            }
        }
    }
}

