/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.abstraction.StaticMethodOnlyUsedInOneClassInspectionBase;
import com.siyeh.ig.fixes.RefactoringInspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticMethodOnlyUsedInOneClassInspection
extends StaticMethodOnlyUsedInOneClassInspectionBase {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass usageClass = (PsiClass)infos[0];
        return new StaticMethodOnlyUsedInOneClassFix(usageClass);
    }

    private static class StaticMethodOnlyUsedInOneClassFix
    extends RefactoringInspectionGadgetsFix {
        private final SmartPsiElementPointer<PsiClass> usageClass;

        public StaticMethodOnlyUsedInOneClassFix(PsiClass usageClass) {
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)usageClass.getProject());
            this.usageClass = pointerManager.createSmartPsiElementPointer((PsiElement)usageClass);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$StaticMethodOnlyUsedInOneClassFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public RefactoringActionHandler getHandler() {
            RefactoringActionHandler refactoringActionHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
            if (refactoringActionHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$StaticMethodOnlyUsedInOneClassFix", "getHandler"));
            }
            return refactoringActionHandler;
        }

        @NotNull
        public DataContext enhanceDataContext(DataContext context) {
            DataContext dataContext = SimpleDataContext.getSimpleContext(LangDataKeys.TARGET_PSI_ELEMENT.getName(), this.usageClass.getElement(), context);
            if (dataContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$StaticMethodOnlyUsedInOneClassFix", "enhanceDataContext"));
            }
            return dataContext;
        }
    }
}

