/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.asserttoif;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfCanBeAssertionInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("if.can.be.assertion.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/asserttoif/IfCanBeAssertionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/asserttoif/IfCanBeAssertionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfToAssertionVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IfToAssertionFix();
    }

    private static void doFixImpl(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/asserttoif/IfCanBeAssertionInspection", "doFixImpl"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        PsiExpression condition = ifStatement.getCondition();
        StringBuilder newStatementText = new StringBuilder("assert ");
        newStatementText.append(BoolUtils.getNegatedExpressionText(condition));
        PsiNewExpression newException = IfCanBeAssertionInspection.getThrownNewException(ifStatement);
        String message = IfCanBeAssertionInspection.getExceptionMessage(newException);
        if (message != null) {
            newStatementText.append(':').append(message);
        }
        newStatementText.append(';');
        PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, newStatementText.toString());
    }

    private static String getExceptionMessage(PsiNewExpression newExpression) {
        PsiExpression[] arguments;
        PsiExpressionList argumentList;
        if (newExpression != null && (argumentList = newExpression.getArgumentList()) != null && (arguments = argumentList.getExpressions()).length >= 1) {
            return arguments[0].getText();
        }
        return null;
    }

    private static PsiNewExpression getThrownNewException(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() == null) {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            return IfCanBeAssertionInspection.getThrownNewExceptionImpl((PsiElement)thenBranch);
        }
        return null;
    }

    private static PsiNewExpression getThrownNewExceptionImpl(PsiElement element) {
        PsiThrowStatement throwStatement;
        PsiExpression exception;
        if (element instanceof PsiBlockStatement) {
            PsiStatement[] statements = ((PsiBlockStatement)element).getCodeBlock().getStatements();
            if (statements.length == 1) {
                return IfCanBeAssertionInspection.getThrownNewExceptionImpl((PsiElement)statements[0]);
            }
        } else if (element instanceof PsiThrowStatement && (exception = ParenthesesUtils.stripParentheses((throwStatement = (PsiThrowStatement)element).getException())) instanceof PsiNewExpression) {
            return (PsiNewExpression)exception;
        }
        return null;
    }

    private static class IfToAssertionFix
    extends InspectionGadgetsFix {
        private IfToAssertionFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("if.can.be.assertion.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/asserttoif/IfCanBeAssertionInspection$IfToAssertionFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            IfCanBeAssertionInspection.doFixImpl(descriptor.getPsiElement());
        }
    }

    private static class IfToAssertionVisitor
    extends BaseInspectionVisitor {
        private IfToAssertionVisitor() {
        }

        public void visitKeyword(PsiKeyword keyword) {
            PsiElement parent;
            super.visitKeyword(keyword);
            if (keyword.getTokenType() == JavaTokenType.IF_KEYWORD && (parent = keyword.getParent()) instanceof PsiIfStatement && IfCanBeAssertionInspection.getThrownNewException((PsiIfStatement)parent) != null) {
                this.registerError((PsiElement)keyword, new Object[0]);
            }
        }
    }
}

