/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayObjectsEqualsInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("array.objects.equals.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ArrayObjectsEqualsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean deep = (Boolean)infos[0];
        String string = deep ? InspectionGadgetsBundle.message("array.objects.deep.equals.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("array.objects.equals.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ArrayObjectsEqualsInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean deep = (Boolean)infos[0];
        return new ArrayObjectsEqualsFix(deep);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayObjectsEqualsVisitor();
    }

    private static class ArrayObjectsEqualsVisitor
    extends BaseInspectionVisitor {
        private ArrayObjectsEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ArrayObjectsEqualsInspection$ArrayObjectsEqualsVisitor", "visitMethodCallExpression"));
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 2) {
                return;
            }
            PsiExpression argument1 = expressions[0];
            PsiType type1 = argument1.getType();
            if (!(type1 instanceof PsiArrayType)) {
                return;
            }
            PsiExpression argument2 = expressions[1];
            PsiType type2 = argument2.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            int dimensions = type1.getArrayDimensions();
            if (dimensions != type2.getArrayDimensions()) {
                return;
            }
            PsiMethod method2 = expression.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null || !"java.util.Objects".equals(containingClass.getQualifiedName())) {
                return;
            }
            this.registerMethodCallError(expression, dimensions > 1);
        }
    }

    private static class ArrayObjectsEqualsFix
    extends InspectionGadgetsFix {
        private final boolean myDeep;

        public ArrayObjectsEqualsFix(boolean deep) {
            this.myDeep = deep;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myDeep ? InspectionGadgetsBundle.message("replace.with.arrays.deep.equals", new Object[0]) : InspectionGadgetsBundle.message("replace.with.arrays.equals", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ArrayObjectsEqualsInspection$ArrayObjectsEqualsFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.with.arrays.equals", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ArrayObjectsEqualsInspection$ArrayObjectsEqualsFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent().getParent();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            StringBuilder newExpression = new StringBuilder("java.util.Arrays.");
            if (this.myDeep) {
                newExpression.append("deepEquals");
            } else {
                newExpression.append("equals");
            }
            newExpression.append(methodCallExpression.getArgumentList().getText());
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, newExpression.toString());
        }
    }
}

