/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodMatcher;
import java.util.Collections;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreResultOfCallInspectionBase
extends BaseInspection {
    public boolean m_reportAllNonLibraryCalls = false;
    protected final MethodMatcher myMethodMatcher = new MethodMatcher(true, "callCheckString").add("java.io.File", ".*").add("java.io.InputStream", "read|skip|available|markSupported").add("java.io.Reader", "read|skip|ready|markSupported").add("java.lang.Boolean", ".*").add("java.lang.Byte", ".*").add("java.lang.Character", ".*").add("java.lang.Double", ".*").add("java.lang.Float", ".*").add("java.lang.Integer", ".*").add("java.lang.Long", ".*").add("java.lang.Math", ".*").add("java.lang.Object", "equals|hashCode|toString").add("java.lang.Short", ".*").add("java.lang.StrictMath", ".*").add("java.lang.String", ".*").add("java.math.BigInteger", ".*").add("java.math.BigDecimal", ".*").add("java.net.InetAddress", ".*").add("java.net.URI", ".*").add("java.util.UUID", ".*").add("java.util.regex.Matcher", "pattern|toMatchResult|start|end|group|groupCount|matches|find|lookingAt|quoteReplacement|replaceAll|replaceFirst|regionStart|regionEnd|hasTransparantBounds|hasAnchoringBounds|hitEnd|requireEnd").add("java.util.regex.Pattern", ".*").add("java.util.stream.BaseStream", ".*").finishDefault();

    @NotNull
    public String getID() {
        if ("ResultOfMethodCallIgnored" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "getID"));
        }
        return "ResultOfMethodCallIgnored";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass containingClass = (PsiClass)infos[0];
        String className = containingClass.getName();
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.problem.descriptor", className);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "writeSettings"));
        }
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IgnoreResultOfCallVisitor();
    }

    private class IgnoreResultOfCallVisitor
    extends BaseInspectionVisitor {
        private IgnoreResultOfCallVisitor() {
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            PsiElement resolve2;
            if (PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression)) && (resolve2 = expression.resolve()) instanceof PsiMethod) {
                this.visitCalledExpression((PsiExpression)expression, (PsiMethod)resolve2, null);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiLambdaExpression && PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)parent)))) {
                PsiMethod method2 = expression.resolveMethod();
                if (method2 == null || method2.isConstructor()) {
                    return;
                }
                this.visitCalledExpression((PsiExpression)expression, method2, parent);
            }
        }

        private void visitCalledExpression(PsiExpression call, PsiMethod method2, @Nullable PsiElement errorContainer) {
            PsiElement owner;
            PsiType returnType = method2.getReturnType();
            if (PsiType.VOID.equals((Object)returnType)) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (errorContainer != null && PsiUtilCore.hasErrorElementChild((PsiElement)errorContainer)) {
                return;
            }
            if (PropertyUtil.isSimpleGetter((PsiMethod)method2)) {
                this.registerMethodCallOrRefError(call, aClass);
                return;
            }
            if (IgnoreResultOfCallInspectionBase.this.m_reportAllNonLibraryCalls && !LibraryUtil.classIsInLibrary(aClass)) {
                this.registerMethodCallOrRefError(call, aClass);
                return;
            }
            PsiAnnotation anno = ControlFlowAnalyzer.findContractAnnotation(method2);
            boolean honorInferred = Registry.is((String)"ide.ignore.call.result.inspection.honor.inferred.pure");
            if (anno != null && (honorInferred || !AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno)) && Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)anno, (String)"pure"))) {
                this.registerMethodCallOrRefError(call, aClass);
                return;
            }
            PsiAnnotation annotation = this.findAnnotationInTree((PsiElement)method2, null, Collections.singleton("javax.annotation.CheckReturnValue"));
            if (annotation != null && this.findAnnotationInTree((PsiElement)method2, owner = (PsiElement)annotation.getOwner(), Collections.singleton("com.google.errorprone.annotations.CanIgnoreReturnValue")) != null) {
                return;
            }
            if (!IgnoreResultOfCallInspectionBase.this.myMethodMatcher.matches(method2) && annotation == null) {
                return;
            }
            this.registerMethodCallOrRefError(call, aClass);
        }

        private void registerMethodCallOrRefError(PsiExpression call, PsiClass aClass) {
            if (call instanceof PsiMethodCallExpression) {
                this.registerMethodCallError((PsiMethodCallExpression)call, aClass);
            } else if (call instanceof PsiMethodReferenceExpression) {
                this.registerError((PsiElement)ObjectUtils.notNull((Object)((PsiMethodReferenceExpression)call).getReferenceNameElement(), (Object)call), aClass);
            }
        }

        @Nullable
        private PsiAnnotation findAnnotationInTree(PsiElement element, @Nullable PsiElement stop2, @NotNull Set<String> fqAnnotationNames) {
            if (fqAnnotationNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqAnnotationNames", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase$IgnoreResultOfCallVisitor", "findAnnotationInTree"));
            }
            while (element != null) {
                PsiModifierListOwner modifierListOwner;
                PsiAnnotation annotation;
                if (element == stop2) {
                    return null;
                }
                if (element instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)(modifierListOwner = (PsiModifierListOwner)element), fqAnnotationNames)) != null) {
                    return annotation;
                }
                if (element instanceof PsiClassOwner) {
                    PsiClassOwner classOwner = (PsiClassOwner)element;
                    String packageName = classOwner.getPackageName();
                    PsiPackage aPackage = JavaPsiFacade.getInstance((Project)element.getProject()).findPackage(packageName);
                    if (aPackage == null) {
                        return null;
                    }
                    return AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, fqAnnotationNames);
                }
                element = element.getContext();
            }
            return null;
        }
    }
}

