/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class ProtectedMemberInFinalClassInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("protected.member.in.final.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("protected.member.in.final.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProtectedMemberInFinalClassVisitor();
    }

    private static class ProtectedMemberInFinalClassVisitor
    extends BaseInspectionVisitor {
        private ProtectedMemberInFinalClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspectionBase$ProtectedMemberInFinalClassVisitor", "visitMethod"));
            }
            if (!method2.hasModifierProperty("protected")) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null || !containingClass.hasModifierProperty("final")) {
                return;
            }
            if (MethodUtils.hasSuper(method2)) {
                return;
            }
            this.registerModifierError("protected", (PsiModifierListOwner)method2, "protected");
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspectionBase$ProtectedMemberInFinalClassVisitor", "visitField"));
            }
            if (!field.hasModifierProperty("protected")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || !containingClass.hasModifierProperty("final")) {
                return;
            }
            this.registerModifierError("protected", (PsiModifierListOwner)field, "protected");
        }
    }
}

