/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.classlayout.PublicConstructorInspectionBase;
import com.siyeh.ig.fixes.RefactoringInspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicConstructorInspection
extends PublicConstructorInspectionBase {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceConstructorWithFactoryMethodFix();
    }

    private static class ReplaceConstructorWithFactoryMethodFix
    extends RefactoringInspectionGadgetsFix {
        private ReplaceConstructorWithFactoryMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("public.constructor.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/PublicConstructorInspection$ReplaceConstructorWithFactoryMethodFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public RefactoringActionHandler getHandler() {
            RefactoringActionHandler refactoringActionHandler = JavaRefactoringActionHandlerFactory.getInstance().createReplaceConstructorWithFactoryHandler();
            if (refactoringActionHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/PublicConstructorInspection$ReplaceConstructorWithFactoryMethodFix", "getHandler"));
            }
            return refactoringActionHandler;
        }
    }
}

