/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessBooleanExpressionInspection
extends BaseInspection {
    private static final Set<IElementType> booleanTokens = new HashSet<IElementType>();
    public boolean m_ignoreExpressionsContainingConstants = true;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        String string = InspectionGadgetsBundle.message("boolean.expression.can.be.simplified.problem.descriptor", this.buildSimplifiedExpression(expression, new StringBuilder()).toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    private StringBuilder buildSimplifiedExpression(@Nullable PsiExpression expression, StringBuilder out) {
        if (expression instanceof PsiPolyadicExpression) {
            this.buildSimplifiedPolyadicExpression((PsiPolyadicExpression)expression, out);
        } else if (expression instanceof PsiPrefixExpression) {
            this.buildSimplifiedPrefixExpression((PsiPrefixExpression)expression, out);
        } else if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            PsiExpression expression1 = parenthesizedExpression.getExpression();
            out.append('(');
            this.buildSimplifiedExpression(expression1, out);
            out.append(')');
        } else if (expression != null) {
            out.append(expression.getText());
        }
        return out;
    }

    private void buildSimplifiedPolyadicExpression(PsiPolyadicExpression expression, StringBuilder out) {
        IElementType tokenType = expression.getOperationTokenType();
        PsiExpression[] operands = expression.getOperands();
        ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
        if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.AND)) {
            for (PsiExpression operand : operands) {
                if (this.evaluate(operand) == Boolean.TRUE) continue;
                if (this.evaluate(operand) == Boolean.FALSE) {
                    out.append("false");
                    return;
                }
                expressions.add(operand);
            }
            if (expressions.isEmpty()) {
                out.append("true");
                return;
            }
            this.buildSimplifiedExpression(expressions, tokenType.equals(JavaTokenType.ANDAND) ? "&&" : "&", false, out);
        } else if (tokenType.equals(JavaTokenType.OROR) || tokenType.equals(JavaTokenType.OR)) {
            for (PsiExpression operand : operands) {
                if (this.evaluate(operand) == Boolean.FALSE) continue;
                if (this.evaluate(operand) == Boolean.TRUE) {
                    out.append("true");
                    return;
                }
                expressions.add(operand);
            }
            if (expressions.isEmpty()) {
                out.append("false");
                return;
            }
            this.buildSimplifiedExpression(expressions, tokenType.equals(JavaTokenType.OROR) ? "||" : "|", false, out);
        } else if (tokenType.equals(JavaTokenType.XOR) || tokenType.equals(JavaTokenType.NE)) {
            boolean negate = false;
            for (PsiExpression operand : operands) {
                if (this.evaluate(operand) == Boolean.FALSE) continue;
                if (this.evaluate(operand) == Boolean.TRUE) {
                    negate = !negate;
                    continue;
                }
                expressions.add(operand);
            }
            if (expressions.isEmpty()) {
                if (negate) {
                    out.append("true");
                } else {
                    out.append("false");
                }
                return;
            }
            this.buildSimplifiedExpression(expressions, tokenType.equals(JavaTokenType.XOR) ? "^" : "!=", negate, out);
        } else if (tokenType.equals(JavaTokenType.EQEQ)) {
            boolean negate = false;
            for (PsiExpression operand : operands) {
                if (this.evaluate(operand) == Boolean.TRUE) continue;
                if (this.evaluate(operand) == Boolean.FALSE) {
                    negate = !negate;
                    continue;
                }
                expressions.add(operand);
            }
            if (expressions.isEmpty()) {
                if (negate) {
                    out.append("false");
                } else {
                    out.append("true");
                }
                return;
            }
            this.buildSimplifiedExpression(expressions, "==", negate, out);
        } else {
            out.append(expression.getText());
        }
    }

    private void buildSimplifiedExpression(List<PsiExpression> expressions, String token, boolean negate, StringBuilder out) {
        if (expressions.size() == 1) {
            PsiExpression expression = expressions.get(0);
            if (!negate) {
                out.append(expression.getText());
                return;
            }
            if (ComparisonUtils.isComparison(expression)) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                String negatedComparison = ComparisonUtils.getNegatedComparison(binaryExpression.getOperationTokenType());
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                assert (rhs != null);
                out.append(lhs.getText()).append(negatedComparison).append(rhs.getText());
            } else if (ParenthesesUtils.getPrecedence(expression) > 3) {
                out.append("!(").append(expression.getText()).append(')');
            } else {
                out.append('!').append(expression.getText());
            }
        } else {
            if (negate) {
                out.append("!(");
            }
            boolean useToken = false;
            for (PsiExpression expression : expressions) {
                if (useToken) {
                    out.append(token);
                    PsiElement previousSibling = expression.getPrevSibling();
                    if (previousSibling instanceof PsiWhiteSpace) {
                        out.append(previousSibling.getText());
                    }
                } else {
                    useToken = true;
                }
                this.buildSimplifiedExpression(expression, out);
                PsiElement nextSibling = expression.getNextSibling();
                if (!(nextSibling instanceof PsiWhiteSpace)) continue;
                out.append(nextSibling.getText());
            }
            if (negate) {
                out.append(')');
            }
        }
    }

    private void buildSimplifiedPrefixExpression(PsiPrefixExpression expression, StringBuilder out) {
        PsiJavaToken sign = expression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        PsiExpression operand = expression.getOperand();
        if (JavaTokenType.EXCL.equals(tokenType)) {
            Boolean value = this.evaluate(operand);
            if (value == Boolean.TRUE) {
                out.append("false");
                return;
            }
            if (value == Boolean.FALSE) {
                out.append("true");
                return;
            }
        }
        this.buildSimplifiedExpression(operand, out.append(sign.getText()));
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessBooleanExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBooleanExpressionVisitor();
    }

    @Nullable
    private Boolean evaluate(@Nullable PsiExpression expression) {
        Boolean value;
        PsiPrefixExpression prefixExpression;
        IElementType tokenType;
        if (expression == null || this.m_ignoreExpressionsContainingConstants && PointlessBooleanExpressionInspection.containsReference(expression)) {
            return null;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            return this.evaluate(parenthesizedExpression.getExpression());
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            IElementType tokenType2 = polyadicExpression.getOperationTokenType();
            if (tokenType2.equals(JavaTokenType.OROR)) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    if (this.evaluate(operand) != Boolean.TRUE) continue;
                    return Boolean.TRUE;
                }
            } else if (tokenType2.equals(JavaTokenType.ANDAND)) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    if (this.evaluate(operand) != Boolean.FALSE) continue;
                    return Boolean.FALSE;
                }
            }
        } else if (expression instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals(tokenType = (prefixExpression = (PsiPrefixExpression)expression).getOperationTokenType())) {
            PsiExpression operand = prefixExpression.getOperand();
            Boolean b = this.evaluate(operand);
            if (b == Boolean.FALSE) {
                return Boolean.TRUE;
            }
            if (b == Boolean.TRUE) {
                return Boolean.FALSE;
            }
        }
        return (value = (Boolean)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.BOOLEAN)) != null ? value : null;
    }

    private static boolean containsReference(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        ReferenceVisitor visitor = new ReferenceVisitor();
        expression.accept((PsiElementVisitor)visitor);
        return visitor.containsReference();
    }

    static {
        booleanTokens.add(JavaTokenType.ANDAND);
        booleanTokens.add(JavaTokenType.AND);
        booleanTokens.add(JavaTokenType.OROR);
        booleanTokens.add(JavaTokenType.OR);
        booleanTokens.add(JavaTokenType.XOR);
        booleanTokens.add(JavaTokenType.EQEQ);
        booleanTokens.add(JavaTokenType.NE);
    }

    private static class ReferenceVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean referenceFound;

        private ReferenceVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (this.referenceFound) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiElement target = expression.resolve();
            if (target instanceof PsiField && ExpressionUtils.isConstant((PsiField)target)) {
                this.referenceFound = true;
            } else {
                super.visitReferenceExpression(expression);
            }
        }

        private boolean containsReference() {
            return this.referenceFound;
        }
    }

    private class PointlessBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private PointlessBooleanExpressionVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(PsiExpression expression) {
            if (!this.isPointlessBooleanExpression(expression)) {
                return;
            }
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
            if (parent instanceof PsiExpression && this.isPointlessBooleanExpression((PsiExpression)parent)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean isPointlessBooleanExpression(PsiExpression expression) {
            if (expression instanceof PsiPrefixExpression) {
                return PointlessBooleanExpressionInspection.this.evaluate(expression) != null;
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                IElementType sign = polyadicExpression.getOperationTokenType();
                if (!booleanTokens.contains(sign)) {
                    return false;
                }
                PsiExpression[] operands = polyadicExpression.getOperands();
                boolean containsConstant = false;
                for (PsiExpression operand : operands) {
                    if (operand == null) {
                        return false;
                    }
                    PsiType type = operand.getType();
                    if (type == null || !type.equals(PsiType.BOOLEAN) && !type.equalsToText("java.lang.Boolean")) {
                        return false;
                    }
                    containsConstant |= PointlessBooleanExpressionInspection.this.evaluate(operand) != null;
                }
                return containsConstant;
            }
            return false;
        }
    }

    private class PointlessBooleanExpressionFix
    extends InspectionGadgetsFix {
        private PointlessBooleanExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection$PointlessBooleanExpressionFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            PsiReplacementUtil.replaceExpression(expression, PointlessBooleanExpressionInspection.this.buildSimplifiedExpression(expression, new StringBuilder()).toString());
        }
    }
}

