/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicInnerClassInspectionBase
extends BaseInspection {
    public boolean ignoreEnums = false;
    public boolean ignoreInterfaces = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.inner.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/PublicInnerClassInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.inner.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/PublicInnerClassInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("public.inner.class.ignore.enum.option", new Object[0]), "ignoreEnums");
        panel2.addCheckbox(InspectionGadgetsBundle.message("public.inner.class.ignore.interface.option", new Object[0]), "ignoreInterfaces");
        return panel2;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicInnerClassVisitor();
    }

    private class PublicInnerClassVisitor
    extends BaseInspectionVisitor {
        private PublicInnerClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/encapsulation/PublicInnerClassInspectionBase$PublicInnerClassVisitor", "visitClass"));
            }
            if (!aClass.hasModifierProperty("public")) {
                return;
            }
            if (!ClassUtils.isInnerClass(aClass)) {
                return;
            }
            if (PublicInnerClassInspectionBase.this.ignoreEnums && aClass.isEnum()) {
                return;
            }
            if (PublicInnerClassInspectionBase.this.ignoreInterfaces && aClass.isInterface()) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

