/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.errorhandling.ThrowsRuntimeExceptionInspectionBase;
import org.jetbrains.annotations.NotNull;

public class ThrowsRuntimeExceptionInspection
extends ThrowsRuntimeExceptionInspectionBase {
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        String exceptionName = (String)infos[0];
        if (MoveExceptionToJavadocFix.isApplicable((PsiJavaCodeReferenceElement)infos[1])) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ThrowsRuntimeExceptionFix(exceptionName), new MoveExceptionToJavadocFix(exceptionName)};
            if (inspectionGadgetsFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection", "buildFixes"));
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ThrowsRuntimeExceptionFix(exceptionName)};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    private static class ThrowsRuntimeExceptionFix
    extends InspectionGadgetsFix {
        private final String myClassName;

        public ThrowsRuntimeExceptionFix(String className) {
            this.myClassName = className;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("throws.runtime.exception.quickfix", this.myClassName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection$ThrowsRuntimeExceptionFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove from \"throws\" clause" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection$ThrowsRuntimeExceptionFix", "getFamilyName"));
            }
            return "Remove from \"throws\" clause";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            descriptor.getPsiElement().delete();
        }
    }

    private static class MoveExceptionToJavadocFix
    extends InspectionGadgetsFix {
        private final String myExceptionName;

        private MoveExceptionToJavadocFix(String exceptionName) {
            this.myExceptionName = exceptionName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("throws.runtime.exception.move.quickfix", this.myExceptionName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection$MoveExceptionToJavadocFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Move to Javadoc '@throws'" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection$MoveExceptionToJavadocFix", "getFamilyName"));
            }
            return "Move to Javadoc '@throws'";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method2 = (PsiMethod)grandParent;
            PsiDocComment comment = method2.getDocComment();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            if (comment != null) {
                PsiDocTag docTag = factory.createDocTagFromText("@throws " + element.getText());
                comment.add((PsiElement)docTag);
            } else {
                CodeDocumentationProvider codeDocumentationProvider;
                PsiDocComment docComment = factory.createDocCommentFromText("/** */");
                PsiComment resultComment = (PsiComment)method2.addBefore((PsiElement)docComment, (PsiElement)method2.getModifierList());
                DocumentationProvider documentationProvider = LanguageDocumentation.INSTANCE.forLanguage(method2.getLanguage());
                if (documentationProvider instanceof CodeDocumentationProvider) {
                    codeDocumentationProvider = (CodeDocumentationProvider)documentationProvider;
                } else if (documentationProvider instanceof CompositeDocumentationProvider) {
                    CompositeDocumentationProvider compositeDocumentationProvider = (CompositeDocumentationProvider)documentationProvider;
                    codeDocumentationProvider = compositeDocumentationProvider.getFirstCodeDocumentationProvider();
                    if (codeDocumentationProvider == null) {
                        return;
                    }
                } else {
                    return;
                }
                String commentStub = codeDocumentationProvider.generateDocumentationContentStub(resultComment);
                PsiDocComment newComment = factory.createDocCommentFromText("/**\n" + commentStub + "*/");
                resultComment.replace((PsiElement)newComment);
            }
            element.delete();
        }

        public static boolean isApplicable(@NotNull PsiJavaCodeReferenceElement reference) {
            PsiDocTag[] tags;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection$MoveExceptionToJavadocFix", "isApplicable"));
            }
            PsiElement parent = reference.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method2 = (PsiMethod)grandParent;
            PsiDocComment docComment = method2.getDocComment();
            if (docComment == null) {
                return true;
            }
            PsiElement throwsTarget = reference.resolve();
            if (throwsTarget == null) {
                return true;
            }
            for (PsiDocTag tag : tags = docComment.findTagsByName("throws")) {
                PsiJavaCodeReferenceElement referenceElement;
                PsiElement target;
                PsiElement grandChild;
                PsiElement child;
                PsiDocTagValue valueElement = tag.getValueElement();
                if (valueElement == null || (child = valueElement.getFirstChild()) == null || !((grandChild = child.getFirstChild()) instanceof PsiJavaCodeReferenceElement) || !throwsTarget.equals(target = (referenceElement = (PsiJavaCodeReferenceElement)grandChild).resolve())) continue;
                return false;
            }
            return true;
        }
    }
}

