/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.exceptions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiCatchCanBeSplitInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multi.catch.can.be.split.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/exceptions/MultiCatchCanBeSplitInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/exceptions/MultiCatchCanBeSplitInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SplitMultiCatchVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SplitMultiCatchFix();
    }

    private static void doFixImpl(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/exceptions/MultiCatchCanBeSplitInspection", "doFixImpl"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiCatchSection)) {
            return;
        }
        PsiCatchSection catchSection = (PsiCatchSection)parent;
        PsiElement grandParent = catchSection.getParent();
        if (!(grandParent instanceof PsiTryStatement)) {
            return;
        }
        PsiParameter parameter = catchSection.getParameter();
        if (parameter == null) {
            return;
        }
        PsiType type = parameter.getType();
        if (!(type instanceof PsiDisjunctionType)) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)element.getProject());
        for (PsiType disjunction : ((PsiDisjunctionType)type).getDisjunctions()) {
            PsiCatchSection copy = (PsiCatchSection)catchSection.copy();
            PsiTypeElement typeElement = (PsiTypeElement)ObjectUtils.assertNotNull((Object)((PsiParameter)ObjectUtils.assertNotNull((Object)copy.getParameter())).getTypeElement());
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(disjunction.getCanonicalText(true), (PsiElement)catchSection);
            PsiElement replaced = typeElement.replace((PsiElement)newTypeElement);
            grandParent.addBefore((PsiElement)copy, (PsiElement)catchSection);
            styleManager.shortenClassReferences(replaced);
        }
        catchSection.delete();
    }

    private static boolean isAcceptable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/exceptions/MultiCatchCanBeSplitInspection", "isAcceptable"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCatchSection) {
            PsiType type = ((PsiCatchSection)parent).getCatchType();
            return type instanceof PsiDisjunctionType;
        }
        return false;
    }

    private static class SplitMultiCatchFix
    extends InspectionGadgetsFix {
        private SplitMultiCatchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("multi.catch.can.be.split.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/exceptions/MultiCatchCanBeSplitInspection$SplitMultiCatchFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            MultiCatchCanBeSplitInspection.doFixImpl(descriptor.getPsiElement());
        }
    }

    private static class SplitMultiCatchVisitor
    extends BaseInspectionVisitor {
        private SplitMultiCatchVisitor() {
        }

        public void visitParameter(PsiParameter parameter) {
            super.visitParameter(parameter);
            if (MultiCatchCanBeSplitInspection.isAcceptable((PsiElement)parameter)) {
                this.registerError((PsiElement)parameter, new Object[0]);
            }
        }

        public void visitKeyword(PsiKeyword keyword) {
            super.visitKeyword(keyword);
            if (this.isOnTheFly() && keyword.getTokenType() == JavaTokenType.CATCH_KEYWORD && MultiCatchCanBeSplitInspection.isAcceptable((PsiElement)keyword)) {
                this.registerError((PsiElement)keyword, new Object[0]);
            }
        }
    }
}

