/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FinalizeInspection
extends BaseInspection {
    public boolean ignoreTrivialFinalizers = true;

    @NotNull
    public String getID() {
        if ("FinalizeDeclaration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeInspection", "getID"));
        }
        return "FinalizeDeclaration";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("finalize.declaration.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("finalize.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.trivial.finalizers.option", new Object[0]), (InspectionProfileEntry)this, "ignoreTrivialFinalizers");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinalizeDeclaredVisitor();
    }

    private class FinalizeDeclaredVisitor
    extends BaseInspectionVisitor {
        private FinalizeDeclaredVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/finalization/FinalizeInspection$FinalizeDeclaredVisitor", "visitMethod"));
            }
            if (!MethodUtils.isFinalize(method2)) {
                return;
            }
            if (FinalizeInspection.this.ignoreTrivialFinalizers && MethodUtils.isTrivial(method2, false)) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

