/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.InlineUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.HighlightUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InlineVariableFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("inline.variable.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/InlineVariableFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void doFix(@NotNull Project project2, ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/fixes/InlineVariableFix", "doFix"));
        }
        PsiElement nameElement = descriptor.getPsiElement();
        PsiLocalVariable variable = (PsiLocalVariable)nameElement.getParent();
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return;
        }
        Collection references = ReferencesSearch.search((PsiElement)variable).findAll();
        ArrayList<PsiExpression> replacedElements = new ArrayList<PsiExpression>();
        for (PsiReference reference : references) {
            PsiExpression expression = InlineUtil.inlineVariable((PsiVariable)variable, initializer, (PsiJavaCodeReferenceElement)reference);
            replacedElements.add(expression);
        }
        HighlightUtils.highlightElements(replacedElements);
        variable.delete();
    }
}

