/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CallToSuspiciousStringMethodInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.suspicious.string.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/CallToSuspiciousStringMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.suspicious.string.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/CallToSuspiciousStringMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSuspiciousStringMethodVisitor();
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiModifierListOwner annotatableArgument;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        ArrayList<DelegatingFix> result2 = new ArrayList<DelegatingFix>();
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiModifierListOwner annotatableQualifier = NonNlsUtils.getAnnotatableQualifier(methodExpression);
        if (annotatableQualifier != null) {
            DelegatingFix fix = new DelegatingFix((LocalQuickFix)new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", annotatableQualifier, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
            result2.add(fix);
        }
        if ((annotatableArgument = NonNlsUtils.getAnnotatableArgument(methodCallExpression)) != null) {
            DelegatingFix fix = new DelegatingFix((LocalQuickFix)new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", annotatableArgument, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
            result2.add(fix);
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result2.toArray(new InspectionGadgetsFix[result2.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/CallToSuspiciousStringMethodInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    private static class CallToSuspiciousStringMethodVisitor
    extends BaseInspectionVisitor {
        private CallToSuspiciousStringMethodVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (!(MethodCallUtils.isEqualsCall(expression) || MethodCallUtils.isEqualsIgnoreCaseCall(expression) || MethodCallUtils.isCompareToCall(expression) || MethodCallUtils.isCompareToIgnoreCaseCall(expression))) {
                return;
            }
            PsiMethod method2 = expression.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (NonNlsUtils.isNonNlsAnnotated(qualifier)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1 || NonNlsUtils.isNonNlsAnnotated(arguments[0])) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }
    }
}

