/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VarargParameterInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("VariableArgumentMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/VarargParameterInspection", "getID"));
        }
        return "VariableArgumentMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("variable.argument.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/VarargParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("variable.argument.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/VarargParameterInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new VarargParameterFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new VarargParameterVisitor();
    }

    private static class VarargParameterVisitor
    extends BaseInspectionVisitor {
        private VarargParameterVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/jdk/VarargParameterInspection$VarargParameterVisitor", "visitMethod"));
            }
            PsiParameter[] parameters = method2.getParameterList().getParameters();
            if (parameters.length == 0) {
                return;
            }
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (lastParameter.isVarArgs()) {
                this.registerMethodError(method2, new Object[0]);
            }
        }
    }

    private static class VarargParameterFix
    extends InspectionGadgetsFix {
        private VarargParameterFix() {
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("variable.argument.method.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/VarargParameterInspection$VarargParameterFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiMethod method2 = (PsiMethod)element.getParent();
            PsiParameterList parameterList = method2.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length == 0) {
                return;
            }
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (!lastParameter.isVarArgs()) {
                return;
            }
            PsiTypeElement typeElement = lastParameter.getTypeElement();
            if (typeElement == null) {
                return;
            }
            Collection references = ReferencesSearch.search((PsiElement)method2).findAll();
            ArrayList<Object> prepare2 = new ArrayList<Object>();
            prepare2.add(parameterList);
            for (PsiReference reference : references) {
                prepare2.add(reference.getElement());
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(prepare2)) {
                return;
            }
            WriteAction.run(() -> {
                String typeText;
                PsiEllipsisType type = (PsiEllipsisType)lastParameter.getType();
                PsiType componentType = type.getComponentType();
                if (componentType instanceof PsiClassType) {
                    PsiClassType classType = (PsiClassType)componentType;
                    typeText = classType.rawType().getCanonicalText();
                } else {
                    typeText = componentType.getCanonicalText();
                }
                for (PsiReference reference : references) {
                    VarargParameterFix.modifyCall(reference, typeText, parameters.length - 1);
                }
                PsiType arrayType = type.toArrayType();
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)lastParameter.getProject());
                PsiTypeElement newTypeElement = factory.createTypeElement(arrayType);
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method2, (String[])new String[]{"java.lang.SafeVarargs"});
                if (annotation != null) {
                    annotation.delete();
                }
                typeElement.replace((PsiElement)newTypeElement);
            });
        }

        public static void modifyCall(PsiReference reference, String arrayTypeText, int indexOfFirstVarargArgument) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)reference.getElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)referenceExpression.getParent();
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            StringBuilder builder = new StringBuilder("new ");
            builder.append(arrayTypeText);
            builder.append("[]{");
            if (arguments.length > indexOfFirstVarargArgument) {
                PsiExpression firstArgument = arguments[indexOfFirstVarargArgument];
                String firstArgumentText = firstArgument.getText();
                builder.append(firstArgumentText);
                for (int i2 = indexOfFirstVarargArgument + 1; i2 < arguments.length; ++i2) {
                    builder.append(',').append(arguments[i2].getText());
                }
            }
            builder.append('}');
            Project project2 = referenceExpression.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiExpression arrayExpression = factory.createExpressionFromText(builder.toString(), (PsiElement)referenceExpression);
            if (arguments.length > indexOfFirstVarargArgument) {
                PsiExpression firstArgument = arguments[indexOfFirstVarargArgument];
                argumentList.deleteChildRange((PsiElement)firstArgument, (PsiElement)arguments[arguments.length - 1]);
                argumentList.add((PsiElement)arrayExpression);
            } else {
                argumentList.add((PsiElement)arrayExpression);
            }
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)argumentList);
            CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)argumentList);
        }
    }
}

